/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport.legacy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.MondrianSchemaAnnotator;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.action.olap.IOlapServiceException;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.StreamConverter;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;

public class MondrianCatalogRepositoryHelper {
    public static final String ETC_MONDRIAN_JCR_FOLDER = ClientRepositoryPaths.getEtcFolderPath() + "/" + "mondrian";
    public static final String ETC_OLAP_SERVERS_JCR_FOLDER = ClientRepositoryPaths.getEtcFolderPath() + "/" + "olap-servers";
    private boolean isSecured = false;
    private static final Log logger = LogFactory.getLog(MondrianCatalogRepositoryHelper.class);
    private IUnifiedRepository repository;

    public MondrianCatalogRepositoryHelper(IUnifiedRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this.repository = repository;
        try {
            if (PentahoSystem.get(IUserRoleListService.class) != null) {
                this.isSecured = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initOlapServersFolder();
    }

    @Deprecated
    public void addSchema(InputStream mondrianFile, String catalogName, String datasourceInfo) throws Exception {
        this.addHostedCatalog(mondrianFile, catalogName, datasourceInfo);
    }

    public void addHostedCatalog(InputStream mondrianFile, String catalogName, String datasourceInfo) throws Exception {
        RepositoryFile catalog = this.createCatalog(catalogName, datasourceInfo);
        File tempFile = File.createTempFile("tempFile", null);
        tempFile.deleteOnExit();
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        IOUtils.copy((InputStream)mondrianFile, (OutputStream)outputStream);
        RepositoryFile repoFile = new RepositoryFile.Builder("schema.xml").build();
        RepositoryFileBundle repoFileBundle = new RepositoryFileBundle(repoFile, null, ETC_MONDRIAN_JCR_FOLDER + "/" + catalogName + "/", tempFile, "UTF-8", "text/xml");
        RepositoryFile schema = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER + "/" + catalogName + "/" + "schema.xml");
        IRepositoryFileData data = new StreamConverter().convert(repoFileBundle.getInputStream(), repoFileBundle.getCharset(), repoFileBundle.getMimeType());
        if (schema == null) {
            RepositoryFile catalogFolder;
            RepositoryFile schemaFile = this.repository.createFile(catalog.getId(), repoFileBundle.getFile(), data, null);
            if (schemaFile != null && (catalogFolder = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER + "/" + catalogName)).isHidden() != schemaFile.isHidden()) {
                RepositoryFile unhiddenFolder = new RepositoryFile.Builder(catalogFolder).hidden(schemaFile.isHidden().booleanValue()).build();
                this.repository.updateFolder(unhiddenFolder, "");
            }
        } else {
            this.repository.updateFile(schema, data, null);
        }
    }

    public void deleteCatalog(String catalogName) {
        this.deleteHostedCatalog(catalogName);
        this.deleteOlap4jServer(catalogName);
    }

    public void deleteHostedCatalog(String catalogName) {
        RepositoryFile catalogNode = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER + "/" + catalogName);
        if (catalogNode != null) {
            this.repository.deleteFile(catalogNode.getId(), true, "Deleting hosted catalog: " + catalogName);
        }
    }

    private void initOlapServersFolder() {
        RepositoryFile etcOlapServers = this.repository.getFile(ETC_OLAP_SERVERS_JCR_FOLDER);
        if (etcOlapServers == null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MondrianCatalogRepositoryHelper.this.repository.createFolder(MondrianCatalogRepositoryHelper.this.repository.getFile("/etc").getId(), new RepositoryFile.Builder("olap-servers").folder(true).build(), "Creating olap-servers directory in /etc");
                    return null;
                }
            };
            try {
                if (this.isSecured) {
                    SecurityHelper.getInstance().runAsSystem((Callable)callable);
                } else {
                    callable.call();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create folder /etc/olap-servers in the repository.", e);
            }
        }
    }

    public void addOlap4jServer(String name, String className, String URL2, String user, String password, Properties props) {
        String xmlProperties;
        RepositoryFile etcOlapServers = this.repository.getFile(ETC_OLAP_SERVERS_JCR_FOLDER);
        RepositoryFile entry = this.repository.getFile(ETC_OLAP_SERVERS_JCR_FOLDER + "/" + name);
        if (entry == null) {
            entry = this.repository.createFolder(etcOlapServers.getId(), new RepositoryFile.Builder(name).folder(true).build(), "Creating entry for olap server: " + name + " into folder " + ETC_OLAP_SERVERS_JCR_FOLDER);
        }
        String path = ETC_OLAP_SERVERS_JCR_FOLDER + "/" + name + "/" + "metadata";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            props.storeToXML((OutputStream)os, "Connection properties for server: " + name, "UTF-8");
            xmlProperties = os.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        DataNode node = new DataNode("server");
        node.setProperty("name", name);
        node.setProperty("className", className);
        node.setProperty("URL", URL2);
        node.setProperty("user", user);
        node.setProperty("password", password);
        node.setProperty("properties", xmlProperties);
        NodeRepositoryFileData data = new NodeRepositoryFileData(node);
        RepositoryFile metadata = this.repository.getFile(path);
        if (metadata == null) {
            this.repository.createFile(entry.getId(), new RepositoryFile.Builder("metadata").build(), (IRepositoryFileData)data, "Creating olap-server metadata for server " + name);
        } else {
            this.repository.updateFile(metadata, (IRepositoryFileData)data, "Updating olap-server metadata for server " + name);
        }
    }

    public void deleteOlap4jServer(String name) {
        RepositoryFile serverNode = this.repository.getFile(ETC_OLAP_SERVERS_JCR_FOLDER + "/" + name);
        if (serverNode != null) {
            this.repository.deleteFile(serverNode.getId(), true, "Deleting olap server: " + name);
        }
    }

    public List<String> getOlap4jServers() {
        RepositoryFile hostedFolder = this.repository.getFile(ETC_OLAP_SERVERS_JCR_FOLDER);
        if (hostedFolder == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (RepositoryFile repoFile : this.repository.getChildren(hostedFolder.getId())) {
            names.add(repoFile.getName());
        }
        return names;
    }

    public Olap4jServerInfo getOlap4jServerInfo(String name) {
        RepositoryFile serverNode = this.repository.getFile(ETC_OLAP_SERVERS_JCR_FOLDER + "/" + name + "/" + "metadata");
        if (serverNode != null) {
            return new Olap4jServerInfo(serverNode);
        }
        return null;
    }

    public List<String> getHostedCatalogs() {
        ArrayList<String> names = new ArrayList<String>();
        RepositoryFile serversFolder = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER);
        if (serversFolder != null) {
            for (RepositoryFile repoFile : this.repository.getChildren(serversFolder.getId())) {
                names.add(repoFile.getName());
            }
        }
        return names;
    }

    public HostedCatalogInfo getHostedCatalogInfo(String name) {
        RepositoryFile catalogNode = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER + "/" + name + "/" + "metadata");
        if (catalogNode != null) {
            return new HostedCatalogInfo(name, catalogNode);
        }
        return null;
    }

    public Map<String, InputStream> getModrianSchemaFiles(String catalogName) {
        HashMap<String, InputStream> values = new HashMap<String, InputStream>();
        RepositoryFile catalogFolder = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER + "/" + catalogName);
        if (catalogFolder == null) {
            logger.warn((Object)("Catalog " + catalogName + " not found"));
            throw new RepositoryException("Catalog " + catalogName + " not found");
        }
        for (RepositoryFile repoFile : this.repository.getChildren(catalogFolder.getId())) {
            RepositoryFileInputStream is;
            if (repoFile.getName().equals("metadata")) continue;
            try {
                is = new RepositoryFileInputStream(repoFile, this.repository);
            }
            catch (FileNotFoundException e) {
                throw new RepositoryException((Throwable)e);
            }
            values.put(repoFile.getName(), (InputStream)is);
        }
        if (values.containsKey("annotations.xml") && values.containsKey("schema.xml")) {
            return this.includeAnnotatedSchema(values);
        }
        return values;
    }

    private Map<String, InputStream> includeAnnotatedSchema(Map<String, InputStream> values) {
        MondrianSchemaAnnotator annotator = (MondrianSchemaAnnotator)PentahoSystem.get(MondrianSchemaAnnotator.class, (String)"inlineModeling", (IPentahoSession)PentahoSessionHolder.getSession());
        try {
            if (annotator != null) {
                byte[] schemaBytes = IOUtils.toByteArray((InputStream)values.get("schema.xml"));
                byte[] annotationBytes = IOUtils.toByteArray((InputStream)values.get("annotations.xml"));
                values.put("schema.xml", new ByteArrayInputStream(schemaBytes));
                values.put("annotations.xml", new ByteArrayInputStream(annotationBytes));
                values.put("schema.annotated.xml", annotator.getInputStream((InputStream)new ByteArrayInputStream(schemaBytes), (InputStream)new ByteArrayInputStream(annotationBytes)));
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return values;
    }

    public RepositoryFile getMondrianCatalogFile(String catalogName) {
        return this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER + "/" + catalogName);
    }

    private RepositoryFile createCatalog(String catalogName, String datasourceInfo) {
        RepositoryFile catalog = this.getMondrianCatalogFile(catalogName);
        if (catalog == null) {
            RepositoryFile etcMondrian = this.repository.getFile(ETC_MONDRIAN_JCR_FOLDER);
            catalog = this.repository.createFolder(etcMondrian.getId(), new RepositoryFile.Builder(catalogName).folder(true).build(), "");
        }
        this.createDatasourceMetadata(catalog, datasourceInfo);
        return catalog;
    }

    private void createDatasourceMetadata(RepositoryFile catalog, String datasourceInfo) {
        String path = ETC_MONDRIAN_JCR_FOLDER + "/" + catalog.getName() + "/" + "metadata";
        RepositoryFile metadata = this.repository.getFile(path);
        String definition = "mondrian:/" + catalog.getName();
        DataNode node = new DataNode("catalog");
        node.setProperty("definition", this.encodeUrl(definition));
        node.setProperty("datasourceInfo", datasourceInfo);
        NodeRepositoryFileData data = new NodeRepositoryFileData(node);
        if (metadata == null) {
            this.repository.createFile(catalog.getId(), new RepositoryFile.Builder("metadata").build(), (IRepositoryFileData)data, null);
        } else {
            this.repository.updateFile(metadata, (IRepositoryFileData)data, null);
        }
    }

    private String makeHostedPath(String name) {
        return ETC_MONDRIAN_JCR_FOLDER + "/" + name;
    }

    private String makeGenericPath(String name) {
        return ETC_OLAP_SERVERS_JCR_FOLDER + "/" + name;
    }

    private boolean isHosted(String name) {
        return this.getHostedCatalogs().contains(name);
    }

    private String makePath(String catalogName) {
        if (this.isHosted(catalogName)) {
            return this.makeHostedPath(catalogName);
        }
        return this.makeGenericPath(catalogName);
    }

    public boolean hasAccess(String catalogName, EnumSet<RepositoryFilePermission> perms, IPentahoSession session) {
        if (session == null) {
            return true;
        }
        String path = !this.getHostedCatalogs().contains(catalogName) && !this.getOlap4jServers().contains(catalogName) && perms.contains(RepositoryFilePermission.WRITE) ? (this.isHosted(catalogName) ? ETC_MONDRIAN_JCR_FOLDER : ETC_OLAP_SERVERS_JCR_FOLDER) : this.makePath(catalogName);
        IPentahoSession origSession = PentahoSessionHolder.getSession();
        PentahoSessionHolder.setSession((IPentahoSession)session);
        try {
            boolean bl = this.repository.hasAccess(path, perms);
            return bl;
        }
        catch (Exception e) {
            throw new IOlapServiceException(e);
        }
        finally {
            PentahoSessionHolder.setSession((IPentahoSession)origSession);
        }
    }

    private String encodeUrl(String urlStr) {
        String protocol = urlStr.substring(0, urlStr.indexOf(":") + 1);
        String datasourcePath = urlStr.substring(protocol.length());
        String[] folders = datasourcePath.split("/");
        StringBuilder encodedPath = new StringBuilder(urlStr.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            String pathPart;
            try {
                Charset urlCharset = Charset.forName("UTF-8");
                pathPart = URLEncoder.encode(folders[i], urlCharset.name());
            }
            catch (UnsupportedEncodingException e) {
                pathPart = folders[i];
            }
            encodedPath.append(pathPart);
            if (i == folders.length - 1 && !urlStr.endsWith("/")) continue;
            encodedPath.append("/");
        }
        return protocol + encodedPath.toString();
    }

    public final class Olap4jServerInfo {
        public final String name;
        public final String className;
        public final String URL;
        public final String user;
        public final String password;
        public final Properties properties;

        private Olap4jServerInfo(RepositoryFile source) {
            NodeRepositoryFileData data = (NodeRepositoryFileData)MondrianCatalogRepositoryHelper.this.repository.getDataForRead(source.getId(), NodeRepositoryFileData.class);
            this.name = data.getNode().getProperty("name").getString();
            this.className = data.getNode().getProperty("className").getString();
            this.URL = data.getNode().getProperty("URL").getString();
            DataProperty userProp = data.getNode().getProperty("user");
            this.user = userProp == null ? null : userProp.getString();
            DataProperty passwordProp = data.getNode().getProperty("password");
            this.password = passwordProp == null ? null : passwordProp.getString();
            this.properties = new Properties();
            String propertiesXml = data.getNode().getProperty("properties").getString();
            try {
                this.properties.loadFromXML(new ByteArrayInputStream(propertiesXml.getBytes("UTF-8")));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public final class HostedCatalogInfo {
        public final String name;
        public final String dataSourceInfo;
        public final String definition;

        public HostedCatalogInfo(String name, RepositoryFile source) {
            NodeRepositoryFileData data = (NodeRepositoryFileData)MondrianCatalogRepositoryHelper.this.repository.getDataForRead(source.getId(), NodeRepositoryFileData.class);
            this.name = name;
            this.dataSourceInfo = data.getNode().getProperty("datasourceInfo").getString();
            this.definition = data.getNode().getProperty("definition").getString();
        }

        public HostedCatalogInfo(String name, String dataSourceInfo, String definition) {
            this.name = name;
            this.dataSourceInfo = dataSourceInfo;
            this.definition = definition;
        }
    }
}

