/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.CsrfProtectionDefinition;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentGeneratorInvoker;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IObjectCreator;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoObjectRegistration;
import org.pentaho.platform.api.engine.IPentahoRegistrableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPlatformPluginCsrfProtection;
import org.pentaho.platform.api.engine.IPluginLifecycleListener;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginManagerListener;
import org.pentaho.platform.api.engine.IPluginProvider;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PlatformPluginRegistrationException;
import org.pentaho.platform.api.engine.PluginBeanDefinition;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.platform.api.engine.PluginServiceDefinition;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.api.engine.ServiceInitializationException;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.platform.config.PropertiesFileConfiguration;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.StandaloneSpringPentahoObjectFactory;
import org.pentaho.platform.engine.core.system.objfac.references.PrototypePentahoObjectReference;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;
import org.pentaho.platform.engine.core.system.objfac.spring.PentahoBeanScopeValidatorPostProcessor;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.pentaho.platform.plugin.services.pluginmgr.PluginMessageLogger;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.ServiceConfig;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.ui.xul.XulOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PentahoSystemPluginManager
implements IPluginManager {
    private static final String DEFAULT_PERSPECTIVE = "generatedContent";
    private static final String METAPROVIDER_KEY_PREFIX = "METAPROVIDER-";
    public static final String CONTENT_TYPE = "content-type";
    public static final String PLUGIN_ID = "plugin-id";
    public static final String SETTINGS_PREFIX = "settings/";
    private final Multimap<String, IPentahoObjectRegistration> handleRegistry = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    private ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<IPluginManagerListener> listeners = new HashSet<IPluginManagerListener>();

    private static void createAndRegisterLifecycleListeners(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        Object listener = null;
        try {
            if (!StringUtils.isEmpty((String)plugin.getLifecycleListenerClassname())) {
                listener = loader.loadClass(plugin.getLifecycleListenerClassname()).newInstance();
            }
        }
        catch (Throwable t) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0017_COULD_NOT_LOAD_PLUGIN_LIFECYCLE_LISTENER", new Object[]{plugin.getId(), plugin.getLifecycleListenerClassname()}), t);
        }
        if (listener != null) {
            if (!IPluginLifecycleListener.class.isAssignableFrom(listener.getClass())) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0016_PLUGIN_LIFECYCLE_LISTENER_WRONG_TYPE", new Object[]{plugin.getId(), plugin.getLifecycleListenerClassname()}));
            }
            plugin.addLifecycleListener((IPluginLifecycleListener)listener);
        }
    }

    public Set<String> getContentTypes() {
        HashSet<String> types = new HashSet<String>();
        List contentInfos = PentahoSystem.getAll(IContentInfo.class, null);
        for (IContentInfo contentInfo : contentInfos) {
            types.add(contentInfo.getExtension());
        }
        return types;
    }

    public IContentInfo getContentTypeInfo(String type) {
        if (type.contains(".")) {
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        return (IContentInfo)PentahoSystem.get(IContentInfo.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap("extension", type));
    }

    public IContentGenerator getContentGeneratorForType(String type, IPentahoSession session) throws ObjectFactoryException {
        IContentGeneratorInvoker cgInvoker = (IContentGeneratorInvoker)PentahoSystem.get(IContentGeneratorInvoker.class);
        if (cgInvoker != null && cgInvoker.isSupportedContent(type)) {
            this.logger.info("Located IContentGeneratorInvoker that supports content of type '" + type + "':" + cgInvoker.getClass().getName());
            return cgInvoker.getContentGenerator();
        }
        return (IContentGenerator)PentahoSystem.get(IContentGenerator.class, (IPentahoSession)session, Collections.singletonMap(CONTENT_TYPE, type));
    }

    public boolean reload() {
        return this.reload(PentahoSessionHolder.getSession());
    }

    private void unloadPlugins() {
        for (IPlatformPlugin plugin : PentahoSystem.getAll(IPlatformPlugin.class)) {
            ClassLoader classLoader;
            try {
                plugin.unLoaded();
                GenericApplicationContext appContext = (GenericApplicationContext)PentahoSystem.get(GenericApplicationContext.class, null, Collections.singletonMap(PLUGIN_ID, plugin.getId()));
                if (appContext != null) {
                    StandaloneSpringPentahoObjectFactory pentahoObjectFactory = StandaloneSpringPentahoObjectFactory.getInstance((ApplicationContext)appContext);
                    if (pentahoObjectFactory != null) {
                        PentahoSystem.deregisterObjectFactory((IPentahoObjectFactory)pentahoObjectFactory);
                    }
                    appContext.close();
                }
            }
            catch (Throwable t) {
                String msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0014_PLUGIN_FAILED_TO_PROPERLY_UNLOAD", new Object[]{plugin.getId()});
                this.logger.error(this.getClass().toString(), (Object)msg, (Object)t);
                PluginMessageLogger.add(msg);
            }
            if ((classLoader = (ClassLoader)PentahoSystem.get(ClassLoader.class, null, Collections.singletonMap(PLUGIN_ID, plugin.getId()))) == null) continue;
            try {
                ((PluginClassLoader)classLoader).close();
            }
            catch (IOException e) {
                this.logger.error("errror closing plugin clasloader", (Throwable)e);
            }
        }
        for (Map.Entry entry : this.handleRegistry.entries()) {
            ((IPentahoObjectRegistration)entry.getValue()).remove();
        }
        this.handleRegistry.clear();
    }

    public boolean reload(IPentahoSession session) {
        String msg;
        boolean anyErrors = false;
        IPluginProvider pluginProvider = (IPluginProvider)PentahoSystem.get(IPluginProvider.class, (String)"IPluginProvider", (IPentahoSession)session);
        List providedPlugins = Collections.emptyList();
        try {
            this.unloadPlugins();
            providedPlugins = pluginProvider.getPlugins(session);
        }
        catch (PlatformPluginRegistrationException e1) {
            String msg2 = Messages.getInstance().getErrorString("PluginManager.ERROR_0012_PLUGIN_DISCOVERY_FAILED");
            org.pentaho.platform.util.logging.Logger.error((String)this.getClass().toString(), (String)msg2, (Throwable)e1);
            PluginMessageLogger.add(msg2);
            anyErrors = true;
        }
        for (IPlatformPlugin plugin : providedPlugins) {
            try {
                IPlatformPlugin existingPlugin = (IPlatformPlugin)PentahoSystem.get(IPlatformPlugin.class, null, Collections.singletonMap(PLUGIN_ID, plugin.getId()));
                if (existingPlugin != null) {
                    throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0024_PLUGIN_ALREADY_LOADED_BY_SAME_NAME", new Object[]{plugin.getId()}));
                }
                ClassLoader classloader = this.createClassloader(plugin);
                IPentahoObjectRegistration handle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(IPlatformPlugin.class).object((Object)plugin)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).build(), (Class[])new Class[]{IPlatformPlugin.class});
                this.registerReference(plugin.getId(), handle);
                handle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(ClassLoader.class).object((Object)classloader)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).build(), (Class[])new Class[]{ClassLoader.class});
                this.registerReference(plugin.getId(), handle);
                GenericApplicationContext beanFactory = this.createBeanFactory(plugin, classloader);
                StandaloneSpringPentahoObjectFactory pentahoFactory = new StandaloneSpringPentahoObjectFactory("Plugin Factory ( " + plugin.getId() + " )");
                pentahoFactory.init(null, (Object)beanFactory);
                beanFactory.refresh();
                handle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(GenericApplicationContext.class).object((Object)beanFactory)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).build(), (IPentahoRegistrableObjectFactory.Types)IPentahoRegistrableObjectFactory.Types.ALL);
                this.registerReference(plugin.getId(), handle);
                handle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(IPentahoObjectFactory.class).object((Object)pentahoFactory)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).build(), (Class[])new Class[]{IPentahoObjectFactory.class});
                this.registerReference(plugin.getId(), handle);
            }
            catch (Throwable t) {
                anyErrors = true;
                msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0011_FAILED_TO_REGISTER_PLUGIN", new Object[]{plugin.getId()});
                org.pentaho.platform.util.logging.Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                PluginMessageLogger.add(msg);
            }
        }
        for (IPlatformPlugin plugin : providedPlugins) {
            try {
                this.registerPlugin(plugin);
            }
            catch (Throwable t) {
                anyErrors = true;
                msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0011_FAILED_TO_REGISTER_PLUGIN", new Object[]{plugin.getId()});
                org.pentaho.platform.util.logging.Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                PluginMessageLogger.add(msg);
            }
        }
        IServiceManager svcManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, null);
        if (svcManager != null) {
            try {
                svcManager.initServices();
            }
            catch (ServiceInitializationException e) {
                String msg3 = Messages.getInstance().getErrorString("PluginManager.ERROR_0022_SERVICE_INITIALIZATION_FAILED");
                org.pentaho.platform.util.logging.Logger.error((String)this.getClass().toString(), (String)msg3, (Throwable)e);
                PluginMessageLogger.add(msg3);
            }
        }
        for (IPluginManagerListener listener : this.listeners) {
            listener.onReload();
        }
        return !anyErrors;
    }

    private void registerPlugin(IPlatformPlugin plugin) throws PlatformPluginRegistrationException, PluginLifecycleException {
        if (StringUtils.isEmpty((String)plugin.getId())) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0026_PLUGIN_INVALID", new Object[]{plugin.getSourceDescription()}));
        }
        ClassLoader loader = (ClassLoader)PentahoSystem.get(ClassLoader.class, null, Collections.singletonMap(PLUGIN_ID, plugin.getId()));
        GenericApplicationContext beanFactory = (GenericApplicationContext)PentahoSystem.get(GenericApplicationContext.class, null, Collections.singletonMap(PLUGIN_ID, plugin.getId()));
        PentahoSystemPluginManager.createAndRegisterLifecycleListeners(plugin, loader);
        plugin.init();
        this.registerContentTypes(plugin, loader, beanFactory);
        this.registerContentGenerators(plugin, loader, beanFactory);
        this.registerPerspectives(plugin, loader);
        this.registerOverlays(plugin);
        this.registerSettings(plugin, loader);
        this.registerServices(plugin, loader, beanFactory);
        if (plugin instanceof IPlatformPluginCsrfProtection) {
            this.registerCsrfProtection(plugin, (IPlatformPluginCsrfProtection)plugin);
        }
        PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.PLUGIN_REGISTERED", new Object[]{plugin.getId()}));
        try {
            plugin.loaded();
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0015_PLUGIN_LOADED_HANDLING_FAILED", new Object[]{plugin.getId()});
            org.pentaho.platform.util.logging.Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
            PluginMessageLogger.add(msg);
        }
    }

    private void registerOverlays(IPlatformPlugin plugin) {
        int priority = plugin.getOverlays().size();
        for (XulOverlay overlay : plugin.getOverlays()) {
            IPentahoObjectRegistration referenceHandle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(XulOverlay.class).object((Object)overlay)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).priority(priority)).build(), (Class[])new Class[]{XulOverlay.class});
            --priority;
            this.registerReference(plugin.getId(), referenceHandle);
        }
    }

    private void registerServices(IPlatformPlugin plugin, ClassLoader loader, GenericApplicationContext beanFactory) throws PlatformPluginRegistrationException {
        IServiceManager svcManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, null);
        for (PluginServiceDefinition pws : plugin.getServices()) {
            for (ServiceConfig ws : this.createServiceConfigs(pws, plugin, loader, beanFactory)) {
                try {
                    svcManager.registerService((IServiceConfig)ws);
                }
                catch (ServiceException e) {
                    throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0025_SERVICE_REGISTRATION_FAILED", new Object[]{ws.getId(), plugin.getId()}), (Throwable)e);
                }
            }
        }
    }

    private Collection<ServiceConfig> createServiceConfigs(PluginServiceDefinition pws, IPlatformPlugin plugin, ClassLoader loader, GenericApplicationContext beanFactory) throws PlatformPluginRegistrationException {
        ArrayList<ServiceConfig> services = new ArrayList<ServiceConfig>();
        if (pws.getTypes() == null || pws.getTypes().length < 1) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0023_SERVICE_TYPE_UNSPECIFIED", new Object[]{pws.getId()}));
        }
        for (String type : pws.getTypes()) {
            String serviceId;
            String serviceClassName;
            ServiceConfig ws = new ServiceConfig();
            ws.setServiceType(type);
            ws.setTitle(pws.getTitle());
            ws.setDescription(pws.getDescription());
            String string = serviceClassName = StringUtils.isEmpty((String)pws.getServiceClass()) ? pws.getServiceBeanId() : pws.getServiceClass();
            if (!StringUtils.isEmpty((String)pws.getId())) {
                serviceId = pws.getId();
            } else {
                serviceId = serviceClassName;
                if (serviceClassName.indexOf(46) > 0) {
                    serviceId = serviceClassName.substring(serviceClassName.lastIndexOf(46) + 1);
                }
            }
            ws.setId(serviceId);
            String serviceClassKey = ws.getServiceType() + "-" + ws.getId() + "/" + serviceClassName;
            this.assertUnique(beanFactory, plugin.getId(), serviceClassKey);
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)serviceClassName).setScope("prototype").getBeanDefinition();
            beanFactory.registerBeanDefinition(serviceClassKey, (BeanDefinition)beanDef);
            if (!this.isBeanRegistered(serviceClassKey)) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0020_NO_SERVICE_CLASS_REGISTERED", new Object[]{serviceClassKey}));
            }
            try {
                ws.setServiceClass(this.loadClass(serviceClassKey));
                ArrayList classes = new ArrayList();
                if (pws.getExtraClasses() != null) {
                    for (String extraClass : pws.getExtraClasses()) {
                        classes.add(this.loadClass(extraClass));
                    }
                }
                ws.setExtraClasses(classes);
            }
            catch (PluginBeanException e) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0021_SERVICE_CLASS_LOAD_FAILED", new Object[]{serviceClassKey}), (Throwable)e);
            }
            services.add(ws);
        }
        return services;
    }

    private void registerSettings(IPlatformPlugin plugin, ClassLoader loader) {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        InputStream stream = resLoader.getResourceAsStream(loader, "settings.xml");
        if (stream == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            Document docFromStream = XmlDom4JHelper.getDocFromStream((InputStream)stream);
            for (Object element : docFromStream.getRootElement().elements()) {
                Element ele = (Element)element;
                String name = ele.getName();
                String value = ele.getText();
                properties.put(SETTINGS_PREFIX + name, value);
            }
        }
        catch (IOException | DocumentException e) {
            this.logger.error("Error parsing settings.xml for plugin: " + plugin.getId(), e);
        }
        try {
            this.systemConfig.registerConfiguration((IConfiguration)new PropertiesFileConfiguration(plugin.getId(), properties));
        }
        catch (IOException e) {
            this.logger.error("Error registering settings.xml for plugin: " + plugin.getId(), (Throwable)e);
        }
    }

    private void registerPerspectives(IPlatformPlugin plugin, ClassLoader loader) {
        for (IPluginPerspective pluginPerspective : plugin.getPluginPerspectives()) {
            IPentahoObjectRegistration referenceHandle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(IPluginPerspective.class).object((Object)pluginPerspective)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).build(), (Class[])new Class[]{IPluginPerspective.class});
            this.registerReference(plugin.getId(), referenceHandle);
        }
    }

    private void registerContentGenerators(IPlatformPlugin plugin, ClassLoader loader, final GenericApplicationContext beanFactory) throws PlatformPluginRegistrationException {
        for (final IContentGeneratorInfo cgInfo : plugin.getContentGenerators()) {
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)cgInfo.getClassname()).setScope("prototype").getBeanDefinition();
            beanFactory.registerBeanDefinition(cgInfo.getId(), (BeanDefinition)beanDef);
            beanFactory.registerAlias(cgInfo.getId(), cgInfo.getType());
            PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_GENERATOR_REGISTERED", new Object[]{cgInfo.getId(), plugin.getId()}));
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(PLUGIN_ID, plugin.getId());
            attributes.put(CONTENT_TYPE, cgInfo.getType());
            IPentahoObjectRegistration referenceHandle = PentahoSystem.registerReference((IPentahoObjectReference)((PrototypePentahoObjectReference.Builder)((PrototypePentahoObjectReference.Builder)new PrototypePentahoObjectReference.Builder(IContentGenerator.class).creator((IObjectCreator)new IObjectCreator<IContentGenerator>(){

                public IContentGenerator create(IPentahoSession session) {
                    return (IContentGenerator)beanFactory.getBean(cgInfo.getId());
                }
            })).attributes(attributes)).build(), (Class[])new Class[]{IContentGenerator.class});
            this.registerReference(plugin.getId(), referenceHandle);
        }
        if (beanFactory == null) {
            return;
        }
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory.getBeanFactory(), IContentGenerator.class);
        ArrayList<String> ids = new ArrayList<String>();
        for (String beanName : names) {
            ids.add(beanName);
            Collections.addAll(ids, beanFactory.getAliases(beanName));
        }
        for (final String beanName : ids) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(PLUGIN_ID, plugin.getId());
            attributes.put(CONTENT_TYPE, beanName);
            IPentahoObjectRegistration referenceHandle = PentahoSystem.registerReference((IPentahoObjectReference)((PrototypePentahoObjectReference.Builder)((PrototypePentahoObjectReference.Builder)new PrototypePentahoObjectReference.Builder(IContentGenerator.class).creator((IObjectCreator)new IObjectCreator<IContentGenerator>(){

                public IContentGenerator create(IPentahoSession session) {
                    return (IContentGenerator)beanFactory.getBean(beanName);
                }
            })).attributes(attributes)).build(), (Class[])new Class[]{IContentGenerator.class});
            this.registerReference(plugin.getId(), referenceHandle);
        }
    }

    protected void registerContentTypes(IPlatformPlugin plugin, ClassLoader loader, GenericApplicationContext beanFactory) throws PlatformPluginRegistrationException {
        for (IContentInfo info : plugin.getContentInfos()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(PLUGIN_ID, plugin.getId());
            attributes.put("extension", info.getExtension());
            IPentahoObjectRegistration handle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(IContentInfo.class).object((Object)info)).attributes(attributes)).build(), (Class[])new Class[]{IContentInfo.class});
            this.registerReference(plugin.getId(), handle);
        }
    }

    public boolean isCsrfProtectionEnabled(String pluginId) {
        return PentahoSystem.isCsrfProtectionEnabled() && "true".equals(this.getPluginSetting(pluginId, "csrf-protection-enabled", "true"));
    }

    private void registerCsrfProtection(IPlatformPlugin plugin, IPlatformPluginCsrfProtection pluginCsrfProtection) {
        CsrfProtectionDefinition csrfProtectionDefinition;
        if (this.isCsrfProtectionEnabled(plugin.getId()) && (csrfProtectionDefinition = pluginCsrfProtection.getCsrfProtection()) != null) {
            IPentahoObjectRegistration handle = PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(CsrfProtectionDefinition.class).object((Object)csrfProtectionDefinition)).attributes(Collections.singletonMap(PLUGIN_ID, plugin.getId()))).build(), (Class[])new Class[]{CsrfProtectionDefinition.class});
            this.registerReference(plugin.getId(), handle);
        }
    }

    private GenericApplicationContext createBeanFactory(IPlatformPlugin plugin, ClassLoader classloader) throws PlatformPluginRegistrationException {
        if (!(classloader instanceof PluginClassLoader)) {
            throw new PlatformPluginRegistrationException("Can't determine plugin dir to load spring file because classloader is not of type PluginClassLoader.  This is since we are probably in a unit test");
        }
        BeanFactory nativeBeanFactory = this.getNativeBeanFactory(plugin, classloader);
        GenericApplicationContext beanFactory = null;
        if (nativeBeanFactory != null && nativeBeanFactory instanceof GenericApplicationContext) {
            beanFactory = (GenericApplicationContext)nativeBeanFactory;
        } else {
            beanFactory = new GenericApplicationContext();
            beanFactory.setClassLoader(classloader);
            beanFactory.getBeanFactory().setBeanClassLoader(classloader);
            if (nativeBeanFactory != null) {
                beanFactory.getBeanFactory().setParentBeanFactory(nativeBeanFactory);
            }
        }
        beanFactory.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PentahoBeanScopeValidatorPostProcessor());
        Iterator iterator = plugin.getBeans().iterator();
        while (iterator.hasNext()) {
            PluginBeanDefinition def;
            def.setBeanId((def = (PluginBeanDefinition)iterator.next()).getBeanId() == null ? def.getClassname() : def.getBeanId());
            try {
                this.assertUnique(beanFactory, plugin.getId(), def.getBeanId());
            }
            catch (PlatformPluginRegistrationException e) {
                this.logger.error(MessageFormat.format("Unable to register plugin bean, a bean by the id {0} is already defined in plugin: {1}", def.getBeanId(), plugin.getId()));
                continue;
            }
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)def.getClassname()).setScope("prototype").getBeanDefinition();
            beanFactory.registerBeanDefinition(def.getBeanId(), (BeanDefinition)beanDef);
        }
        return beanFactory;
    }

    protected void assertUnique(GenericApplicationContext applicationContext, String pluginId, String beanId) throws PlatformPluginRegistrationException {
        if (applicationContext.containsBean(beanId)) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0018_BEAN_ALREADY_REGISTERED", new Object[]{beanId, pluginId}));
        }
    }

    protected BeanFactory getNativeBeanFactory(IPlatformPlugin plugin, final ClassLoader loader) {
        Object nativeFactory = null;
        if (plugin.getBeanFactory() != null) {
            ListableBeanFactory testFactory = plugin.getBeanFactory();
            if (testFactory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)testFactory).setBeanClassLoader(loader);
            } else {
                this.logger.warn(Messages.getInstance().getString("PluginManager.WARN_WRONG_BEAN_FACTORY_TYPE"));
            }
            nativeFactory = testFactory;
        } else {
            File f = new File(((PluginClassLoader)loader).getPluginDir(), "plugin.spring.xml");
            if (f.exists()) {
                this.logger.debug("Found plugin spring file @ " + f.getAbsolutePath());
                FileSystemResource fsr = new FileSystemResource(f);
                GenericApplicationContext appCtx = new GenericApplicationContext(){

                    protected void prepareBeanFactory(ConfigurableListableBeanFactory clBeanFactory) {
                        super.prepareBeanFactory(clBeanFactory);
                        clBeanFactory.setBeanClassLoader(loader);
                    }

                    public ClassLoader getClassLoader() {
                        return loader;
                    }
                };
                XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appCtx);
                xmlReader.setBeanClassLoader(loader);
                xmlReader.loadBeanDefinitions((Resource)fsr);
                nativeFactory = appCtx;
            }
        }
        return nativeFactory;
    }

    private void registerReference(String id, IPentahoObjectRegistration handle) {
        this.handleRegistry.get((Object)id).add(handle);
    }

    private ClassLoader createClassloader(IPlatformPlugin plugin) throws PlatformPluginRegistrationException {
        String pluginDirPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + plugin.getSourceDescription());
        pluginDirPath = pluginDirPath.replace("//", "/");
        org.pentaho.platform.util.logging.Logger.debug((Object)this, (String)("plugin dir for " + plugin.getId() + " is [" + pluginDirPath + "]"));
        File pluginDir = new File(pluginDirPath);
        if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canRead())) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0027_PLUGIN_DIR_UNAVAILABLE", new Object[]{pluginDir.getAbsolutePath()}));
        }
        PluginClassLoader loader = new PluginClassLoader(pluginDir, this.getClass().getClassLoader());
        if (plugin.getLoaderType() == IPlatformPlugin.ClassLoaderType.OVERRIDING) {
            loader.setOverrideLoad(true);
        }
        return loader;
    }

    public List<XulOverlay> getOverlays() {
        return PentahoSystem.getAll(XulOverlay.class);
    }

    public Object getBean(String beanId) throws PluginBeanException {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        for (GenericApplicationContext beanFactory : PentahoSystem.getAll(GenericApplicationContext.class)) {
            if (!beanFactory.containsBean(beanId)) continue;
            try {
                return beanFactory.getBean(beanId);
            }
            catch (Throwable ex) {
                throw new PluginBeanException(ex);
            }
        }
        throw new PluginBeanException(Messages.getInstance().getString("PluginManager.WARN_CLASS_NOT_REGISTERED", new Object[]{beanId}));
    }

    public IContentGenerator getContentGenerator(String type, String perspectiveName) {
        Object cg = null;
        String beanId = perspectiveName == null || perspectiveName.equals(DEFAULT_PERSPECTIVE) ? type : type + "." + perspectiveName;
        IContentGeneratorInvoker cgInvoker = (IContentGeneratorInvoker)PentahoSystem.get(IContentGeneratorInvoker.class);
        if (cgInvoker != null && cgInvoker.isSupportedContent(beanId)) {
            this.logger.info("Located IContentGeneratorInvoker that supports content of type '" + beanId + "':" + cgInvoker.getClass().getName());
            return cgInvoker.getContentGenerator();
        }
        IContentGenerator contentGenerator = (IContentGenerator)PentahoSystem.get(IContentGenerator.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap(CONTENT_TYPE, beanId));
        if (contentGenerator == null) {
            contentGenerator = (IContentGenerator)PentahoSystem.get(IContentGenerator.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap(CONTENT_TYPE, perspectiveName));
        }
        return contentGenerator;
    }

    public Class<?> loadClass(String beanId) throws PluginBeanException {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        Class type = null;
        for (IPentahoObjectReference reference : PentahoSystem.getObjectReferences(GenericApplicationContext.class, null)) {
            GenericApplicationContext beanFactory;
            if (!reference.getAttributes().containsKey(PLUGIN_ID) || !(beanFactory = (GenericApplicationContext)reference.getObject()).containsBean(beanId)) continue;
            try {
                type = beanFactory.getType(beanId);
                break;
            }
            catch (Throwable ex) {
                throw new PluginBeanException(ex);
            }
        }
        if (type == null) {
            throw new PluginBeanException(Messages.getInstance().getString("PluginManager.WARN_CLASS_NOT_REGISTERED", new Object[]{beanId}));
        }
        return type;
    }

    public boolean isBeanRegistered(String beanId) {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        for (GenericApplicationContext beanFactory : PentahoSystem.getAll(GenericApplicationContext.class)) {
            if (!beanFactory.containsBean(beanId)) continue;
            return true;
        }
        return false;
    }

    public void unloadAllPlugins() {
        this.unloadPlugins();
    }

    public String getPluginIdForType(String contentType) {
        IPentahoObjectReference objectReference = PentahoSystem.getObjectReference(IContentGenerator.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap(CONTENT_TYPE, contentType));
        if (objectReference != null && objectReference.getAttributes().containsKey(PLUGIN_ID)) {
            return objectReference.getAttributes().get(PLUGIN_ID).toString();
        }
        List objectReferences = PentahoSystem.getObjectReferences(IContentGenerator.class, (IPentahoSession)PentahoSessionHolder.getSession());
        for (IPentahoObjectReference reference : objectReferences) {
            String o;
            if (!reference.getAttributes().containsKey(CONTENT_TYPE) || !(o = (String)reference.getAttributes().get(CONTENT_TYPE)).contains(".") || !o.substring(0, o.lastIndexOf(".")).equals(contentType)) continue;
            return (String)reference.getAttributes().get(PLUGIN_ID);
        }
        return null;
    }

    public List<String> getPluginRESTPerspectivesForType(String contentType) {
        ArrayList<String> retList = new ArrayList<String>();
        List objectReferences = PentahoSystem.getObjectReferences(IContentGenerator.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap(CONTENT_TYPE, contentType));
        for (IPentahoObjectReference objectReference : objectReferences) {
            String id;
            if (!objectReference.getAttributes().containsKey("id") || (id = (String)objectReference.getAttributes().get("id")) == null || !id.contains(".")) continue;
            retList.add(id.substring(id.lastIndexOf(".") + 1));
        }
        return retList;
    }

    public List<String> getPluginRESTPerspectivesForId(String id) {
        ArrayList<String> retList = new ArrayList<String>();
        List objectReferences = PentahoSystem.getObjectReferences(IContentGenerator.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap(PLUGIN_ID, id));
        for (IPentahoObjectReference objectReference : objectReferences) {
            String beanId;
            if (!objectReference.getAttributes().containsKey("id") || (beanId = (String)objectReference.getAttributes().get("id")) == null || !beanId.contains(".")) continue;
            retList.add(beanId.substring(beanId.lastIndexOf(".") + 1));
        }
        return retList;
    }

    public String getPluginIdForClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        List objectReferences = PentahoSystem.getObjectReferences(ClassLoader.class, null);
        for (IPentahoObjectReference objectReference : objectReferences) {
            if (!((ClassLoader)objectReference.getObject()).equals(classLoader)) continue;
            return objectReference.getAttributes().get(PLUGIN_ID).toString();
        }
        return null;
    }

    private String trimLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    protected boolean isRequested(String servicePath, String requestPath) {
        String[] servicePathElements;
        String[] requestPathElements = this.trimLeadingSlash(requestPath).split("/");
        if (requestPathElements.length < (servicePathElements = this.trimLeadingSlash(servicePath).split("/")).length) {
            return false;
        }
        for (int i = 0; i < servicePathElements.length; ++i) {
            if (requestPathElements[i].equals(servicePathElements[i])) continue;
            return false;
        }
        return true;
    }

    public Object getPluginSetting(String pluginId, String key, String defaultValue) {
        IConfiguration pluginConfig = this.systemConfig.getConfiguration(pluginId);
        if (pluginConfig != null) {
            try {
                if (pluginConfig.getProperties().containsKey(key)) {
                    return pluginConfig.getProperties().getProperty(key);
                }
                if (key.startsWith(SETTINGS_PREFIX)) {
                    return defaultValue;
                }
                String compositeKey = SETTINGS_PREFIX + key;
                if (pluginConfig.getProperties().containsKey(compositeKey)) {
                    return pluginConfig.getProperties().getProperty(compositeKey);
                }
                return defaultValue;
            }
            catch (IOException e) {
                this.logger.error("unable to access plugin settings", (Throwable)e);
            }
        }
        return defaultValue;
    }

    @Deprecated
    public String getServicePlugin(String path) {
        for (IPlatformPlugin plugin : PentahoSystem.getAll(IPlatformPlugin.class)) {
            String pluginId = this.getStaticResourcePluginId(plugin, path);
            if (pluginId != null) {
                return pluginId;
            }
            for (IContentGeneratorInfo contentGenerator : plugin.getContentGenerators()) {
                String cgId = contentGenerator.getId();
                if (!this.isRequested(cgId, path)) continue;
                return plugin.getId();
            }
        }
        return null;
    }

    private String getStaticResourcePluginId(IPlatformPlugin plugin, String path) {
        Map resourceMap = plugin.getStaticResourceMap();
        for (String url : resourceMap.keySet()) {
            if (!this.isRequested(url, path)) continue;
            return plugin.getId();
        }
        return null;
    }

    public ClassLoader getClassLoader(String pluginId) {
        return (ClassLoader)PentahoSystem.get(ClassLoader.class, null, Collections.singletonMap(PLUGIN_ID, pluginId));
    }

    public ListableBeanFactory getBeanFactory(String pluginId) {
        return (ListableBeanFactory)PentahoSystem.get(ApplicationContext.class, null, Collections.singletonMap(PLUGIN_ID, pluginId));
    }

    public boolean isStaticResource(String path) {
        for (IPlatformPlugin plugin : PentahoSystem.getAll(IPlatformPlugin.class)) {
            String pluginId = this.getStaticResourcePluginId(plugin, path);
            if (pluginId == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPublic(String pluginId, String path) {
        IPlatformPlugin plugin = (IPlatformPlugin)PentahoSystem.get(IPlatformPlugin.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap(PLUGIN_ID, pluginId));
        if (plugin == null) {
            return false;
        }
        Map resourceMap = plugin.getStaticResourceMap();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (String pluginRelativeDir : resourceMap.values()) {
            if (!path.startsWith(pluginRelativeDir)) continue;
            return true;
        }
        return false;
    }

    public InputStream getStaticResource(String path) {
        for (IPlatformPlugin plugin : PentahoSystem.getAll(IPlatformPlugin.class)) {
            Map resourceMap = plugin.getStaticResourceMap();
            for (String url : resourceMap.keySet()) {
                if (!this.isRequested(url, path)) continue;
                IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
                ClassLoader classLoader = (ClassLoader)PentahoSystem.get(ClassLoader.class, null, Collections.singletonMap(PLUGIN_ID, plugin.getId()));
                String resourcePath = path.replace(url, (CharSequence)resourceMap.get(url));
                return resLoader.getResourceAsStream(classLoader, resourcePath);
            }
        }
        return null;
    }

    public List<String> getRegisteredPlugins() {
        ArrayList<String> retList = new ArrayList<String>();
        List plugins = PentahoSystem.getAll(IPlatformPlugin.class);
        for (IPlatformPlugin plugin : plugins) {
            retList.add(plugin.getId());
        }
        return retList;
    }

    public List<String> getExternalResourcesForContext(String context) {
        ArrayList<String> resources = new ArrayList<String>();
        for (IPlatformPlugin plugin : PentahoSystem.getAll(IPlatformPlugin.class)) {
            List pluginRes = plugin.getExternalResourcesForContext(context);
            if (pluginRes == null) continue;
            resources.addAll(pluginRes);
        }
        return resources;
    }

    public void addPluginManagerListener(IPluginManagerListener listener) {
        this.listeners.add(listener);
    }
}

