/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.CsrfProtectionDefinition;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPlatformPluginCsrfProtection;
import org.pentaho.platform.api.engine.IPluginLifecycleListener;
import org.pentaho.platform.api.engine.PluginBeanDefinition;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.platform.api.engine.PluginServiceDefinition;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.ui.xul.XulOverlay;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class PlatformPlugin
implements IPlatformPlugin,
IPentahoInitializer,
IPlatformPluginCsrfProtection {
    private List<IContentGeneratorInfo> contentGenerators = new ArrayList<IContentGeneratorInfo>();
    private List<IContentInfo> contentInfos = new ArrayList<IContentInfo>();
    private List<XulOverlay> overlays = new ArrayList<XulOverlay>();
    private List<IPluginPerspective> perspectives = new ArrayList<IPluginPerspective>();
    private Collection<PluginBeanDefinition> beanDefinitions = new ArrayList<PluginBeanDefinition>();
    private DefaultListableBeanFactory beanFactory;
    private Collection<PluginServiceDefinition> webserviceDefinitions = new ArrayList<PluginServiceDefinition>();
    private List<IPentahoInitializer> initializers = new ArrayList<IPentahoInitializer>();
    private Map<String, String> staticResourceMap = new HashMap<String, String>();
    private Map<String, String> metaProviderMap = new HashMap<String, String>();
    private String id;
    private String sourceDescription = "";
    private String lifecycleListenerClassname;
    private IPluginLifecycleListener lifecycleListener;
    private IPlatformPlugin.ClassLoaderType loaderType;
    private Map<String, List<String>> externalResources = new HashMap<String, List<String>>();
    private CsrfProtectionDefinition csrfProtectionDefinition;

    public PlatformPlugin() {
    }

    public PlatformPlugin(DefaultListableBeanFactory defaultListableBeanFactory) {
        this.beanFactory = defaultListableBeanFactory;
    }

    public void init(IPentahoSession session) {
        for (IPentahoInitializer initializer : this.initializers) {
            initializer.init(session);
        }
    }

    public String getLifecycleListenerClassname() {
        return this.lifecycleListenerClassname;
    }

    public void setLifecycleListenerClassname(String lifecycleListenerClassname) {
        this.lifecycleListenerClassname = lifecycleListenerClassname;
    }

    public List<IContentGeneratorInfo> getContentGenerators() {
        return this.contentGenerators;
    }

    public List<IContentInfo> getContentInfos() {
        return this.contentInfos;
    }

    public String getId() {
        return this.id;
    }

    public List<XulOverlay> getOverlays() {
        return this.overlays;
    }

    public List<IPluginPerspective> getPluginPerspectives() {
        return Collections.unmodifiableList(this.perspectives);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addInitializer(IPentahoInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addContentGenerator(IContentGeneratorInfo contentGenerator) {
        this.contentGenerators.add(contentGenerator);
    }

    public void addContentInfo(IContentInfo contentInfo) {
        this.contentInfos.add(contentInfo);
    }

    public void addOverlay(XulOverlay overlay) {
        this.overlays.add(overlay);
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public void setSourceDescription(String sourceDescription) {
        this.sourceDescription = sourceDescription;
    }

    public void addStaticResourcePath(String url, String localFolder) {
        this.staticResourceMap.put(url, localFolder);
    }

    public Map<String, String> getStaticResourceMap() {
        return this.staticResourceMap;
    }

    public Collection<PluginBeanDefinition> getBeans() {
        return Collections.unmodifiableCollection(this.beanDefinitions);
    }

    public DefaultListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Collection<PluginServiceDefinition> getServices() {
        return Collections.unmodifiableCollection(this.webserviceDefinitions);
    }

    public void addBean(PluginBeanDefinition beanDefinition) {
        this.beanDefinitions.add(beanDefinition);
    }

    public void addWebservice(PluginServiceDefinition serviceDefinition) {
        this.webserviceDefinitions.add(serviceDefinition);
    }

    public void init() throws PluginLifecycleException {
        if (this.lifecycleListener != null) {
            this.lifecycleListener.init();
        }
    }

    public void loaded() throws PluginLifecycleException {
        if (this.lifecycleListener != null) {
            this.lifecycleListener.loaded();
        }
    }

    public void unLoaded() throws PluginLifecycleException {
        if (this.lifecycleListener != null) {
            this.lifecycleListener.unLoaded();
        }
    }

    public void addLifecycleListener(IPluginLifecycleListener listener) {
        this.lifecycleListener = listener;
    }

    public Map<String, String> getMetaProviderMap() {
        return this.metaProviderMap;
    }

    public IPlatformPlugin.ClassLoaderType getLoaderType() {
        return this.loaderType;
    }

    public void setLoadertype(IPlatformPlugin.ClassLoaderType loaderType) {
        this.loaderType = loaderType;
    }

    public void addExternalResource(String context, String resource) {
        List<String> res = this.externalResources.get(context);
        if (res == null) {
            res = new ArrayList<String>();
            this.externalResources.put(context, res);
        }
        res.add(resource);
    }

    public List<String> getExternalResourcesForContext(String context) {
        List<String> res = this.externalResources.get(context);
        if (res == null) {
            res = new ArrayList<String>();
            this.externalResources.put(context, res);
        }
        return Collections.unmodifiableList(res);
    }

    public void addPluginPerspective(IPluginPerspective perspective) {
        this.perspectives.add(perspective);
    }

    public CsrfProtectionDefinition getCsrfProtection() {
        return this.csrfProtectionDefinition;
    }

    public void setCsrfProtection(CsrfProtectionDefinition csrfProtectionDefinition) {
        this.csrfProtectionDefinition = csrfProtectionDefinition;
    }
}

