/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.memory;

import java.util.Properties;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;

public class DefaultInMemoryUserDetailsService
extends InMemoryUserDetailsManager {
    private ITenantedPrincipleNameResolver userNameUtils;

    public DefaultInMemoryUserDetailsService(Properties users, ITenantedPrincipleNameResolver userNameUtils) {
        super(users);
        this.setUserNameUtils(userNameUtils);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return super.loadUserByUsername(this.getUserNameUtils().getPrincipleName(username));
    }

    public ITenantedPrincipleNameResolver getUserNameUtils() {
        return this.userNameUtils;
    }

    public void setUserNameUtils(ITenantedPrincipleNameResolver userNameUtils) {
        this.userNameUtils = userNameUtils;
    }
}

