/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.CsrfProtectionDefinition;
import org.pentaho.platform.api.engine.RequestMatcherDefinition;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.StringUtil;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.bind.annotation.RequestMethod;

public class WebUtil {
    static final String ORIGIN_HEADER = "origin";
    static final String CORS_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    static final String CORS_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    public static final String CORS_EXPOSE_HEADERS_HEADER = "Access-Control-Expose-Headers";

    public static void setCorsResponseHeaders(HttpServletRequest request, HttpServletResponse response) {
        WebUtil.setCorsResponseHeaders(request, response, null);
    }

    public static void setCorsResponseHeaders(HttpServletRequest request, HttpServletResponse response, Map<String, List<String>> corsHeadersConfiguration) {
        if (!WebUtil.isCorsRequestsAllowed()) {
            return;
        }
        String origin = request.getHeader(ORIGIN_HEADER);
        if (WebUtil.isCorsRequestOriginAllowed(origin)) {
            response.setHeader(CORS_ALLOW_ORIGIN_HEADER, origin);
            response.setHeader(CORS_ALLOW_CREDENTIALS_HEADER, "true");
            if (corsHeadersConfiguration != null) {
                corsHeadersConfiguration.forEach((header, parameters) -> {
                    String value = String.join((CharSequence)",", parameters);
                    response.setHeader(header, value);
                });
            }
        }
    }

    private static boolean isCorsRequestsAllowed() {
        String isCorsAllowed = WebUtil.getCorsRequestsAllowedSystemProperty();
        return "true".equals(isCorsAllowed);
    }

    private static List<String> getCorsRequestsAllowedDomains() {
        String allowedDomains = WebUtil.getCorsAllowedDomainsSystemProperty();
        boolean hasDomains = !StringUtil.isEmpty((String)allowedDomains);
        return hasDomains ? Arrays.asList(allowedDomains.split("\\s*,\\s*")) : null;
    }

    private static boolean isCorsRequestOriginAllowed(String domain) {
        List<String> allowedDomains = WebUtil.getCorsRequestsAllowedDomains();
        return allowedDomains != null && allowedDomains.contains(domain);
    }

    static String getCorsRequestsAllowedSystemProperty() {
        return PentahoSystem.getSystemSetting((String)"cors-requests-allowed", (String)"false");
    }

    static String getCorsAllowedDomainsSystemProperty() {
        return PentahoSystem.getSystemSetting((String)"cors-requests-allowed-domains", null);
    }

    public static CsrfProtectionDefinition parseXmlCsrfProtectionDefinition(Element csrfProtectionElem) {
        ArrayList<RequestMatcherDefinition> requestMatchers = new ArrayList<RequestMatcherDefinition>();
        for (Node csrfRequestMatcherNode : csrfProtectionElem.selectNodes("request-matcher")) {
            requestMatchers.add(WebUtil.getCsrfRequestMatcher((Element)csrfRequestMatcherNode));
        }
        if (requestMatchers.size() == 0) {
            return null;
        }
        CsrfProtectionDefinition protectionDefinition = new CsrfProtectionDefinition();
        protectionDefinition.setProtectedRequestMatchers(requestMatchers);
        return protectionDefinition;
    }

    private static RequestMatcherDefinition getCsrfRequestMatcher(Element csrfRequestMatcherElem) {
        String type = csrfRequestMatcherElem.attributeValue("type", "regex");
        String pattern = csrfRequestMatcherElem.attributeValue("pattern", "");
        String methods = csrfRequestMatcherElem.attributeValue("methods", "GET,POST");
        if (!"regex".equals(type)) {
            throw new IllegalArgumentException(Messages.getInstance().getString("CsrfProtection.REQUEST_MATCHER_INVALID_TYPE", new Object[]{type}));
        }
        if (StringUtils.isEmpty((String)pattern)) {
            throw new IllegalArgumentException(Messages.getInstance().getString("CsrfProtection.REQUEST_MATCHER_NO_PATTERN"));
        }
        ArrayList<String> methodsCol = new ArrayList<String>();
        for (String method : methods.split("\\s*,\\s*")) {
            try {
                RequestMethod.valueOf((String)method);
            }
            catch (IllegalArgumentException invalidEnumError) {
                throw new IllegalArgumentException(Messages.getInstance().getString("CsrfProtection.REQUEST_MATCHER_INVALID_METHOD", new Object[]{method}));
            }
            methodsCol.add(method);
        }
        if (methodsCol.size() == 0) {
            methodsCol.add("POST");
            methodsCol.add("GET");
        }
        return new RequestMatcherDefinition(type, pattern, methodsCol);
    }

    public static RequestMatcher buildCsrfRequestMatcher(Collection<CsrfProtectionDefinition> csrfProtectionDefinitions) {
        ArrayList<RequestMatcher> requestMatchers = new ArrayList<RequestMatcher>();
        for (CsrfProtectionDefinition csrfProtectionDefinition : csrfProtectionDefinitions) {
            WebUtil.collectRequestMatchers(requestMatchers, csrfProtectionDefinition);
        }
        return requestMatchers.size() > 0 ? new OrRequestMatcher(requestMatchers) : null;
    }

    private static void collectRequestMatchers(Collection<RequestMatcher> requestMatchers, CsrfProtectionDefinition csrfProtectionDefinition) {
        Collection requestMatcherDefinitions = csrfProtectionDefinition.getProtectedRequestMatchers();
        if (requestMatcherDefinitions != null) {
            for (RequestMatcherDefinition requestMatcherDefinition : requestMatcherDefinitions) {
                Collection httpMethods = requestMatcherDefinition.getMethods();
                if (httpMethods == null) {
                    requestMatchers.add((RequestMatcher)new RegexRequestMatcher(requestMatcherDefinition.getPattern(), null, false));
                    continue;
                }
                for (String httpMethod : requestMatcherDefinition.getMethods()) {
                    requestMatchers.add((RequestMatcher)new RegexRequestMatcher(requestMatcherDefinition.getPattern(), httpMethod, false));
                }
            }
        }
    }
}

