/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.api.resources.ContentGeneratorDescriptor;
import org.pentaho.platform.web.http.api.resources.GeneratorStreamingOutputProvider;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;

public class GeneratorStreamingOutput {
    private static final Log logger = LogFactory.getLog(GeneratorStreamingOutput.class);
    private static final Log mimeTypeLogger = LogFactory.getLog((String)"MIME_TYPE");
    protected IContentGenerator contentGenerator;
    protected String contentGeneratorID;
    protected RepositoryFile file;
    protected String command;
    protected HttpServletRequest httpServletRequest;
    protected HttpServletResponse httpServletResponse;
    protected IPluginManager pluginMgr;
    protected String fileType;
    protected String mimeType;
    protected List<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
    protected ContentGeneratorDescriptor contentGeneratorDescriptor;
    private static final boolean MIMETYPE_MUTABLE = true;

    public GeneratorStreamingOutput(IContentGenerator contentGenerator, ContentGeneratorDescriptor desc, HttpServletRequest request, HttpServletResponse response, List<MediaType> acceptableMediaTypes, RepositoryFile file, String command) {
        String tmpMimeType;
        if (contentGenerator == null) {
            throw new IllegalArgumentException("contentGenerator cannot be null");
        }
        this.contentGenerator = contentGenerator;
        this.contentGeneratorDescriptor = desc;
        this.command = command;
        this.contentGeneratorID = desc.getContentGeneratorId();
        this.fileType = desc.getServicingFileType();
        this.file = file;
        this.mimeTrace("Request is requiring content generator to return content of type [{0}]", acceptableMediaTypes.toString());
        if (acceptableMediaTypes != null) {
            this.acceptableMediaTypes = acceptableMediaTypes;
        }
        this.httpServletRequest = request;
        this.httpServletResponse = response;
        this.pluginMgr = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (command != null && command.contains(".") && (tmpMimeType = MimeHelper.getMimeTypeFromFileName((String)command)) != null) {
            this.mimeType = tmpMimeType;
            this.mimeTrace("Setting response mime type to [{0}] (based on extension of resource [{1}])", this.mimeType, command);
        }
    }

    private void mimeTrace(String msg, Object ... args) {
        if (mimeTypeLogger.isDebugEnabled()) {
            String prologue = MessageFormat.format("<< {3} [MIME TRACE] Content generator id [{0}] for file type [{1}] and resource [{2}]>>: ", this.contentGeneratorID, this.fileType, this.command, this);
            mimeTypeLogger.debug((Object)MessageFormat.format(prologue + msg, args));
        }
    }

    public void write(OutputStream output, GeneratorStreamingOutputProvider.MimeTypeCallback callback) throws IOException {
        if (this.file != null) {
            this.fileType = RepositoryFilenameUtils.getExtension((String)this.file.getName());
        }
        try {
            this.generateContent(output, callback);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error generating content from content generator with id [{0}]", this.contentGeneratorID);
            logger.error((Object)msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateContent(OutputStream outputStream, final GeneratorStreamingOutputProvider.MimeTypeCallback callback) throws Exception {
        try {
            this.httpServletResponse.setCharacterEncoding(LocaleHelper.getSystemEncoding());
        }
        catch (Throwable t) {
            logger.warn((Object)"could not set encoding, servlet-api is likely too old.  are we in a unit test?");
        }
        HttpOutputHandler outputHandler = new HttpOutputHandler(this.httpServletResponse, outputStream, true);
        outputHandler.setMimeTypeListener(new HttpMimeTypeListener(this.httpServletRequest, this.httpServletResponse){

            @Override
            public void setMimeType(String mimeType) {
                try {
                    GeneratorStreamingOutput.this.mimeTrace("Content generator is setting response mime type to [{0}]", new Object[]{mimeType});
                    if (callback != null) {
                        callback.setMimeType(mimeType);
                    }
                    GeneratorStreamingOutput.this.setMimeType(mimeType);
                }
                catch (Throwable th) {
                    GeneratorStreamingOutput.this.mimeTrace("Failed to set mime type: {0}", new Object[]{th.getMessage()});
                    logger.error((Object)MessageFormat.format("Failed to set mime type: {0}", th.getMessage()));
                }
                super.setMimeType(mimeType);
            }
        });
        HashMap<String, IParameterProvider> parameterProviders = new HashMap<String, IParameterProvider>();
        parameterProviders.put("request", this.createRequestParamProvider());
        parameterProviders.put("session", this.createSessionParameterProvider());
        parameterProviders.put("headers", this.createHeaderParamProvider());
        parameterProviders.put("path", this.createPathParamProvider());
        String pluginId = this.contentGeneratorDescriptor.getPluginId();
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(PentahoRequestContextHolder.getRequestContext().getContextPath() + "api/repos/" + pluginId + "/" + this.contentGeneratorID + "?");
        ClassLoader origContextClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.pluginMgr.getClassLoader(pluginId));
        try {
            this.contentGenerator.setOutputHandler((IOutputHandler)outputHandler);
            this.contentGenerator.setMessagesList(new ArrayList());
            this.contentGenerator.setParameterProviders(parameterProviders);
            this.contentGenerator.setSession(PentahoSessionHolder.getSession());
            if (urlFactory != null) {
                this.contentGenerator.setUrlFactory((IPentahoUrlFactory)urlFactory);
            }
            this.contentGenerator.createContent();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassloader);
        }
    }

    protected IParameterProvider createRequestParamProvider() {
        return new HttpRequestParameterProvider(this.httpServletRequest);
    }

    protected IParameterProvider createSessionParameterProvider() {
        return new HttpSessionParameterProvider(PentahoSessionHolder.getSession());
    }

    protected IParameterProvider createHeaderParamProvider() {
        SimpleParameterProvider headerParams = new SimpleParameterProvider();
        Enumeration names = this.httpServletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = this.httpServletRequest.getHeader(name);
            headerParams.setParameter(name, value);
        }
        return headerParams;
    }

    protected IParameterProvider createPathParamProvider() throws IOException {
        SimpleParameterProvider pathParams = null;
        pathParams = new SimpleParameterProvider();
        pathParams.setParameter("query", this.httpServletRequest.getQueryString());
        ArrayList<String> mediaTypes = new ArrayList<String>(this.acceptableMediaTypes.size());
        for (MediaType type : this.acceptableMediaTypes) {
            mediaTypes.add(type.toString());
        }
        pathParams.setParameter("acceptableMediaTypes", mediaTypes);
        if (mediaTypes.size() > 0) {
            pathParams.setParameter("contentType", (Object)this.acceptableMediaTypes.get(0));
        }
        pathParams.setParameter("inputstream", (Object)this.httpServletRequest.getInputStream());
        pathParams.setParameter("httpresponse", (Object)this.httpServletResponse);
        pathParams.setParameter("httprequest", (Object)this.httpServletRequest);
        pathParams.setParameter("remoteaddr", this.httpServletRequest.getRemoteAddr());
        if (this.file != null) {
            pathParams.setParameter("path", URLEncoder.encode(this.file.getPath(), "UTF-8"));
            pathParams.setParameter("file", (Object)this.file);
        }
        if (this.command != null) {
            pathParams.setParameter("cmd", this.command);
        }
        return pathParams;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

