/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.util.List;
import org.pentaho.platform.api.engine.IAuthorizationAction;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class AuthorizationActionService {
    private List<IAuthorizationAction> authActionList;

    public AuthorizationActionService(List<IAuthorizationAction> authActionList) {
        this.authActionList = authActionList;
    }

    public AuthorizationActionService() {
    }

    public boolean validateAuth(String authAction) {
        boolean isAllowed = false;
        boolean validInput = false;
        for (IAuthorizationAction a : this.getActionList()) {
            if (!a.getName().equals(authAction)) continue;
            validInput = true;
            break;
        }
        if (validInput) {
            IAuthorizationPolicy policy = this.getPolicy();
            isAllowed = policy.isAllowed(authAction);
        }
        return isAllowed;
    }

    protected List<IAuthorizationAction> getActionList() {
        if (this.authActionList == null) {
            this.authActionList = PentahoSystem.getAll(IAuthorizationAction.class);
        }
        return this.authActionList;
    }

    protected IAuthorizationPolicy getPolicy() {
        return (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
    }
}

