/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.utils;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;

public class SystemUtils {
    private static final Log logger = LogFactory.getLog(SystemUtils.class);

    public static boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }

    public static boolean canUpload(String uploadDir) {
        boolean isAdmin;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean bl = isAdmin = policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && (policy.isAllowed("org.pentaho.security.administerSecurity") || policy.isAllowed("org.pentaho.security.publish"));
        if (!isAdmin && !StringUtils.isEmpty((String)uploadDir)) {
            return SystemUtils.validateAccessToHomeFolder(uploadDir);
        }
        return isAdmin;
    }

    public static boolean canDownload(String downloadDir) {
        boolean isAdminOrHaveDownloadActionRole;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        IUserRoleListService userRoleListService = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        String tenantedUserName = PentahoSessionHolder.getSession().getName();
        List tenantedUserRoles = userRoleListService.getRolesForUser(JcrTenantUtils.getUserNameUtils().getTenant(tenantedUserName), tenantedUserName);
        boolean bl = isAdminOrHaveDownloadActionRole = policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && (policy.isAllowed("org.pentaho.security.administerSecurity") || !Collections.disjoint(tenantedUserRoles, PentahoSystem.getDownloadRolesList()));
        if (!isAdminOrHaveDownloadActionRole && !StringUtils.isEmpty((String)downloadDir)) {
            return SystemUtils.validateAccessToHomeFolder(downloadDir);
        }
        return isAdminOrHaveDownloadActionRole;
    }

    public static boolean validateAccessToHomeFolder(String dir) {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean usingHomeFolder = false;
        String tenantedUserName = PentahoSessionHolder.getSession().getName();
        String userHomeFolderPath = ServerRepositoryPaths.getUserHomeFolderPath((ITenant)JcrTenantUtils.getUserNameUtils().getTenant(tenantedUserName), (String)JcrTenantUtils.getUserNameUtils().getPrincipleName(tenantedUserName));
        if (userHomeFolderPath != null && userHomeFolderPath.length() > 0) {
            usingHomeFolder = (ServerRepositoryPaths.getTenantRootFolderPath() + dir).contains(userHomeFolderPath);
        }
        return usingHomeFolder && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.repository.read");
    }
}

