/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.CsrfProtectionDefinition;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginManagerListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.WebUtil;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfGateFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(CsrfGateFilter.class);
    private CsrfFilter innerCsrfFilter;
    private boolean isCsrfProtectionEnabled = true;
    private boolean initialized = false;

    public CsrfGateFilter(CsrfTokenRepository csrfTokenRepository) {
        this.innerCsrfFilter = new CsrfFilter(csrfTokenRepository);
    }

    @VisibleForTesting
    boolean getIsCsrfProtectionEnabled() {
        return this.isCsrfProtectionEnabled;
    }

    @VisibleForTesting
    CsrfFilter getInnerCsrfFilter() {
        return this.innerCsrfFilter;
    }

    @VisibleForTesting
    boolean getInitialized() {
        return this.initialized;
    }

    @VisibleForTesting
    void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.innerCsrfFilter.setAccessDeniedHandler(accessDeniedHandler);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.innerCsrfFilter.init(filterConfig);
        ((IPluginManager)PentahoSystem.get(IPluginManager.class)).addPluginManagerListener(new IPluginManagerListener(){

            public void onReload() {
                try {
                    CsrfGateFilter.this.initialized = false;
                    CsrfGateFilter.this.doInit();
                }
                catch (ServletException e) {
                    logger.error((Object)e);
                }
            }
        });
        this.doInit();
    }

    private synchronized void doInit() throws ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"CsrfGateFilter.init");
        }
        if (this.initialized) {
            return;
        }
        this.isCsrfProtectionEnabled = PentahoSystem.isCsrfProtectionEnabled();
        if (this.isCsrfProtectionEnabled) {
            RequestMatcher requestMatcher = WebUtil.buildCsrfRequestMatcher(PentahoSystem.getAll(CsrfProtectionDefinition.class));
            if (requestMatcher == null) {
                this.isCsrfProtectionEnabled = false;
            } else {
                this.innerCsrfFilter.setRequireCsrfProtectionMatcher(requestMatcher);
            }
        }
        this.initialized = true;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.initialized) {
            this.doInit();
        }
        if (this.isCsrfProtectionEnabled) {
            this.innerCsrfFilter.doFilter(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        this.innerCsrfFilter.destroy();
    }
}

