/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.util.List;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.CsrfProtectionDefinition;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.references.SingletonPentahoObjectReference;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.web.WebUtil;

public class CsrfProtectionSystemListener
implements IPentahoSystemListener {
    public boolean startup(IPentahoSession session) {
        List csrProtectionNodes;
        if (PentahoSystem.isCsrfProtectionEnabled() && (csrProtectionNodes = PentahoSystem.getSystemSettings().getSystemSettings("csrf-protection")).size() > 0) {
            Element csrfProtectionElem = (Element)csrProtectionNodes.get(0);
            try {
                CsrfProtectionDefinition csrfProtectionDefinition = WebUtil.parseXmlCsrfProtectionDefinition(csrfProtectionElem);
                PentahoSystem.registerReference((IPentahoObjectReference)((SingletonPentahoObjectReference.Builder)new SingletonPentahoObjectReference.Builder(CsrfProtectionDefinition.class).object((Object)csrfProtectionDefinition)).build(), (Class[])new Class[]{CsrfProtectionDefinition.class});
            }
            catch (IllegalArgumentException parseError) {
                Logger.warn((String)CsrfProtectionSystemListener.class.getName(), (String)Messages.getInstance().getString("CsrfProtectionSystemListener.WARN_CSRF_SYSTEM_NOT_REGISTERED", new Object[]{parseError.getMessage()}));
            }
        }
        return true;
    }

    public void shutdown() {
    }
}

