/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.web.WebUtil;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class CsrfTokenResponseHeaderFilter
extends OncePerRequestFilter {
    static final String REQUEST_ATTRIBUTE_NAME = "_csrf";
    static final String RESPONSE_HEADER_NAME = "X-CSRF-HEADER";
    static final String RESPONSE_PARAM_NAME = "X-CSRF-PARAM";
    static final String RESPONSE_TOKEN_NAME = "X-CSRF-TOKEN";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException {
        CsrfToken token = (CsrfToken)request.getAttribute(REQUEST_ATTRIBUTE_NAME);
        if (token != null) {
            String tokenHeaderName = token.getHeaderName();
            response.setHeader(RESPONSE_HEADER_NAME, tokenHeaderName);
            String tokenParameterName = token.getParameterName();
            response.setHeader(RESPONSE_PARAM_NAME, tokenParameterName);
            String tokenValue = token.getToken();
            response.setHeader(RESPONSE_TOKEN_NAME, tokenValue);
        }
        WebUtil.setCorsResponseHeaders(request, response, this.getCorsHeadersConfiguration());
        response.setStatus(204);
    }

    @VisibleForTesting
    Map<String, List<String>> getCorsHeadersConfiguration() {
        HashMap<String, List<String>> corsConfiguration = new HashMap<String, List<String>>(1);
        List<String> exposedHeaders = Arrays.asList(RESPONSE_HEADER_NAME, RESPONSE_PARAM_NAME, RESPONSE_TOKEN_NAME);
        corsConfiguration.put("Access-Control-Expose-Headers", exposedHeaders);
        return corsConfiguration;
    }
}

