/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.stream.Collectors;
import org.pentaho.platform.web.http.security.CsrfToken;

public class CsrfUtil {
    public static final String API_SYSTEM_CSRF = "/api/system/csrf";
    public static final String API_SYSTEM_CSRF_PARAM_URL = "url";
    public static final String API_SYSTEM_CSRF_RESPONSE_HEADER_TOKEN = "X-CSRF-TOKEN";
    public static final String API_SYSTEM_CSRF_RESPONSE_HEADER_HEADER = "X-CSRF-HEADER";
    public static final String API_SYSTEM_CSRF_RESPONSE_HEADER_PARAM = "X-CSRF-PARAM";

    public static CsrfToken getCsrfToken(Client client, String contextURL, String serviceURL) {
        String csrfServiceURL = contextURL + API_SYSTEM_CSRF;
        WebResource csrfTokenResource = client.resource(csrfServiceURL).queryParam(API_SYSTEM_CSRF_PARAM_URL, serviceURL);
        WebResource.Builder requestBuilder = csrfTokenResource.getRequestBuilder();
        ClientResponse response = (ClientResponse)requestBuilder.get(ClientResponse.class);
        if (response == null || response.getStatus() != 204 && response.getStatus() != 200) {
            return null;
        }
        String token = (String)response.getHeaders().getFirst((Object)API_SYSTEM_CSRF_RESPONSE_HEADER_TOKEN);
        if (token == null) {
            return null;
        }
        String header = (String)response.getHeaders().getFirst((Object)API_SYSTEM_CSRF_RESPONSE_HEADER_HEADER);
        String parameter = (String)response.getHeaders().getFirst((Object)API_SYSTEM_CSRF_RESPONSE_HEADER_PARAM);
        List<String> cookieList = response.getCookies().stream().map(cookie -> cookie.toCookie().toString()).collect(Collectors.toList());
        return new CsrfToken(header, parameter, token, cookieList);
    }
}

