/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.DuplicateDatasourceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository.datasource.NonExistingDatasourceException;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.DatabaseHelper;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository2.ClientRepositoryPaths;

public class JcrBackedDatasourceMgmtService
implements IDatasourceMgmtService {
    private IUnifiedRepository repository;
    private volatile List<Character> cachedReservedChars;
    private Serializable cachedDatabaseParentFolderId;
    private static final String FOLDER_PDI = "pdi";
    private static final String FOLDER_DATABASES = "databases";
    private DatabaseHelper databaseHelper;

    public JcrBackedDatasourceMgmtService() {
    }

    public JcrBackedDatasourceMgmtService(IUnifiedRepository repository, IDatabaseDialectService databaseDialectService) {
        this.repository = repository;
        this.cachedReservedChars = repository.getReservedChars();
        this.databaseHelper = new DatabaseHelper(databaseDialectService);
    }

    public void init(IPentahoSession session) {
        this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)session);
        this.cachedReservedChars = this.repository.getReservedChars();
    }

    public String createDatasource(IDatabaseConnection databaseConnection) throws DuplicateDatasourceException, DatasourceMgmtServiceException {
        try {
            RepositoryFile file = new RepositoryFile.Builder(RepositoryFilenameUtils.escape(databaseConnection.getName() + RepositoryObjectType.DATABASE.getExtension(), this.cachedReservedChars)).title("default", databaseConnection.getName()).versioned(true).build();
            file = this.repository.createFile(this.getDatabaseParentFolderId(), file, (IRepositoryFileData)new NodeRepositoryFileData(this.databaseHelper.databaseConnectionToDataNode(databaseConnection)), null);
            if (file != null && file.getId() != null) {
                return file.getId().toString();
            }
            return null;
        }
        catch (UnifiedRepositoryException ure) {
            if (ure.getCause().toString().contains("ItemExistsException")) {
                throw new DuplicateDatasourceException();
            }
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0001_UNABLE_TO_CREATE_DATASOURCE", new Object[]{databaseConnection.getName(), ure.getLocalizedMessage()}), (Throwable)ure);
        }
    }

    public void deleteDatasourceByName(String name) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        RepositoryFile fileToDelete = null;
        try {
            fileToDelete = this.repository.getFile(this.getPath(name));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0002_UNABLE_TO_DELETE_DATASOURCE", new Object[]{fileToDelete != null ? fileToDelete.getName() : name, ure.getLocalizedMessage()}), (Throwable)ure);
        }
        this.deleteDatasource(fileToDelete);
    }

    public void deleteDatasourceById(String id) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        RepositoryFile fileToDelete = null;
        try {
            fileToDelete = this.repository.getFileById((Serializable)((Object)id));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0002_UNABLE_TO_DELETE_DATASOURCE", new Object[]{fileToDelete != null ? fileToDelete.getName() : id, ure.getLocalizedMessage()}), (Throwable)ure);
        }
        this.deleteDatasource(fileToDelete);
    }

    private void deleteDatasource(RepositoryFile file) throws DatasourceMgmtServiceException {
        try {
            if (file == null) {
                throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0002_UNABLE_TO_DELETE_DATASOURCE", new Object[]{"", ""}));
            }
            this.repository.deleteFile(file.getId(), true, null);
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0002_UNABLE_TO_DELETE_DATASOURCE", new Object[]{file.getName(), ure.getLocalizedMessage()}), (Throwable)ure);
        }
    }

    public IDatabaseConnection getDatasourceByName(String name) throws DatasourceMgmtServiceException {
        RepositoryFile file = null;
        try {
            file = this.repository.getFile(this.getPath(name));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", new Object[]{name, ure.getLocalizedMessage()}), (Throwable)ure);
        }
        if (file != null) {
            return this.getDatasource(file);
        }
        return null;
    }

    public IDatabaseConnection getDatasourceById(String id) throws DatasourceMgmtServiceException {
        RepositoryFile file = null;
        try {
            file = this.repository.getFileById((Serializable)((Object)id));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", new Object[]{file != null ? file.getName() : id}), (Throwable)ure);
        }
        if (file != null) {
            return this.getDatasource(file);
        }
        return null;
    }

    private IDatabaseConnection getDatasource(RepositoryFile file) throws DatasourceMgmtServiceException {
        try {
            if (file != null) {
                NodeRepositoryFileData data = (NodeRepositoryFileData)this.repository.getDataForRead(file.getId(), NodeRepositoryFileData.class);
                IDatabaseConnection databaseConnection = this.databaseHelper.dataNodeToDatabaseConnection(file.getId(), file.getTitle(), data.getNode());
                return databaseConnection;
            }
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", new Object[]{"", ""}));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", new Object[]{file.getName(), ure.getLocalizedMessage()}), (Throwable)ure);
        }
    }

    public List<IDatabaseConnection> getDatasources() throws DatasourceMgmtServiceException {
        try {
            ArrayList<IDatabaseConnection> datasourceList = new ArrayList<IDatabaseConnection>();
            List<RepositoryFile> repositoryFiles = this.getRepositoryFiles();
            if (repositoryFiles != null) {
                for (RepositoryFile file : repositoryFiles) {
                    NodeRepositoryFileData data = (NodeRepositoryFileData)this.repository.getDataForRead(file.getId(), NodeRepositoryFileData.class);
                    IDatabaseConnection databaseConnection = this.databaseHelper.dataNodeToDatabaseConnection(file.getId(), file.getTitle(), data.getNode());
                    datasourceList.add(databaseConnection);
                }
            }
            return datasourceList;
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", new Object[]{"", ure.getLocalizedMessage()}), (Throwable)ure);
        }
    }

    public List<String> getDatasourceIds() throws DatasourceMgmtServiceException {
        try {
            ArrayList<String> datasourceList = new ArrayList<String>();
            List<RepositoryFile> repositoryFiles = this.getRepositoryFiles();
            if (repositoryFiles != null) {
                for (RepositoryFile file : repositoryFiles) {
                    datasourceList.add(file.getId().toString());
                }
            }
            return datasourceList;
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", new Object[]{"", ure.getLocalizedMessage()}), (Throwable)ure);
        }
    }

    public String updateDatasourceById(String id, IDatabaseConnection databaseConnection) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        RepositoryFile file = null;
        try {
            file = this.repository.getFileById((Serializable)((Object)id));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0003_UNABLE_TO_UPDATE_DATASOURCE", new Object[]{databaseConnection.getName(), ure.getLocalizedMessage()}), (Throwable)ure);
        }
        return this.updateDatasource(file, databaseConnection);
    }

    public String updateDatasourceByName(String name, IDatabaseConnection databaseConnection) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        RepositoryFile file = null;
        try {
            file = databaseConnection.getId() != null ? this.repository.getFileById((Serializable)((Object)databaseConnection.getId())) : this.repository.getFile(this.getPath(name));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0003_UNABLE_TO_UPDATE_DATASOURCE", new Object[]{databaseConnection.getName(), ure.getLocalizedMessage()}), (Throwable)ure);
        }
        return this.updateDatasource(file, databaseConnection);
    }

    private String updateDatasource(RepositoryFile file, IDatabaseConnection databaseConnection) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        try {
            if (file != null) {
                file = new RepositoryFile.Builder(file).versionId(file.getVersionId()).id(file.getId()).title("default", databaseConnection.getName()).build();
                file = this.repository.updateFile(file, (IRepositoryFileData)new NodeRepositoryFileData(this.databaseHelper.databaseConnectionToDataNode(databaseConnection)), null);
                this.renameIfNecessary(databaseConnection, file);
                return file.getId().toString();
            }
            throw new NonExistingDatasourceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0006_DATASOURCE_DOES_NOT_EXIST", new Object[]{databaseConnection.getName()}));
        }
        catch (UnifiedRepositoryException ure) {
            throw new DatasourceMgmtServiceException(Messages.getInstance().getErrorString("DatasourceMgmtService.ERROR_0003_UNABLE_TO_UPDATE_DATASOURCE", new Object[]{databaseConnection.getName(), ure.getLocalizedMessage()}), (Throwable)ure);
        }
    }

    private String getDatabaseParentFolderPath() {
        return ClientRepositoryPaths.getEtcFolderPath() + "/" + FOLDER_PDI + "/" + FOLDER_DATABASES;
    }

    private Serializable getDatabaseParentFolderId() {
        if (this.cachedDatabaseParentFolderId == null) {
            try {
                RepositoryFile f = this.repository.getFile(this.getDatabaseParentFolderPath());
                this.cachedDatabaseParentFolderId = f.getId();
            }
            catch (UnifiedRepositoryException ure) {
                return this.cachedDatabaseParentFolderId;
            }
        }
        return this.cachedDatabaseParentFolderId;
    }

    private List<RepositoryFile> getRepositoryFiles() {
        Serializable folderId = this.getDatabaseParentFolderId();
        if (folderId != null) {
            return this.repository.getChildren(folderId, "*" + RepositoryObjectType.DATABASE.getExtension());
        }
        return null;
    }

    private String getPath(String name) {
        String escapedName = RepositoryFilenameUtils.escape(name, this.cachedReservedChars);
        return this.getDatabaseParentFolderPath() + "/" + escapedName + RepositoryObjectType.DATABASE.getExtension();
    }

    private void renameIfNecessary(IDatabaseConnection databaseConnection, RepositoryFile file) {
        if (!this.isRenamed(databaseConnection, file)) {
            return;
        }
        StringBuilder buf = new StringBuilder(file.getPath().length());
        buf.append(this.getParentPath(file.getPath()));
        buf.append("/");
        buf.append(RepositoryFilenameUtils.escape(databaseConnection.getName(), this.cachedReservedChars));
        buf.append(RepositoryObjectType.DATABASE.getExtension());
        this.repository.moveFile(file.getId(), buf.toString(), null);
    }

    private boolean isRenamed(IDatabaseConnection databaseConnection, RepositoryFile file) {
        String filename = databaseConnection.getName() + RepositoryObjectType.DATABASE.getExtension();
        return !file.getName().equals(RepositoryFilenameUtils.escape(filename, this.cachedReservedChars));
    }

    protected String getParentPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if ("/".equals(path)) {
            return null;
        }
        int lastSlashIndex = path.lastIndexOf("/");
        if (lastSlashIndex == 0) {
            return "/";
        }
        if (lastSlashIndex > 0) {
            return path.substring(0, lastSlashIndex);
        }
        throw new IllegalArgumentException();
    }
}

