/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr.sejcr;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.pentaho.platform.repository2.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.extensions.jcr.SessionFactory;
import org.springframework.extensions.jcr.SessionFactoryUtils;
import org.springframework.security.access.AccessDeniedException;

public class PentahoJcrTemplate
extends JcrTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(PentahoJcrTemplate.class);

    public Object execute(JcrCallback action, boolean exposeNativeSession) throws DataAccessException {
        Session session = null;
        try {
            Object result;
            session = this.getSession();
            this.useSession(session);
            Session sessionToExpose = exposeNativeSession ? session : this.createSessionProxy(session);
            Object object = result = action.doInJcr(sessionToExpose);
            return object;
        }
        catch (RepositoryException ex) {
            throw this.pentahoConvertJcrAccessException(ex);
        }
        catch (IOException ex) {
            throw this.convertJcrAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw this.pentahoConvertJcrAccessException(ex);
        }
        finally {
            this.releaseSession(session);
        }
    }

    private void useSession(Session session) {
        this.getUsageCount(session).incrementAndGet();
    }

    private void releaseSession(Session session) {
        this.getUsageCount(session).decrementAndGet();
    }

    private AtomicInteger getUsageCount(Session session) {
        Objects.requireNonNull(session);
        Object usageCount = session.getAttribute("usage_count");
        if (usageCount instanceof AtomicInteger) {
            return (AtomicInteger)usageCount;
        }
        LOG.debug("No usage count associated with session " + session + "\nThis can safely happen with uncached sessions. ");
        return new AtomicInteger(0);
    }

    protected Session getSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)this.isAllowCreate());
    }

    private RuntimeException pentahoConvertJcrAccessException(RuntimeException ex) {
        if (ex instanceof AccessControlException) {
            return new AccessDeniedException(Messages.getInstance().getString("PentahoJcrTemplate.ERROR_0001_ACCESS_DENIED"), (Throwable)ex);
        }
        return super.convertJcrAccessException(ex);
    }

    private RuntimeException pentahoConvertJcrAccessException(RepositoryException ex) {
        if (ex instanceof javax.jcr.AccessDeniedException) {
            return new AccessDeniedException(Messages.getInstance().getString("PentahoJcrTemplate.ERROR_0001_ACCESS_DENIED"), (Throwable)ex);
        }
        return super.convertJcrAccessException(ex);
    }
}

