/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.job;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.hdfs.job.JobEntryHadoopCopyFiles;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.HadoopVfsFileChooserDialog;
import org.pentaho.big.data.plugins.common.ui.NamedClusterWidgetImpl;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.copyfiles.JobEntryCopyFiles;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.job.entries.copyfiles.JobEntryCopyFilesDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobEntryHadoopCopyFilesDialog
extends JobEntryCopyFilesDialog {
    private static Class<?> BASE_PKG = JobEntryCopyFiles.class;
    private static Class<?> PKG = JobEntryHadoopCopyFiles.class;
    private LogChannel log = new LogChannel((Object)this);
    private JobEntryHadoopCopyFiles jobEntryHadoopCopyFiles;
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    public static final String S3_ENVIRONMENT = "S3";

    public JobEntryHadoopCopyFilesDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryCopyFiles)jobEntryInt;
        this.jobEntryHadoopCopyFiles = (JobEntryHadoopCopyFiles)this.jobEntry;
        this.namedClusterService = this.jobEntryHadoopCopyFiles.getNamedClusterService();
        this.runtimeTestActionService = this.jobEntryHadoopCopyFiles.getRuntimeTestActionService();
        this.runtimeTester = this.jobEntryHadoopCopyFiles.getRuntimeTester();
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(BASE_PKG, (String)"JobCopyFiles.Name.Default", (String[])new String[0]));
        }
    }

    protected void initUI() {
        super.initUI();
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobHadoopCopyFiles.Title", (String[])new String[0]));
    }

    protected SelectionAdapter getFileSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = JobEntryHadoopCopyFilesDialog.this.wFields.getActiveTableItem().getText(JobEntryHadoopCopyFilesDialog.this.wFields.getActiveTableColumn());
                String clusterName = JobEntryHadoopCopyFilesDialog.this.wFields.getActiveTableItem().getText(JobEntryHadoopCopyFilesDialog.this.wFields.getActiveTableColumn() - 1);
                JobEntryHadoopCopyFilesDialog.this.setSelectedFile(path, clusterName);
            }
        };
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        this.wName.selectAll();
        this.wCopyEmptyFolders.setSelection(this.jobEntry.copy_empty_folders);
        if (this.jobEntry.source_filefolder != null) {
            for (int i = 0; i < this.jobEntry.source_filefolder.length; ++i) {
                String clusterName;
                TableItem ti = this.wFields.table.getItem(i);
                if (this.jobEntry.source_filefolder[i] != null) {
                    String sourceUrl = this.jobEntry.source_filefolder[i];
                    clusterName = this.jobEntry.getConfigurationBy(sourceUrl);
                    if (clusterName != null) {
                        clusterName = clusterName.startsWith("LOCAL-SOURCE-FILE-") ? "Local" : clusterName;
                        clusterName = clusterName.startsWith("STATIC-SOURCE-FILE-") ? "<Static>" : clusterName;
                        clusterName = clusterName.startsWith("S3-SOURCE-FILE-") ? S3_ENVIRONMENT : clusterName;
                        ti.setText(1, clusterName);
                        sourceUrl = clusterName.equals("Local") || clusterName.equals("<Static>") || clusterName.equals(S3_ENVIRONMENT) ? sourceUrl : this.jobEntry.getUrlPath(sourceUrl.replace("EMPTY_SOURCE_URL-" + i + "-", ""));
                    }
                    sourceUrl = sourceUrl != null ? sourceUrl.replace("EMPTY_SOURCE_URL-" + i + "-", "") : "";
                    ti.setText(2, sourceUrl);
                }
                if (this.jobEntry.wildcard[i] != null) {
                    ti.setText(3, this.jobEntry.wildcard[i]);
                }
                if (this.jobEntry.destination_filefolder[i] == null) continue;
                String destinationURL = this.jobEntry.destination_filefolder[i];
                clusterName = this.jobEntry.getConfigurationBy(destinationURL);
                if (clusterName != null) {
                    clusterName = clusterName.startsWith("LOCAL-DEST-FILE-") ? "Local" : clusterName;
                    clusterName = clusterName.startsWith("STATIC-DEST-FILE-") ? "<Static>" : clusterName;
                    clusterName = clusterName.startsWith("S3-DEST-FILE-") ? S3_ENVIRONMENT : clusterName;
                    ti.setText(4, clusterName);
                    destinationURL = clusterName.equals("Local") || clusterName.equals("<Static>") || clusterName.equals(S3_ENVIRONMENT) ? destinationURL : this.jobEntry.getUrlPath(destinationURL.replace("EMPTY_DEST_URL-" + i + "-", ""));
                }
                destinationURL = destinationURL != null ? destinationURL.replace("EMPTY_DEST_URL-" + i + "-", "") : "";
                ti.setText(5, destinationURL != null ? destinationURL : "");
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wPrevious.setSelection(this.jobEntry.arg_from_previous);
        this.wOverwriteFiles.setSelection(this.jobEntry.overwrite_files);
        this.wIncludeSubfolders.setSelection(this.jobEntry.include_subfolders);
        this.wRemoveSourceFiles.setSelection(this.jobEntry.remove_source_files);
        this.wDestinationIsAFile.setSelection(this.jobEntry.destination_is_a_file);
        this.wCreateDestinationFolder.setSelection(this.jobEntry.create_destination_folder);
        this.wAddFileToResult.setSelection(this.jobEntry.add_result_filesname);
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(BASE_PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(BASE_PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setCopyEmptyFolders(this.wCopyEmptyFolders.getSelection());
        this.jobEntry.setoverwrite_files(this.wOverwriteFiles.getSelection());
        this.jobEntry.setIncludeSubfolders(this.wIncludeSubfolders.getSelection());
        this.jobEntry.setArgFromPrevious(this.wPrevious.getSelection());
        this.jobEntry.setRemoveSourceFiles(this.wRemoveSourceFiles.getSelection());
        this.jobEntry.setAddresultfilesname(this.wAddFileToResult.getSelection());
        this.jobEntry.setDestinationIsAFile(this.wDestinationIsAFile.getSelection());
        this.jobEntry.setCreateDestinationFolder(this.wCreateDestinationFolder.getSelection());
        int nritems = this.wFields.nrNonEmpty();
        HashMap namedClusterURLMappings = new HashMap();
        this.jobEntry.source_filefolder = new String[nritems];
        this.jobEntry.destination_filefolder = new String[nritems];
        this.jobEntry.wildcard = new String[nritems];
        for (int i = 0; i < nritems; ++i) {
            String sourceNc = this.wFields.getNonEmpty(i).getText(1);
            sourceNc = sourceNc.equals("Local") ? "LOCAL-SOURCE-FILE-" + i : sourceNc;
            sourceNc = sourceNc.equals("<Static>") ? "STATIC-SOURCE-FILE-" + i : sourceNc;
            sourceNc = sourceNc.equals(S3_ENVIRONMENT) ? "S3-SOURCE-FILE-" + i : sourceNc;
            String source = this.wFields.getNonEmpty(i).getText(2);
            String wild = this.wFields.getNonEmpty(i).getText(3);
            String destNc = this.wFields.getNonEmpty(i).getText(4);
            destNc = destNc.equals("Local") ? "LOCAL-DEST-FILE-" + i : destNc;
            destNc = destNc.equals("<Static>") ? "STATIC-DEST-FILE-" + i : destNc;
            destNc = destNc.equals(S3_ENVIRONMENT) ? "S3-DEST-FILE-" + i : destNc;
            String dest = this.wFields.getNonEmpty(i).getText(5);
            source = "EMPTY_SOURCE_URL-" + i + "-" + source;
            dest = "EMPTY_DEST_URL-" + i + "-" + dest;
            this.jobEntry.source_filefolder[i] = this.jobEntry.loadURL(source, sourceNc, this.getMetaStore(), namedClusterURLMappings);
            this.jobEntry.destination_filefolder[i] = this.jobEntry.loadURL(dest, destNc, this.getMetaStore(), namedClusterURLMappings);
            this.jobEntry.wildcard[i] = wild;
        }
        this.jobEntry.setConfigurationMappings(namedClusterURLMappings);
        this.dispose();
    }

    private FileObject setSelectedFile(String path, String clusterName) {
        FileObject selectedFile = null;
        try {
            FileObject rootFile = null;
            FileObject initialFile = null;
            FileObject defaultInitialFile = null;
            if (!clusterName.equals("Local") && !clusterName.equals(S3_ENVIRONMENT)) {
                NamedCluster namedCluster = this.namedClusterService.getNamedClusterByName(clusterName, this.getMetaStore());
                if (Utils.isEmpty((CharSequence)path)) {
                    path = "/";
                }
                if (namedCluster == null) {
                    return null;
                }
                path = namedCluster.processURLsubstitution(path, this.getMetaStore(), (VariableSpace)this.jobMeta);
            }
            boolean resolvedInitialFile = false;
            if (clusterName.equals(S3_ENVIRONMENT) && !path.startsWith("s3://")) {
                path = "s3://";
            }
            if (path != null) {
                String fileName = this.jobMeta.environmentSubstitute(path);
                if (fileName != null && !fileName.equals("")) {
                    try {
                        initialFile = KettleVFS.getFileObject((String)fileName);
                        resolvedInitialFile = true;
                    }
                    catch (Exception e) {
                        this.showMessageAndLog(BaseMessages.getString(PKG, (String)"JobHadoopCopyFiles.Connection.Error.title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobHadoopCopyFiles.Connection.error", (String[])new String[0]), e.getMessage());
                        return null;
                    }
                    File startFile = new File(System.getProperty("user.home"));
                    defaultInitialFile = KettleVFS.getFileObject((String)startFile.getAbsolutePath());
                    rootFile = initialFile.getFileSystem().getRoot();
                } else {
                    defaultInitialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
                }
            }
            if (rootFile == null) {
                if (defaultInitialFile == null) {
                    return null;
                }
                rootFile = defaultInitialFile.getFileSystem().getRoot();
                initialFile = defaultInitialFile;
            }
            VfsFileChooserDialog fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(rootFile, initialFile);
            fileChooserDialog.defaultInitialFile = defaultInitialFile;
            NamedClusterWidgetImpl namedClusterWidget = null;
            if (clusterName.equals("Local")) {
                selectedFile = fileChooserDialog.open(this.shell, new String[]{"file"}, "file", true, path, new String[]{"*.*"}, FILETYPES, false, 2, false, false);
            } else if (clusterName.equals(S3_ENVIRONMENT)) {
                selectedFile = fileChooserDialog.open(this.shell, new String[]{"s3"}, "s3", true, path, new String[]{"*.*"}, FILETYPES, false, 2, false, true);
            } else {
                NamedCluster namedCluster = this.namedClusterService.getNamedClusterByName(clusterName, this.getMetaStore());
                if (namedCluster != null) {
                    if (namedCluster.isMapr()) {
                        selectedFile = fileChooserDialog.open(this.shell, new String[]{"maprfs"}, "maprfs", false, path, new String[]{"*.*"}, FILETYPES, true, 2, false, false);
                    } else {
                        List customPanels = fileChooserDialog.getCustomVfsUiPanels();
                        for (CustomVfsUiPanel panel : customPanels) {
                            if (!(panel instanceof HadoopVfsFileChooserDialog)) continue;
                            HadoopVfsFileChooserDialog hadoopDialog = (HadoopVfsFileChooserDialog)panel;
                            namedClusterWidget = hadoopDialog.getNamedClusterWidget();
                            namedClusterWidget.initiate();
                            hadoopDialog.setNamedCluster(clusterName);
                            hadoopDialog.initializeConnectionPanel(initialFile);
                        }
                        if (resolvedInitialFile) {
                            fileChooserDialog.initialFile = initialFile;
                        }
                        selectedFile = fileChooserDialog.open(this.shell, new String[]{"hdfs"}, "hdfs", false, path, new String[]{"*.*"}, FILETYPES, true, 2, false, false);
                    }
                }
            }
            CustomVfsUiPanel currentPanel = fileChooserDialog.getCurrentPanel();
            if (currentPanel instanceof HadoopVfsFileChooserDialog) {
                namedClusterWidget = ((HadoopVfsFileChooserDialog)currentPanel).getNamedClusterWidget();
            }
            if (selectedFile != null) {
                String url = selectedFile.getURL().toString();
                if (currentPanel != null) {
                    if (currentPanel.getVfsSchemeDisplayText().equals("Local")) {
                        this.wFields.getActiveTableItem().setText(this.wFields.getActiveTableColumn() - 1, "Local");
                    } else if (currentPanel.getVfsSchemeDisplayText().equals(S3_ENVIRONMENT)) {
                        this.wFields.getActiveTableItem().setText(this.wFields.getActiveTableColumn() - 1, S3_ENVIRONMENT);
                    } else if (namedClusterWidget != null && namedClusterWidget.getSelectedNamedCluster() != null) {
                        url = this.jobEntry.getUrlPath(url);
                        this.wFields.getActiveTableItem().setText(this.wFields.getActiveTableColumn() - 1, namedClusterWidget.getSelectedNamedCluster().getName());
                    }
                }
                this.wFields.getActiveTableItem().setText(this.wFields.getActiveTableColumn(), url);
            }
            return selectedFile;
        }
        catch (KettleFileException ex) {
            this.log.logError(BaseMessages.getString(PKG, (String)"HadoopFileInputDialog.FileBrowser.KettleFileException", (String[])new String[0]));
            return selectedFile;
        }
        catch (FileSystemException ex) {
            this.log.logError(BaseMessages.getString(PKG, (String)"HadoopFileInputDialog.FileBrowser.FileSystemException", (String[])new String[0]));
            return selectedFile;
        }
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.shell);
        box.setText(title);
        box.setMessage(message);
        this.log.logError(messageToLog);
        box.open();
    }

    protected Image getImage() {
        return GUIResource.getInstance().getImage("HDM.svg", ((Object)((Object)this)).getClass().getClassLoader(), 32, 32);
    }

    public boolean showFileButtons() {
        return false;
    }

    protected void setComboValues(ColumnInfo colInfo) {
        try {
            super.setComboValues(colInfo);
            Object[] superValues = colInfo.getComboValues();
            Object[] s3value = new String[]{S3_ENVIRONMENT};
            Object[] comboValues = (String[])ArrayUtils.addAll((Object[])superValues, (Object[])s3value);
            Object[] namedClusters = this.namedClusterService.listNames(this.getMetaStore()).toArray(new String[0]);
            String[] values = (String[])ArrayUtils.addAll((Object[])comboValues, (Object[])namedClusters);
            colInfo.setComboValues(values);
        }
        catch (MetaStoreException e) {
            this.log.logError(e.getMessage());
        }
    }
}

