/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.big.data.kettle.plugins.hive.Hive2DatabaseMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.hadoop.shim.api.jdbc.DriverLocator;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DatabaseMetaPlugin(type="IMPALA", typeDescription="Impala")
public class ImpalaDatabaseMeta
extends Hive2DatabaseMeta
implements DatabaseInterface {
    public static final String AUTH_NO_SASL = ";auth=noSasl";
    protected static final String JAR_FILE = "hive-jdbc-cdh4.2.0-release-pentaho.jar";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.HiveDriver";
    protected static final int DEFAULT_PORT = 21050;
    private static final Logger logChannel = LoggerFactory.getLogger(ImpalaDatabaseMeta.class);

    public ImpalaDatabaseMeta(DriverLocator driverLocator, NamedClusterService namedClusterService, MetastoreLocator metastoreLocator) {
        super(driverLocator, namedClusterService, metastoreLocator);
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    @Override
    public String getDriverClass() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval = retval + "BOOLEAN";
                break;
            }
            case 3: 
            case 9: {
                if (this.isDriverVersion(0, 8)) {
                    retval = retval + "TIMESTAMP";
                    break;
                }
                throw new IllegalArgumentException("Timestamp types not supported in this version of Impala");
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "FLOAT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                retval = length > 15 ? retval + "FLOAT" : retval + "DOUBLE";
            }
        }
        return retval;
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        StringBuilder urlBuffer = new StringBuilder();
        if (Const.isEmpty((String)port)) {
            port = Integer.toString(this.getDefaultDatabasePort());
        }
        String principal = this.getAttributes().getProperty("principal");
        String extraPrincipal = this.getAttributes().getProperty("EXTRA_OPTION_" + this.getPluginId() + ".principal");
        urlBuffer.append("jdbc:hive2://").append(hostname).append(":").append(port).append("/").append(databaseName);
        if (principal == null && extraPrincipal == null) {
            urlBuffer.append(AUTH_NO_SASL);
        }
        urlBuffer.append(";impala_db=true");
        return urlBuffer.toString();
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    public int getDefaultDatabasePort() {
        return 21050;
    }

    @Override
    public List<String> getNamedClusterList() {
        try {
            return this.namedClusterService.listNames(this.metastoreLocator.getMetastore());
        }
        catch (MetaStoreException e) {
            logChannel.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void putOptionalOptions(Map<String, String> extraOptions) {
        if (this.getNamedCluster() != null && this.getNamedCluster().trim().length() > 0) {
            extraOptions.put(this.getPluginId() + ".pentahoNamedCluster", this.getNamedCluster());
        }
    }
}

