/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.servicecoordination.impl;

import java.util.concurrent.Phaser;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;

public class PhaserServiceBarrier
implements IServiceBarrier {
    private final Phaser phaser = new Phaser();
    private String serviceId;

    public PhaserServiceBarrier() {
    }

    public PhaserServiceBarrier(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public int hold() {
        return this.phaser.register();
    }

    @Override
    public int release() {
        return this.phaser.arriveAndDeregister();
    }

    @Override
    public int getHoldCount() {
        return this.phaser.getUnarrivedParties();
    }

    @Override
    public boolean isAvailable() {
        return this.phaser.getUnarrivedParties() <= 0;
    }

    @Override
    public int awaitAvailability() throws InterruptedException {
        if (this.isAvailable()) {
            return this.phaser.getPhase();
        }
        this.phaser.register();
        this.phaser.arrive();
        int phase = this.phaser.awaitAdvanceInterruptibly(this.phaser.getPhase());
        if (this.phaser.isTerminated()) {
            throw new InterruptedException();
        }
        return phase;
    }

    @Override
    public void terminate() {
        this.phaser.forceTermination();
    }

    @Override
    public boolean isTerminated() {
        return this.phaser.isTerminated();
    }
}

