/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromFileProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.writer.TransformationProducerWriteHandlerLib;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class FileTransformationProducerWriteHandler
implements TransformationProducerWriteHandler {
    @Override
    public void writeKettleRepositoryProducer(WriteableDocumentBundle bundle, String dataSourceFileName, XmlWriter xmlWriter, String queryName, KettleTransformationProducer producer) throws IOException, BundleWriterException {
        if (!(producer instanceof KettleTransFromFileProducer)) {
            throw new BundleWriterException("Invalid object type registered for handler of " + KettleTransFromFileProducer.class.getSimpleName());
        }
        KettleTransFromFileProducer fileProducer = (KettleTransFromFileProducer)producer;
        AttributeList coreAttrs = new AttributeList();
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "name", queryName);
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "repository", fileProducer.getRepositoryName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "filename", fileProducer.getTransformationFile());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "step", fileProducer.getStepName());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "username", fileProducer.getUsername());
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "password", PasswordEncryptionService.getInstance().encrypt(fileProducer.getPassword()));
        coreAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "stop-on-error", String.valueOf(fileProducer.isStopOnError()));
        String[] definedArgumentNames = fileProducer.getDefinedArgumentNames();
        ParameterMapping[] parameterMappings = fileProducer.getDefinedVariableNames();
        if (definedArgumentNames.length == 0 && parameterMappings.length == 0) {
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-file", coreAttrs, true);
            return;
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/kettle", "query-file", coreAttrs, false);
        TransformationProducerWriteHandlerLib.writeParameterAndArguments(xmlWriter, fileProducer);
        xmlWriter.writeCloseTag();
    }
}

