/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.monitors.stream.StreamMonitor;

public final class StreamUtils {
    private static final int BUFFER_SIZE = 102400;

    private StreamUtils() {
    }

    public static void copyStream(InputStream src, OutputStream dest, boolean closeStreams) throws IOException, NullArgumentException {
        StreamUtils.copyStream(null, null, 0, src, dest, closeStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(StreamMonitor monitor, URL sourceURL, int expected, InputStream source, OutputStream destination, boolean closeStreams) throws IOException, NullArgumentException {
        NullArgumentException.validateNotNull((Object)source, (String)"source");
        NullArgumentException.validateNotNull((Object)destination, (String)"destination");
        int count = 0;
        byte[] buffer = new byte[102400];
        BufferedOutputStream dest = destination instanceof BufferedOutputStream ? (BufferedOutputStream)destination : new BufferedOutputStream(destination);
        BufferedInputStream src = source instanceof BufferedInputStream ? (BufferedInputStream)source : new BufferedInputStream(source);
        try {
            int length;
            while ((length = src.read(buffer)) >= 0) {
                count += length;
                dest.write(buffer, 0, length);
                if (null == monitor) continue;
                monitor.notifyUpdate(sourceURL, expected, count);
            }
            dest.flush();
        }
        finally {
            if (closeStreams) {
                StreamUtils.closeStreams(src, dest);
            }
            if (null != monitor) {
                monitor.notifyCompletion(sourceURL);
            }
        }
    }

    private static void closeStreams(InputStream src, OutputStream dest) {
        try {
            src.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            dest.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean compareStreams(InputStream in1, InputStream in2) throws IOException {
        int v1;
        boolean moreOnIn1;
        do {
            int v2;
            if ((v1 = in1.read()) == (v2 = in2.read())) continue;
            return false;
        } while (moreOnIn1 = v1 != -1);
        boolean noMoreOnIn2Either = in2.read() == -1;
        return noMoreOnIn2Either;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyReaderToWriter(Reader input, Writer output, boolean close) throws IOException {
        try {
            BufferedReader in = StreamUtils.bufferInput(input);
            BufferedWriter out = StreamUtils.bufferOutput(output);
            int ch = in.read();
            while (ch != -1) {
                out.write(ch);
                ch = in.read();
            }
            out.flush();
            out.close();
        }
        finally {
            if (close) {
                input.close();
                output.close();
            }
        }
    }

    private static BufferedWriter bufferOutput(Writer writer) {
        BufferedWriter out = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        return out;
    }

    private static BufferedReader bufferInput(Reader reader) {
        BufferedReader in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return in;
    }

    public static void copyStreamToWriter(InputStream in, Writer out, String encoding, boolean close) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding);
        StreamUtils.copyReaderToWriter(reader, out, close);
    }

    public static void copyReaderToStream(Reader in, OutputStream out, String encoding, boolean close) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
        StreamUtils.copyReaderToWriter(in, writer, close);
    }
}

