/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.wrapper.MongoWrapperUtil;
import org.pentaho.mongo.wrapper.field.MongodbInputDiscoverFieldsImpl;

public class MongoDbInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MongoDbInputMeta.class;
    private MongoDbInputMeta meta;
    private MongoDbInputData data;
    private boolean m_serverDetermined;
    private Object[] m_currentInputRowDrivingQuery = null;

    public MongoDbInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            boolean hasNext;
            if (this.meta.getExecuteForEachIncomingRow() && this.m_currentInputRowDrivingQuery == null) {
                this.m_currentInputRowDrivingQuery = this.getRow();
                if (this.m_currentInputRowDrivingQuery == null) {
                    this.setOutputDone();
                    return false;
                }
                if (!this.first) {
                    this.initQuery();
                }
            }
            if (this.first) {
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
                this.initQuery();
                this.first = false;
                this.data.init();
            }
            boolean bl = (this.meta.getQueryIsPipeline() ? this.data.m_pipelineResult.hasNext() : this.data.cursor.hasNext()) && !this.isStopped() ? true : (hasNext = false);
            if (hasNext) {
                ServerAddress s;
                DBObject nextDoc = null;
                Object[] row = null;
                nextDoc = this.meta.getQueryIsPipeline() ? this.data.m_pipelineResult.next() : this.data.cursor.next();
                if (!this.meta.getQueryIsPipeline() && !this.m_serverDetermined && (s = this.data.cursor.getServerAddress()) != null) {
                    this.m_serverDetermined = true;
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{s.toString()}));
                }
                if (this.meta.getOutputJson() || this.meta.getMongoFields() == null || this.meta.getMongoFields().size() == 0) {
                    String json = JSON.serialize((Object)nextDoc);
                    row = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
                    int index = 0;
                    row[index++] = json;
                    this.putRow(this.data.outputRowMeta, row);
                } else {
                    Object[][] outputRows = this.data.mongoDocumentToKettle(nextDoc, (VariableSpace)this);
                    for (int i = 0; i < outputRows.length; ++i) {
                        this.putRow(this.data.outputRowMeta, outputRows[i]);
                    }
                }
            } else {
                if (!this.meta.getExecuteForEachIncomingRow()) {
                    this.setOutputDone();
                    return false;
                }
                this.m_currentInputRowDrivingQuery = null;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)e;
            }
            throw new KettleException((Throwable)e);
        }
    }

    protected void initQuery() throws KettleException, MongoDbException {
        if (this.data.cursor != null) {
            this.data.cursor.close();
        }
        if (this.log.isDetailed()) {
            this.m_serverDetermined = false;
        }
        String query = this.environmentSubstitute(this.meta.getJsonQuery());
        String fields = this.environmentSubstitute(this.meta.getFieldsName());
        if (Const.isEmpty((String)query) && Const.isEmpty((String)fields)) {
            if (this.meta.getQueryIsPipeline()) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            this.data.cursor = this.data.collection.find();
        } else if (this.meta.getQueryIsPipeline()) {
            Cursor cursor;
            if (Const.isEmpty((String)query)) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            if (this.meta.getExecuteForEachIncomingRow() && this.m_currentInputRowDrivingQuery != null) {
                query = this.fieldSubstitute(query, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{query}));
            List<DBObject> pipeline = MongodbInputDiscoverFieldsImpl.jsonPipelineToDBObjectList(query);
            DBObject firstP = pipeline.get(0);
            DBObject[] remainder = null;
            if (pipeline.size() > 1) {
                remainder = new DBObject[pipeline.size() - 1];
                for (int i = 1; i < pipeline.size(); ++i) {
                    remainder[i - 1] = pipeline.get(i);
                }
            } else {
                remainder = new DBObject[]{};
            }
            this.data.m_pipelineResult = cursor = this.data.collection.aggregate(firstP, remainder);
        } else {
            if (this.meta.getExecuteForEachIncomingRow() && this.m_currentInputRowDrivingQuery != null) {
                query = this.fieldSubstitute(query, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
                fields = this.fieldSubstitute(fields, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.ExecutingQuery", (String[])new String[]{query}));
            DBObject dbObject = (DBObject)JSON.parse((String)(Const.isEmpty((String)query) ? "{}" : query));
            DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
            this.data.cursor = this.data.collection.find(dbObject, dbObject2);
        }
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.meta = (MongoDbInputMeta)stepMetaInterface;
            this.data = (MongoDbInputData)stepDataInterface;
            String hostname = this.environmentSubstitute(this.meta.getHostnames());
            int port = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)27017);
            String db = this.environmentSubstitute(this.meta.getDbName());
            String collection = this.environmentSubstitute(this.meta.getCollection());
            try {
                if (Const.isEmpty((String)db)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                }
                if (Const.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!Const.isEmpty((String)this.meta.getAuthenticationUser())) {
                    String authInfo = this.meta.getUseKerberosAuthentication() ? BaseMessages.getString(PKG, (String)"MongoDbInput.Message.KerberosAuthentication", (String[])new String[]{this.environmentSubstitute(this.meta.getAuthenticationUser())}) : BaseMessages.getString(PKG, (String)"MongoDbInput.Message.NormalAuthentication", (String[])new String[]{this.environmentSubstitute(this.meta.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                this.data.clientWrapper = MongoWrapperUtil.createMongoClientWrapper(this.meta, (VariableSpace)this, this.log);
                this.data.collection = this.data.clientWrapper.getCollection(db, collection);
                if (!((MongoDbInputMeta)stepMetaInterface).getOutputJson()) {
                    ((MongoDbInputData)stepDataInterface).setMongoFields(((MongoDbInputMeta)stepMetaInterface).getMongoFields());
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorConnectingToMongoDb.Exception", (String[])new String[]{hostname, "" + port, db, collection}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.cursor != null) {
            try {
                this.data.cursor.close();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
        if (this.data.clientWrapper != null) {
            try {
                this.data.clientWrapper.dispose();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
        super.dispose(smi, sdi);
    }
}

