/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.spark;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.job.entries.spark.JobEntrySparkSubmit;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.JobEntryAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEntrySparkSubmitAnalyzer
extends JobEntryAnalyzer<JobEntrySparkSubmit> {
    private static final String CLASS_NAME = "className";
    private static final String PY_FILE = "pyFile";
    private static final String ARGUMENTS = "arguments";
    private static final String EXEC_MEMORY = "executorMemory";
    private static final String DRIVER_MEMORY = "driverMemory";
    private static final String MASTER_URL = "masterUrl";
    private Logger log = LoggerFactory.getLogger(JobEntrySparkSubmitAnalyzer.class);

    public Set<Class<? extends JobEntryInterface>> getSupportedEntries() {
        HashSet<Class<? extends JobEntryInterface>> supportedEntries = new HashSet<Class<? extends JobEntryInterface>>();
        supportedEntries.add(JobEntrySparkSubmit.class);
        return supportedEntries;
    }

    protected void customAnalyze(JobEntrySparkSubmit entry, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        rootNode.setProperty(ARGUMENTS, (Object)entry.environmentSubstitute(entry.getArgs()));
        rootNode.setProperty(EXEC_MEMORY, (Object)entry.environmentSubstitute(entry.getExecutorMemory()));
        rootNode.setProperty(DRIVER_MEMORY, (Object)entry.environmentSubstitute(entry.getDriverMemory()));
        rootNode.setProperty(MASTER_URL, (Object)entry.environmentSubstitute(entry.getMaster()));
        if ("Java or Scala".equals(entry.getJobType())) {
            rootNode.setProperty(CLASS_NAME, (Object)entry.environmentSubstitute(entry.getClassName()));
            if (StringUtils.isNotBlank((String)entry.getJar())) {
                rootNode.setProperty("applicationJar", (Object)this.normalizePath(entry.environmentSubstitute(entry.getJar())));
            }
        } else if ("Python".equals(entry.getJobType()) && StringUtils.isNotBlank((String)entry.getPyFile())) {
            rootNode.setProperty("applicationJar", (Object)this.normalizePath(entry.environmentSubstitute(entry.getPyFile())));
        }
    }

    private String normalizePath(String path) {
        if (StringUtils.isNotBlank((String)path)) {
            return path.replaceAll("/", StringEscapeUtils.escapeJava((String)"/")).replaceAll("\\\\", StringEscapeUtils.escapeJava((String)"/"));
        }
        return path;
    }
}

