/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.spoon.Spoon;

public class ThinDialog
extends Dialog {
    private final boolean doAuthenticate;
    protected Shell parent;
    protected int width;
    protected int height;
    protected Browser browser;
    protected Shell dialog;
    protected Display display;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private LogChannelInterface log = this.spoonSupplier.get().getLog();
    private static final String SECURITY_CHECK_PATH = "/j_spring_security_check";

    public ThinDialog(Shell shell, int width, int height, boolean doAuthenticate) {
        super(shell);
        this.width = width;
        this.height = height;
        this.doAuthenticate = doAuthenticate;
    }

    public ThinDialog(Shell shell, int width, int height) {
        this(shell, width, height, false);
    }

    public void createDialog(String title, String url, int options, Image logo) {
        this.display = this.getParent().getDisplay();
        this.dialog = new Shell(this.getParent(), options);
        this.dialog.setText(title);
        this.dialog.setImage(logo);
        this.dialog.setSize(this.width, this.height);
        this.dialog.setLayout((Layout)new FillLayout());
        this.dialog.addListener(31, e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        });
        try {
            this.browser = new Browser((Composite)this.dialog, 0);
            if (this.doAuthenticate) {
                this.authenticate();
            }
            this.browser.setUrl(url);
            this.browser.addCloseWindowListener(event -> {
                Browser browse = (Browser)event.widget;
                Shell shell = browse.getShell();
                shell.close();
            });
        }
        catch (Exception e2) {
            MessageBox messageBox = new MessageBox(this.dialog, 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Exit");
            messageBox.open();
        }
        this.setPosition();
        this.dialog.open();
    }

    protected void setPosition() {
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = this.dialog.getSize();
        this.dialog.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }

    private void authenticate() {
        Repository repo = this.spoonSupplier.get().getRepository();
        if (repo != null) {
            repo.getUri().ifPresent(uri -> this.setCookies(repo.getUserInfo(), (URI)uri));
        }
    }

    private void setCookies(IUser user, URI uri) {
        Objects.requireNonNull(this.browser);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            URIBuilder builder = new URIBuilder(uri.toString() + SECURITY_CHECK_PATH);
            builder.addParameter("j_username", user.getName()).addParameter("j_password", user.getPassword());
            this.log.logDebug("Authenticating with " + user.getName());
            HttpResponse resp = client.execute((HttpUriRequest)new HttpPost(builder.build()));
            Arrays.stream(resp.getHeaders("Set-Cookie")).map(NameValuePair::getValue).flatMap(s -> HttpCookie.parse(s).stream()).forEach(cookie -> Browser.setCookie((String)cookie.toString(), (String)uri.toString()));
        }
        catch (IOException | URISyntaxException e) {
            this.log.logError(e.getMessage(), (Throwable)e);
        }
    }
}

