/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.events.dialog;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.core.events.dialog.ConnectionFilterType;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.ProviderFilterType;
import org.pentaho.di.ui.core.events.dialog.RepositoryUtility;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.events.dialog.extension.ExtensionPointWrapper;
import org.pentaho.di.ui.core.events.dialog.extension.SpoonOpenExtensionPointWrapper;

public abstract class SelectionAdapterFileDialog<T>
extends SelectionAdapter {
    private final LogChannelInterface log;
    private final T textWidget;
    private final AbstractMeta meta;
    private final RepositoryUtility repositoryUtility;
    private final ExtensionPointWrapper extensionPointWrapper;
    private SelectionAdapterOptions options;

    public SelectionAdapterFileDialog(LogChannelInterface log, T textWidget, AbstractMeta meta, SelectionAdapterOptions options, RepositoryUtility repositoryUtility, ExtensionPointWrapper extensionPointWrapper) {
        this.log = log;
        this.textWidget = textWidget;
        this.meta = meta;
        this.options = options;
        this.repositoryUtility = repositoryUtility;
        this.extensionPointWrapper = extensionPointWrapper;
    }

    public SelectionAdapterFileDialog(LogChannelInterface log, T textWidget, AbstractMeta meta, SelectionAdapterOptions options) {
        this(log, textWidget, meta, options, new RepositoryUtility(), new SpoonOpenExtensionPointWrapper());
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        super.widgetSelected(selectionEvent);
        this.widgetSelectedHelper();
    }

    public T getTextWidget() {
        return this.textWidget;
    }

    protected abstract String getText();

    protected abstract void setText(String var1);

    void setSelectionOptions(SelectionAdapterOptions options) {
        this.options = options;
    }

    SelectionAdapterOptions getSelectionOptions() {
        return this.options;
    }

    private void widgetSelectedHelper() {
        String initialFilePath = "";
        FileObject initialFile = null;
        String path = "";
        if (this.getText() != null) {
            try {
                initialFilePath = this.resolveFile(this.meta, this.getText());
                initialFile = KettleVFS.getFileObject((String)initialFilePath);
                if (Utils.isEmpty((CharSequence)initialFilePath) && initialFile != null) {
                    initialFilePath = initialFile.getName().getPath();
                }
            }
            catch (Exception e) {
                this.log.logError("Error in widgetSelectedHelper", (Throwable)e);
                initialFile = null;
            }
            try {
                FileDialogOperation fileDialogOperation = this.constructFileDialogOperation(this.options.getSelectionOperation(), initialFilePath, initialFile, this.options.getFilters(), this.options.getProviderFilters(), this.options.getConnectionFilters());
                this.extensionPointWrapper.callExtensionPoint(this.log, KettleExtensionPoint.SpoonOpenSaveNew.id, fileDialogOperation);
                path = this.constructPath(fileDialogOperation);
            }
            catch (KettleException ke) {
                this.log.logError("Error in widgetSelectedHelper", (Throwable)ke);
            }
        }
        if (!Utils.isEmpty((CharSequence)path)) {
            this.setText(path);
        }
    }

    private FileDialogOperation constructFileDialogOperation(SelectionOperation selectionOperation, String initialFilePath, FileObject initialFile, String[] filter, String[] providerFilters, List<ConnectionFilterType> connectionFilterTypes) {
        FileDialogOperation fileDialogOperation = this.createFileDialogOperation(selectionOperation);
        this.setProviderFilters(fileDialogOperation, providerFilters);
        this.setProvider(fileDialogOperation);
        String connectionFilter = connectionFilterTypes.stream().map(Enum::toString).collect(Collectors.joining(","));
        fileDialogOperation.setConnectionTypeFilter(connectionFilter);
        try {
            if (initialFile != null && initialFile.exists()) {
                this.setPath(fileDialogOperation, initialFile, initialFilePath);
                this.setFilename(fileDialogOperation, initialFile);
                this.setStartDir(fileDialogOperation, initialFile, initialFilePath);
            }
        }
        catch (Exception e) {
            fileDialogOperation.setPath(null);
            fileDialogOperation.setFilename(null);
            fileDialogOperation.setStartDir(null);
        }
        if (fileDialogOperation.getPath() == null && fileDialogOperation.getStartDir() == null) {
            fileDialogOperation.setPath(initialFilePath);
        }
        this.setFilter(fileDialogOperation, filter);
        fileDialogOperation.setDefaultFilter(this.options.getDefaultFilter());
        fileDialogOperation.setUseSchemaPath(this.options.getUseSchemaPath());
        return fileDialogOperation;
    }

    protected String resolveFile(AbstractMeta abstractMeta, String unresolvedPath) {
        return abstractMeta.environmentSubstitute(unresolvedPath);
    }

    FileDialogOperation createFileDialogOperation(SelectionOperation selectionOperation) {
        switch (selectionOperation) {
            case FILE: {
                return new FileDialogOperation("selectFile", "spoon");
            }
            case FOLDER: {
                return new FileDialogOperation("selectFolder", "spoon");
            }
            case FILE_OR_FOLDER: {
                return new FileDialogOperation("selectFileFolder", "spoon");
            }
            case SAVE: {
                return new FileDialogOperation("save", "spoon");
            }
            case SAVE_TO: {
                return new FileDialogOperation("saveTo", "spoon");
            }
            case SAVE_TO_FILE_FOLDER: {
                return new FileDialogOperation("saveToFileFolder", "spoon");
            }
            case OPEN: {
                return new FileDialogOperation("open", "spoon");
            }
        }
        throw new IllegalArgumentException("Unexpected SelectionOperation: " + (Object)((Object)selectionOperation));
    }

    void setPath(FileDialogOperation fileDialogOperation, FileObject fileObject, String filePath) throws KettleException {
        try {
            fileDialogOperation.setPath(fileObject.isFile() ? filePath : null);
        }
        catch (FileSystemException fse) {
            throw new KettleException("failed to check isFile in setPath()", (Throwable)fse);
        }
    }

    void setFilename(FileDialogOperation fileDialogOperation, FileObject fileObject) throws KettleException {
        try {
            fileDialogOperation.setFilename(fileObject.isFile() ? fileObject.getName().getBaseName() : null);
        }
        catch (FileSystemException fse) {
            throw new KettleException("failed to check isFile in setFilename()", (Throwable)fse);
        }
    }

    void setStartDir(FileDialogOperation fileDialogOperation, FileObject fileObject, String filePath) throws KettleException {
        try {
            fileDialogOperation.setStartDir(fileObject.isFolder() ? filePath : null);
        }
        catch (FileSystemException fse) {
            throw new KettleException("failed to check isFile in setStartDir()", (Throwable)fse);
        }
    }

    void setProvider(FileDialogOperation fileDialogOperation) {
        if ((fileDialogOperation.getProviderFilter() == null || fileDialogOperation.getProviderFilter().contains(ProviderFilterType.REPOSITORY.toString()) || fileDialogOperation.getProviderFilter().contains(ProviderFilterType.ALL_PROVIDERS.toString())) && this.isConnectedToRepository()) {
            fileDialogOperation.setProvider(ProviderFilterType.REPOSITORY.toString());
        } else {
            fileDialogOperation.setProvider("");
        }
    }

    protected void setFilter(FileDialogOperation fileDialogOperation, String[] filters) {
        Object[] cleanedFilters = this.cleanFilters(filters);
        String filterString = ArrayUtils.isEmpty((Object[])cleanedFilters) ? FilterType.ALL.toString() : String.join((CharSequence)",", (CharSequence[])cleanedFilters);
        fileDialogOperation.setFilter(filterString);
    }

    private void setProviderFilters(FileDialogOperation fileDialogOperation, String[] providerFilters) {
        Object[] cleanedFilters = this.cleanFilters(providerFilters);
        String providerFilterString = ArrayUtils.isEmpty((Object[])cleanedFilters) ? ProviderFilterType.DEFAULT.toString() : String.join((CharSequence)",", (CharSequence[])cleanedFilters);
        fileDialogOperation.setProviderFilter(providerFilterString);
    }

    String[] cleanFilters(String[] filters) {
        return !ArrayUtils.isEmpty((Object[])filters) ? (String[])Arrays.asList(filters).stream().filter(f -> !StringUtils.isBlank((String)f)).toArray(String[]::new) : null;
    }

    boolean isConnectedToRepository() {
        return this.repositoryUtility.isConnectedToRepository();
    }

    private String constructPath(FileDialogOperation fileDialogOperation) {
        if (Utils.isEmpty((CharSequence)fileDialogOperation.getProvider())) {
            return null;
        }
        try {
            String result;
            if (fileDialogOperation.isProviderRepository()) {
                result = this.getRepositoryFilePath(fileDialogOperation);
            } else if (fileDialogOperation.isSaveCommand() && !Utils.isEmpty((CharSequence)fileDialogOperation.getFilename())) {
                String sep = this.isUrl(fileDialogOperation.getPath()) ? "/" : File.separator;
                result = fileDialogOperation.getPath() + sep + fileDialogOperation.getFilename();
            } else {
                result = fileDialogOperation.getPath();
            }
            return this.applyRelativePathEnvVar(result);
        }
        catch (Exception e) {
            return null;
        }
    }

    String applyRelativePathEnvVar(String path) {
        String parentFolder = null;
        if (!Utils.isEmpty((CharSequence)path)) {
            if (this.isConnectedToRepository()) {
                return SelectionAdapterFileDialog.replaceCurrentDir(path.replace('\\', '/'), this.meta.getRepositoryDirectory().getPath());
            }
            String currentFile = this.meta.environmentSubstitute(this.meta.getFilename());
            try {
                parentFolder = new File(currentFile).getParent();
                parentFolder = path.startsWith(parentFolder) ? parentFolder : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Utils.isEmpty(parentFolder)) {
                try {
                    FileObject parentFileObj = KettleVFS.getFileObject((String)currentFile).getParent();
                    parentFolder = parentFileObj instanceof LocalFile ? parentFileObj.getName().getPath() : parentFileObj.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return SelectionAdapterFileDialog.replaceCurrentDir(path, parentFolder);
    }

    private static String replaceCurrentDir(String path, String parentPath) {
        if (!Utils.isEmpty((CharSequence)path) && !Utils.isEmpty((CharSequence)parentPath) && path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Directory}");
            if (Const.isWindows()) {
                path = path.replace('\\', '/');
            }
        }
        return path;
    }

    String getRepositoryFilePath(FileDialogOperation fileDialogOperation) {
        return this.getRepositoryFilePath((RepositoryElementMetaInterface)fileDialogOperation.getRepositoryObject());
    }

    private String getRepositoryFilePath(RepositoryElementMetaInterface repositoryElementMeta) {
        return this.concat(repositoryElementMeta.getRepositoryDirectory().getPath(), repositoryElementMeta.getName());
    }

    protected boolean isUrl(String path) {
        return path.matches("^[\\w]+://.*");
    }

    protected String concat(String path, String name) {
        return FilenameUtils.concat((String)path, (String)name);
    }
}

