/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.events.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.ui.core.events.dialog.ConnectionFilterType;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.ProviderFilterType;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;

public class SelectionAdapterOptions {
    private SelectionOperation selectionOperation;
    private String[] filters;
    private String defaultFilter;
    private String[] providerFilters;
    private List<ConnectionFilterType> connectionFilters = new ArrayList<ConnectionFilterType>();
    private boolean useSchemaPath;

    public SelectionAdapterOptions(SelectionOperation selectionOperation, String[] filters, String defaultFilter, String[] providerFilters, boolean useSchemaPath) {
        this.selectionOperation = selectionOperation;
        this.filters = filters;
        this.defaultFilter = defaultFilter;
        this.providerFilters = providerFilters;
        this.useSchemaPath = useSchemaPath;
    }

    public SelectionAdapterOptions(SelectionOperation selectionOperation, FilterType[] filters, FilterType defaultFilter, String[] providerFilters, boolean useSchemaPath) {
        this(selectionOperation, SelectionAdapterOptions.toStringArray(filters), SelectionAdapterOptions.toString(defaultFilter), providerFilters, useSchemaPath);
    }

    public SelectionAdapterOptions(SelectionOperation selectionOperation, String[] filters, String defaultFilter) {
        this(selectionOperation, filters, defaultFilter, null, false);
    }

    public SelectionAdapterOptions(SelectionOperation selectionOperation, FilterType[] filters, FilterType defaultFilter) {
        this(selectionOperation, SelectionAdapterOptions.toStringArray(filters), SelectionAdapterOptions.toString(defaultFilter), null, false);
    }

    public SelectionAdapterOptions(SelectionOperation selectionOperation, String[] filters, String defaultFilter, String[] providerFilters) {
        this(selectionOperation, filters, defaultFilter, providerFilters, false);
    }

    public SelectionAdapterOptions(SelectionOperation selectionOperation, FilterType[] filters, FilterType defaultFilter, ProviderFilterType[] providerFilters) {
        this(selectionOperation, SelectionAdapterOptions.toStringArray(filters), SelectionAdapterOptions.toString(defaultFilter), SelectionAdapterOptions.toStringArray(providerFilters), false);
    }

    public SelectionAdapterOptions(SelectionOperation selectionOperation) {
        this(selectionOperation, (String[])null, null, null, false);
    }

    public SelectionOperation getSelectionOperation() {
        return this.selectionOperation;
    }

    public SelectionAdapterOptions setSelectionOperation(SelectionOperation selectionOperation) {
        this.selectionOperation = selectionOperation;
        return this;
    }

    protected static String[] toStringArray(FilterType[] filterTypes) {
        return (String[])Arrays.stream(filterTypes).map(Enum::toString).toArray(String[]::new);
    }

    protected static String[] toStringArray(ProviderFilterType[] providerFilterTypes) {
        return (String[])Arrays.stream(providerFilterTypes).map(Enum::toString).toArray(String[]::new);
    }

    protected static String toString(FilterType filterType) {
        return filterType == null ? null : filterType.toString();
    }

    public String[] getFilters() {
        return this.filters;
    }

    public SelectionAdapterOptions setFilters(String[] filters) {
        this.filters = filters;
        return this;
    }

    public SelectionAdapterOptions setFilters(FilterType[] filters) {
        return this.setFilters(SelectionAdapterOptions.toStringArray(filters));
    }

    public String getDefaultFilter() {
        return this.defaultFilter;
    }

    public SelectionAdapterOptions setDefaultFilter(String defaultFilter) {
        this.defaultFilter = defaultFilter;
        return this;
    }

    public String[] getProviderFilters() {
        return this.providerFilters;
    }

    public SelectionAdapterOptions setProviderFilters(String[] providerFilters) {
        this.providerFilters = providerFilters;
        return this;
    }

    public SelectionAdapterOptions setProviderFilters(ProviderFilterType[] providerFilters) {
        return this.setProviderFilters(SelectionAdapterOptions.toStringArray(providerFilters));
    }

    public boolean getUseSchemaPath() {
        return this.useSchemaPath;
    }

    public SelectionAdapterOptions setUseSchemaPath(boolean useSchemaPath) {
        this.useSchemaPath = useSchemaPath;
        return this;
    }

    public List<ConnectionFilterType> getConnectionFilters() {
        return this.connectionFilters;
    }

    public void setConnectionFilters(List<ConnectionFilterType> connectionFilters) {
        this.connectionFilters = connectionFilters;
    }
}

