/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class WidgetBuilder<T extends Control> {
    private String text;
    private Composite container;
    private int style;
    private SWTControlFactory<T> swtControlFactory;
    private PDIVarControlFactory<T> pdiVarControlFactory;
    private FormDataBuilder formDataBuilder = new FormDataBuilder();
    private PropsUI props;
    private String[] items;
    private VariableSpace space;
    private int marginHeight = 5;
    private int marginWidth = 5;
    private Image image;

    public WidgetBuilder<T> below(Control controlAbove, int margin) {
        this.formDataBuilder.top(controlAbove, margin).left(new FormAttachment(controlAbove, 0, 16384));
        return this;
    }

    public WidgetBuilder<T> rightOf(Control controlToLeft, int margin) {
        this.formDataBuilder.left(controlToLeft, margin).top(new FormAttachment(controlToLeft, 0, 128));
        return this;
    }

    public WidgetBuilder<T> container(Composite container) {
        this.container = container;
        return this;
    }

    public WidgetBuilder<T> left(int percentageOfParent, int marginPixels) {
        this.formDataBuilder.left(percentageOfParent, marginPixels);
        return this;
    }

    public WidgetBuilder<T> right(int percentageOfParent, int marginPixels) {
        this.formDataBuilder.right(percentageOfParent, marginPixels);
        return this;
    }

    public WidgetBuilder<T> bottom(int percentageOfParent, int marginPixels) {
        this.formDataBuilder.bottom(percentageOfParent, marginPixels);
        return this;
    }

    public WidgetBuilder<T> top(int percentageOfParent, int marginPixels) {
        this.formDataBuilder.top(percentageOfParent, marginPixels);
        return this;
    }

    public WidgetBuilder<T> height(int height) {
        this.formDataBuilder.height(height);
        return this;
    }

    public WidgetBuilder<T> width(int width) {
        this.formDataBuilder.width(width);
        return this;
    }

    public WidgetBuilder<T> margin(int width, int height) {
        this.marginHeight = height;
        this.marginWidth = width;
        return this;
    }

    public WidgetBuilder<T> style(int style) {
        this.style = style;
        return this;
    }

    public WidgetBuilder<T> text(String text) {
        this.text = text;
        return this;
    }

    public WidgetBuilder<T> image(Image image) {
        this.image = image;
        return this;
    }

    public WidgetBuilder<T> items(String ... items) {
        this.items = items;
        return this;
    }

    public WidgetBuilder<T> props(PropsUI props) {
        this.props = props;
        return this;
    }

    public WidgetBuilder<T> space(VariableSpace space) {
        this.space = space;
        return this;
    }

    public WidgetBuilder<T> swtControlFactory(SWTControlFactory<T> swtControlFactory) {
        this.swtControlFactory = swtControlFactory;
        return this;
    }

    public WidgetBuilder<T> pdiVarControlFactory(PDIVarControlFactory<T> pdiVarControlFactory) {
        this.pdiVarControlFactory = pdiVarControlFactory;
        return this;
    }

    public T build() {
        if (this.swtControlFactory == null && this.pdiVarControlFactory == null) {
            throw new IllegalStateException("swtControlFactory or pdiVarControlFactory must be set.");
        }
        Control control = this.swtControlFactory != null ? (Control)this.swtControlFactory.init(this.container, this.style) : (Control)this.pdiVarControlFactory.init(this.space, this.container, this.style);
        this.typeSpecificHandling(control);
        control.setLayoutData((Object)this.formDataBuilder.result());
        this.props.setLook(control);
        return (T)control;
    }

    private void typeSpecificHandling(T control) {
        if (this.text != null) {
            this.invoke(control, "setText", this.text);
        }
        if (this.image != null) {
            this.invoke(control, "setImage", this.image);
        }
        if (this.items != null) {
            this.invoke(control, "setItems", this.items);
        }
        if (control instanceof Composite) {
            FormLayout layout = new FormLayout();
            layout.marginHeight = this.marginHeight;
            layout.marginWidth = this.marginWidth;
            ((Composite)control).setLayout((Layout)layout);
        }
    }

    private void invoke(T control, String methodName, Object val) {
        try {
            Method method = control.getClass().getMethod(methodName, val.getClass());
            method.invoke(control, val);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class Templates {
        private final VariableSpace space;
        private final PropsUI props;

        public Templates(PropsUI props, VariableSpace space) {
            this.props = props;
            this.space = space;
        }

        public WidgetBuilder<Label> label(Composite composite, String text, Control above) {
            return new WidgetBuilder().container(composite).text(text).style(16384).props(this.props).below(above, 4).swtControlFactory(Label::new);
        }

        public WidgetBuilder<Label> separator(Composite composite, Control above) {
            return new WidgetBuilder().container(composite).style(258).props(this.props).below(above, 15).left(0, 0).right(100, 0).swtControlFactory(Label::new);
        }

        public WidgetBuilder<Label> image(Composite container, Image image) {
            return new WidgetBuilder().container(container).image(image).style(131072).props(this.props).right(100, -4).swtControlFactory(Label::new);
        }

        public WidgetBuilder<TextVar> textvar(Composite composite, String text, Control above) {
            return new WidgetBuilder().container(composite).text(text).style(18436).props(this.props).below(above, 4).pdiVarControlFactory(TextVar::new).left(0, 4).right(0, 250).space(this.space);
        }

        public WidgetBuilder<Text> text(Composite composite, String text, Control above) {
            return new WidgetBuilder().container(composite).text(text).style(18436).props(this.props).below(above, 4).swtControlFactory(Text::new).left(0, 4).right(0, 250);
        }

        public WidgetBuilder<ComboVar> comboVar(Composite composite, Control above, String ... items) {
            return new WidgetBuilder().container(composite).items(items).style(18436).props(this.props).space(this.space).below(above, 4).pdiVarControlFactory(ComboVar::new);
        }

        public WidgetBuilder<ComboVar> comboVar(Composite composite, Control left, Control above, String ... items) {
            return new WidgetBuilder().container(composite).items(items).style(18436).props(this.props).space(this.space).below(above, 4).rightOf(left, 4).pdiVarControlFactory(ComboVar::new);
        }

        public WidgetBuilder<CCombo> combo(Composite composite, Control above, String ... items) {
            return new WidgetBuilder().container(composite).items(items).style(18436).props(this.props).space(this.space).below(above, 4).swtControlFactory(CCombo::new);
        }

        public WidgetBuilder<Button> button(Composite composite, String text, Control above, int style) {
            return new WidgetBuilder().container(composite).text(text).style(style).props(this.props).below(above, 10).swtControlFactory(Button::new);
        }

        public WidgetBuilder<Group> group(Composite composite, Control above, String text) {
            return new WidgetBuilder().container(composite).props(this.props).margin(4, 4).style(1).left(0, 0).right(100, -4).text(text).below(above, 15).swtControlFactory(Group::new);
        }
    }

    @FunctionalInterface
    public static interface PDIVarControlFactory<C> {
        public C init(VariableSpace var1, Composite var2, int var3);
    }

    @FunctionalInterface
    public static interface SWTControlFactory<C> {
        public C init(Composite var1, int var2);
    }
}

