/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.recordsfromstream.RecordsFromStreamMeta;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.core.widget.VFSFileSelection;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.dialog.NewSubtransDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.xul.swt.tab.TabItem;
import org.pentaho.xul.swt.tab.TabSet;

public abstract class BaseStreamingDialog
extends BaseStepDialog
implements StepDialogInterface {
    public static final int INPUT_WIDTH = 350;
    private static final Class<?> PKG = BaseStreamingDialog.class;
    protected BaseStreamStepMeta meta;
    private Spoon spoonInstance;
    protected Label wlTransPath;
    protected VFSFileSelection wFileSection;
    protected Button wbCreateSubtrans;
    protected Label wlSubStep;
    protected ComboVar wSubStep;
    protected ObjectId referenceObjectId;
    protected ObjectLocationSpecificationMethod specificationMethod;
    protected ModifyListener lsMod;
    protected Label wlBatchSize;
    protected TextVar wBatchSize;
    protected Label wlBatchDuration;
    protected TextVar wBatchDuration;
    protected TextVar wParallelism;
    protected CTabFolder wTabFolder;
    protected CTabItem wSetupTab;
    protected CTabItem wBatchTab;
    protected CTabItem wResultsTab;
    protected Composite wSetupComp;
    protected Composite wBatchComp;
    protected Composite wResultsComp;
    protected TableView fieldsTable;

    public BaseStreamingDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.meta = (BaseStreamStepMeta)in;
        this.spoonInstance = Spoon.getInstance();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.shell.setMinimumSize(527, 622);
        this.lsMod = e -> this.meta.setChanged();
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getDialogTitle());
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)spacer);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        fdSpacer.width = 497;
        spacer.setLayoutData((Object)fdSpacer);
        this.wlTransPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlTransPath);
        this.wlTransPath.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.Transformation", (String[])new String[0]));
        FormData fdlTransPath = new FormData();
        fdlTransPath.left = new FormAttachment(0, 0);
        fdlTransPath.top = new FormAttachment((Control)spacer, 15);
        fdlTransPath.right = new FormAttachment(50, 0);
        this.wlTransPath.setLayoutData((Object)fdlTransPath);
        this.wFileSection = new VFSFileSelection((Composite)this.shell, 4, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), (AbstractMeta)this.transMeta, this.repository);
        this.props.setLook((Control)this.wFileSection);
        FormData fdFileSelection = new FormData();
        fdFileSelection.left = new FormAttachment(0, 0);
        fdFileSelection.top = new FormAttachment((Control)this.wlTransPath, 5);
        this.wFileSection.setLayoutData(fdFileSelection);
        this.wbCreateSubtrans = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbCreateSubtrans);
        this.wbCreateSubtrans.setText(BaseMessages.getString(PKG, (String)"BaseStreaming.Dialog.Transformation.CreateSubtrans", (String[])new String[0]));
        FormData fdCreateSubtrans = new FormData();
        fdCreateSubtrans.left = new FormAttachment((Control)this.wFileSection, 5);
        fdCreateSubtrans.top = new FormAttachment((Control)this.wFileSection, 0, 128);
        this.wbCreateSubtrans.setLayoutData((Object)fdCreateSubtrans);
        this.wbCreateSubtrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStreamingDialog.this.createNewSubtrans();
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)hSpacer);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 2;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wFileSection, 15);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.buildSetupTab();
        this.buildBatchTab();
        this.buildResultsTab();
        this.createAdditionalTabs();
        this.lsCancel = e -> this.cancel();
        this.lsOK = e -> this.ok();
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BaseStreamingDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseStreamingDialog.this.cancel();
            }
        });
        this.getData();
        this.setSize();
        this.wTabFolder.setSelection(0);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected abstract String getDialogTitle();

    private void buildSetupTab() {
        this.wSetupTab = new CTabItem(this.wTabFolder, 0);
        this.wSetupTab.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.SetupTab", (String[])new String[0]));
        this.wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        this.wSetupComp.setLayout((Layout)setupLayout);
        this.buildSetup(this.wSetupComp);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        this.wSetupComp.setLayoutData((Object)fdSetupComp);
        this.wSetupComp.layout();
        this.wSetupTab.setControl((Control)this.wSetupComp);
    }

    protected abstract void buildSetup(Composite var1);

    protected void createAdditionalTabs() {
    }

    protected void createNewSubtrans() {
        TransMeta newSubTransMeta = this.createSubTransMeta();
        boolean saved = false;
        String path = null;
        if (this.spoonInstance.getRepository() != null) {
            try {
                saved = this.spoonInstance.saveToRepository((EngineMetaInterface)newSubTransMeta);
                path = this.getRepositoryRelativePath(newSubTransMeta.getPathAndName());
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"BaseStreamingDialog.File.Save.Fail.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStreamingDialog.File.Save.Fail.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        } else {
            saved = this.spoonInstance.saveXMLFile((EngineMetaInterface)newSubTransMeta, false);
            if (saved) {
                try {
                    path = this.getRelativePath(KettleVFS.getFileObject((String)newSubTransMeta.getFilename()).toString());
                }
                catch (KettleFileException e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"BaseStreamingDialog.File.Save.Fail.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStreamingDialog.File.Save.Fail.Message", (String[])new String[0]), (Exception)((Object)e));
                }
            }
        }
        if (saved && null != path) {
            this.wFileSection.wFileName.setText(path);
            this.createSubtrans(newSubTransMeta);
            if (this.props.showNewSubtransPopup()) {
                NewSubtransDialog newSubtransDialog = new NewSubtransDialog(this.shell, 0);
                this.props.setShowNewSubtransPopup(!newSubtransDialog.open());
            }
        }
    }

    protected TransMeta createSubTransMeta() {
        RecordsFromStreamMeta rm = new RecordsFromStreamMeta();
        String[] fieldNames = this.getFieldNames();
        int[] empty = new int[fieldNames.length];
        Arrays.fill(empty, -1);
        rm.setFieldname(fieldNames);
        rm.setType(this.getFieldTypes());
        rm.setLength(empty);
        rm.setPrecision(empty);
        StepMeta recsFromStream = new StepMeta("RecordsFromStream", "Get records from stream", (StepMetaInterface)rm);
        recsFromStream.setLocation(new Point(100, 100));
        recsFromStream.setDraw(true);
        TransMeta transMeta = new TransMeta();
        transMeta.addStep(recsFromStream);
        transMeta.setFilename("");
        return transMeta;
    }

    protected TableView getFieldsTable() {
        return this.fieldsTable;
    }

    protected String[] getFieldNames() {
        return (String[])Arrays.stream(this.getFieldsTable().getTable().getItems()).map(row -> row.getText(2)).toArray(String[]::new);
    }

    protected int[] getFieldTypes() {
        return Arrays.stream(this.getFieldsTable().getTable().getItems()).mapToInt(row -> ValueMetaFactory.getIdForValueMeta((String)row.getText(3))).toArray();
    }

    private void createSubtrans(TransMeta newTransMeta) {
        TabItem tabItem = this.spoonInstance.getTabSet().getSelected();
        newTransMeta.setMetaStore((IMetaStore)this.spoonInstance.getMetaStore());
        try {
            SharedObjects sharedObjects = newTransMeta.readSharedObjects();
            newTransMeta.setSharedObjects(sharedObjects);
            newTransMeta.importFromMetaStore();
            newTransMeta.clearChanged();
        }
        catch (Exception e) {
            this.log.logError("Failed to retrieve shared objects", (Throwable)e);
        }
        this.spoonInstance.delegates.tabs.makeTabName((EngineMetaInterface)newTransMeta, false);
        this.spoonInstance.addTransGraph(newTransMeta);
        this.spoonInstance.applyVariables();
        if (this.spoonInstance.setDesignMode()) {
            this.spoonInstance.refreshTree();
        }
        this.spoonInstance.loadPerspective("001-spoon-jobs");
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationCreateNew.id, (Object)newTransMeta);
        }
        catch (KettleException e) {
            this.log.logError("Failed to call extension point", (Throwable)e);
        }
        TabSet ts = this.spoonInstance.getTabSet();
        ts.setSelected(tabItem);
    }

    private void buildBatchTab() {
        this.wBatchTab = new CTabItem(this.wTabFolder, 0);
        this.wBatchTab.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.BatchTab", (String[])new String[0]));
        this.wBatchComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wBatchComp);
        FormLayout batchLayout = new FormLayout();
        batchLayout.marginHeight = 15;
        batchLayout.marginWidth = 15;
        this.wBatchComp.setLayout((Layout)batchLayout);
        FormData fdBatchComp = new FormData();
        fdBatchComp.left = new FormAttachment(0, 0);
        fdBatchComp.top = new FormAttachment(0, 0);
        fdBatchComp.right = new FormAttachment(100, 0);
        fdBatchComp.bottom = new FormAttachment(100, 0);
        this.wBatchComp.setLayoutData((Object)fdBatchComp);
        this.wlBatchDuration = new Label(this.wBatchComp, 16384);
        this.props.setLook((Control)this.wlBatchDuration);
        this.wlBatchDuration.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.BatchDuration", (String[])new String[0]));
        FormData fdlBatchDuration = new FormData();
        fdlBatchDuration.left = new FormAttachment(0, 0);
        fdlBatchDuration.top = new FormAttachment(0, 0);
        fdlBatchDuration.right = new FormAttachment(50, 0);
        this.wlBatchDuration.setLayoutData((Object)fdlBatchDuration);
        this.wBatchDuration = new TextVar((VariableSpace)this.transMeta, this.wBatchComp, 18436);
        this.props.setLook((Control)this.wBatchDuration);
        this.wBatchDuration.addModifyListener(this.lsMod);
        FormData fdBatchDuration = new FormData();
        fdBatchDuration.left = new FormAttachment(0, 0);
        fdBatchDuration.top = new FormAttachment((Control)this.wlBatchDuration, 5);
        fdBatchDuration.width = 75;
        this.wBatchDuration.setLayoutData(fdBatchDuration);
        this.wlBatchSize = new Label(this.wBatchComp, 16384);
        this.props.setLook((Control)this.wlBatchSize);
        this.wlBatchSize.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.BatchSize", (String[])new String[0]));
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wBatchDuration, 10);
        fdlBatchSize.right = new FormAttachment(50, 0);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar((VariableSpace)this.transMeta, this.wBatchComp, 18436);
        this.props.setLook((Control)this.wBatchSize);
        this.wBatchSize.addModifyListener(this.lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(0, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wlBatchSize, 5);
        fdBatchSize.width = 75;
        this.wBatchSize.setLayoutData(fdBatchSize);
        Label wlParallelism = new Label(this.wBatchComp, 16384);
        this.props.setLook((Control)wlParallelism);
        wlParallelism.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.Parallelism", (String[])new String[0]));
        wlParallelism.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wBatchSize, 10).right(50, 0).result());
        this.wParallelism = new TextVar((VariableSpace)this.transMeta, this.wBatchComp, 18436);
        this.props.setLook((Control)this.wParallelism);
        this.wParallelism.addModifyListener(this.lsMod);
        this.wParallelism.setLayoutData(new FormDataBuilder().left().top((Control)wlParallelism, 5).width(75).result());
        this.wBatchComp.layout();
        this.wBatchTab.setControl((Control)this.wBatchComp);
    }

    private void buildResultsTab() {
        this.wResultsTab = new CTabItem(this.wTabFolder, 0);
        this.wResultsTab.setText(BaseMessages.getString(PKG, (String)"BaseStreamingDialog.ResultsTab", (String[])new String[0]));
        this.wResultsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wResultsComp);
        FormLayout resultsLayout = new FormLayout();
        resultsLayout.marginHeight = 15;
        resultsLayout.marginWidth = 15;
        this.wResultsComp.setLayout((Layout)resultsLayout);
        FormData fdResultsComp = new FormData();
        fdResultsComp.left = new FormAttachment(0, 0);
        fdResultsComp.top = new FormAttachment(0, 0);
        fdResultsComp.right = new FormAttachment(100, 0);
        fdResultsComp.bottom = new FormAttachment(100, 0);
        this.wResultsComp.setLayoutData((Object)fdResultsComp);
        this.wlSubStep = new Label(this.wResultsComp, 16384);
        this.props.setLook((Control)this.wlSubStep);
        FormData fdlSubTrans = new FormData();
        fdlSubTrans.left = new FormAttachment(0, 0);
        fdlSubTrans.top = new FormAttachment(0, 0);
        this.wlSubStep.setLayoutData((Object)fdlSubTrans);
        this.wlSubStep.setText(BaseMessages.getString(PKG, (String)"BaseStreaming.Dialog.Transformation.SubTransStep", (String[])new String[0]));
        this.wSubStep = new ComboVar((VariableSpace)this.transMeta, this.wResultsComp, 18436);
        this.props.setLook((Control)this.wSubStep);
        FormData fdSubStep = new FormData();
        fdSubStep.left = new FormAttachment(0, 0);
        fdSubStep.top = new FormAttachment((Control)this.wlSubStep, 5);
        fdSubStep.width = 250;
        this.wSubStep.setLayoutData(fdSubStep);
        this.wSubStep.getCComboWidget().addListener(15, this::populateSubSteps);
        this.wResultsComp.layout();
        this.wResultsTab.setControl((Control)this.wResultsComp);
    }

    protected void getData() {
        if (this.meta.getTransformationPath() != null) {
            this.wFileSection.wFileName.setText(this.meta.getTransformationPath());
        }
        if (this.meta.getBatchSize() != null) {
            this.wBatchSize.setText(this.meta.getBatchSize());
        }
        if (this.meta.getBatchDuration() != null) {
            this.wBatchDuration.setText(this.meta.getBatchDuration());
        }
        if (this.meta.getParallelism() != null) {
            this.wParallelism.setText(this.meta.getParallelism());
        }
        if (this.meta.getSubStep() != null) {
            this.wSubStep.setText(this.meta.getSubStep());
        }
        this.specificationMethod = this.meta.getSpecificationMethod();
    }

    protected void populateSubSteps(Event event) {
        try {
            String current = this.wSubStep.getText();
            this.wSubStep.removeAll();
            Optional.ofNullable(this.getMappingMeta()).ifPresent(transMeta -> transMeta.getSteps().stream().map(StepMeta::getName).sorted().forEach(this.wSubStep::add));
            Display.getDefault().asyncExec(() -> this.wSubStep.setText(current));
        }
        catch (KettleException e) {
            this.logDebug(e.getMessage(), new Object[]{e});
        }
    }

    private TransMeta getMappingMeta() throws KettleException {
        BaseStreamStepMeta baseMeta = (BaseStreamStepMeta)this.meta.clone();
        this.updateMeta(baseMeta);
        return StepWithMappingMeta.loadMappingMeta((StepWithMappingMeta)baseMeta, (Repository)this.getRepository(), (IMetaStore)this.getMetaStore(), (VariableSpace)this.transMeta);
    }

    private Image getImage() {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
        String id = plugin.getIds()[0];
        if (id != null) {
            return GUIResource.getInstance().getImagesSteps().get(id).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48);
        }
        return null;
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.updateMeta(this.meta);
        this.dispose();
    }

    private void updateMeta(BaseStreamStepMeta streamMeta) {
        streamMeta.setTransformationPath(this.wFileSection.wFileName.getText());
        streamMeta.setBatchSize(this.wBatchSize.getText());
        streamMeta.setBatchDuration(this.wBatchDuration.getText());
        streamMeta.setParallelism(this.wParallelism.getText());
        streamMeta.setSpecificationMethod(this.specificationMethod);
        streamMeta.setSubStep(this.wSubStep.getText());
        switch (this.specificationMethod) {
            case FILENAME: {
                streamMeta.setFileName(this.wFileSection.wFileName.getText());
                streamMeta.setDirectoryPath(null);
                streamMeta.setTransName(null);
                streamMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wFileSection.wFileName.getText();
                String directory = "";
                int index = transPath.lastIndexOf(47);
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = transPath.substring(0, index);
                }
                streamMeta.setDirectoryPath(directory);
                streamMeta.setTransName(transName);
                streamMeta.setFileName(null);
                streamMeta.setTransObjectId(null);
                break;
            }
        }
        this.additionalOks(streamMeta);
    }

    protected void additionalOks(BaseStreamStepMeta meta) {
    }

    protected String getRepositoryRelativePath(String path) {
        String parentPath = this.transMeta.getRepositoryDirectory().getPath();
        if (path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Directory}");
        }
        return path;
    }

    protected String getRelativePath(String filePath) {
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (filePath != null && parentFolder != null && filePath.startsWith(parentFolder)) {
            filePath = filePath.replace(parentFolder, "${Internal.Entry.Current.Directory}");
        }
        return filePath;
    }
}

