/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.ui.core.dialog.BaseMessageDialog;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.common.FieldSelectionDialog;
import org.pentaho.di.ui.trans.step.common.GetFieldsSampleDataDialog;

public interface GetFieldsCapableStepDialog<StepMetaType extends BaseStepMeta> {
    public static final Class<?> PKG = GetFieldsCapableStepDialog.class;
    public static final LogChannel logger = new LogChannel(GetFieldsCapableStepDialog.class);

    public Shell getParent();

    public Shell getShell();

    public String[] getFieldNames(StepMetaType var1);

    public TableView getFieldsTable();

    default public TableItem findTableItem(String fieldName) {
        for (int i = 0; i < this.getFieldsTable().getTable().getItemCount(); ++i) {
            int fieldNameIndex;
            TableItem item = this.getFieldsTable().getTable().getItem(i);
            String itemFieldName = item.getText(fieldNameIndex = this.getFieldsTable().hasIndexColumn() ? 1 : 0);
            if (itemFieldName == null || !itemFieldName.equals(fieldName)) continue;
            return item;
        }
        return null;
    }

    default public List<String> getNewFieldNames(String[] incomingFieldNames) {
        HashSet<String> fieldNamesInTable = new HashSet<String>();
        for (int i = 0; i < this.getFieldsTable().getTable().getItemCount(); ++i) {
            TableItem item = this.getFieldsTable().getTable().getItem(i);
            int fieldNameIndex = this.getFieldsTable().hasIndexColumn() ? 1 : 0;
            fieldNamesInTable.add(item.getText(fieldNameIndex));
        }
        return Arrays.stream(incomingFieldNames).filter(fieldName -> !fieldNamesInTable.contains(fieldName)).collect(Collectors.toList());
    }

    default public void getFields() {
        this.getFields(this.getPopulatedMeta());
    }

    default public void getFields(StepMetaType meta) {
        String[] incomingFieldNames = this.getFieldNames(meta);
        List<String> newFieldNames = this.getNewFieldNames(incomingFieldNames);
        if (newFieldNames != null && newFieldNames.size() > 0) {
            int nrNonEmptyFields = this.getFieldsTable().nrNonEmpty();
            if (nrNonEmptyFields > 0) {
                FieldSelectionDialog fieldSelectDialog = new FieldSelectionDialog(this.getShell(), newFieldNames.size()){

                    @Override
                    protected void ok() {
                        super.ok();
                        GetFieldsCapableStepDialog.this.openGetFieldsSampleDataDialog(this.reloadAllFields);
                    }
                };
                fieldSelectDialog.open();
            } else {
                this.openGetFieldsSampleDataDialog(true);
            }
        } else {
            BaseMessageDialog errorDlg = new BaseMessageDialog(this.getShell(), BaseMessages.getString(PKG, (String)"System.GetFields.NoNewFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.GetFields.NoNewFields.Message", (String[])new String[0]));
            if (incomingFieldNames != null && incomingFieldNames.length > 0) {
                HashMap<String, Listener> buttons = new HashMap<String, Listener>();
                buttons.put(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]), event -> {
                    errorDlg.dispose();
                    this.openGetFieldsSampleDataDialog(true);
                });
                errorDlg.setButtons(buttons);
            }
            errorDlg.open();
        }
    }

    default public void openGetFieldsSampleDataDialog(boolean reloadAllFields) {
        GetFieldsSampleDataDialog dlg = new GetFieldsSampleDataDialog(this.getShell(), this, reloadAllFields);
        dlg.open();
    }

    public String loadFieldsImpl(StepMetaType var1, int var2);

    default public Map<String, List<String>> getFieldValues() {
        this.getFieldsTable().nrNonEmpty();
        HashMap<String, List<String>> rowValues = new HashMap<String, List<String>>();
        for (int i = 0; i < this.getFieldsTable().getTable().getItemCount(); ++i) {
            int startIndex;
            TableItem item = this.getFieldsTable().getTable().getItem(i);
            String fieldName = item.getText(startIndex = this.getFieldsTable().hasIndexColumn() ? 1 : 0);
            if (StringUtils.isBlank((String)fieldName)) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (int j = startIndex; j < this.getFieldsTable().getColumns().length; ++j) {
                values.add(item.getText(j));
            }
            rowValues.put(fieldName, values);
        }
        return rowValues;
    }

    default public Set<String> repopulateFields(StepMetaType meta, Map<String, List<String>> previousFieldValues, boolean reloadAllFields) {
        String[] incomingFieldNames = this.getFieldNames(meta);
        HashSet<String> newFieldNames = new HashSet<String>();
        for (String incomingFieldName : incomingFieldNames) {
            TableItem item = new TableItem(this.getFieldsTable().getTable(), 0);
            int columnIndexOffset = this.getFieldsTable().hasIndexColumn() ? 1 : 0;
            item.setText(columnIndexOffset, incomingFieldName);
            if (previousFieldValues.containsKey(incomingFieldName)) {
                List<String> values = previousFieldValues.remove(incomingFieldName);
                int columnIndex = 0;
                if (reloadAllFields || values == null) continue;
                for (String value : values) {
                    item.setText(columnIndex++ + columnIndexOffset, value);
                }
                continue;
            }
            newFieldNames.add(incomingFieldName);
        }
        if (!reloadAllFields) {
            this.loadRemainingFields(previousFieldValues);
        }
        return newFieldNames;
    }

    default public void loadRemainingFields(Map<String, List<String>> previousFieldValues) {
        for (List<String> values : previousFieldValues.values()) {
            if (values == null) continue;
            TableItem item = new TableItem(this.getFieldsTable().getTable(), 0);
            int columnIndexOffset = this.getFieldsTable().hasIndexColumn() ? 1 : 0;
            int columnIndex = 0;
            for (String value : values) {
                item.setText(columnIndex++ + columnIndexOffset, value);
            }
        }
    }

    default public String loadFields(StepMetaType meta, int samples, boolean reloadAllFields) {
        Map<String, List<String>> fieldValues = this.getFieldValues();
        this.getFieldsTable().removeAll();
        this.getFieldsTable().removeEmptyRows();
        this.getFieldsTable().setRowNums();
        this.getFieldsTable().optWidth(true);
        Set<String> newFieldNames = this.repopulateFields(meta, fieldValues, reloadAllFields);
        this.populateMeta(meta);
        String message = this.loadFieldsImpl(meta, samples);
        if (message != null) {
            if (reloadAllFields) {
                this.getFieldsTable().removeAll();
            }
            this.getData(meta, false, reloadAllFields, newFieldNames);
            this.getFieldsTable().removeEmptyRows();
            this.getFieldsTable().setRowNums();
            this.getFieldsTable().optWidth(true);
        }
        return message;
    }

    default public TableItem getTableItem(String fieldName) {
        return this.getTableItem(fieldName, false);
    }

    default public TableItem getTableItem(String fieldName, boolean reloadAllFields) {
        if (reloadAllFields) {
            return new TableItem(this.getFieldsTable().getTable(), 0);
        }
        TableItem item = this.findTableItem(fieldName);
        if (item == null) {
            item = new TableItem(this.getFieldsTable().getTable(), 0);
        }
        return item;
    }

    public void getData(StepMetaType var1, boolean var2, boolean var3, Set<String> var4);

    default public StepMetaType getPopulatedMeta() {
        StepMetaType newMeta = this.getNewMetaInstance();
        this.populateMeta(newMeta);
        return newMeta;
    }

    public void populateMeta(StepMetaType var1);

    public StepMetaType getNewMetaInstance();

    public TransMeta getTransMeta();
}

