/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.tableinput;

import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class TableInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = TableInputMeta.class;
    private CCombo wConnection;
    private Label wlSQL;
    private StyledTextComp wSQL;
    private FormData fdlSQL;
    private FormData fdSQL;
    private Label wlDatefrom;
    private CCombo wDatefrom;
    private FormData fdlDatefrom;
    private FormData fdDatefrom;
    private Listener lsDatefrom;
    private Label wlLimit;
    private TextVar wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlEachRow;
    private Button wEachRow;
    private FormData fdlEachRow;
    private FormData fdEachRow;
    private Label wlVariables;
    private Button wVariables;
    private FormData fdlVariables;
    private FormData fdVariables;
    private Label wlLazyConversion;
    private Button wLazyConversion;
    private FormData fdlLazyConversion;
    private FormData fdLazyConversion;
    private Label wlCachedRowMeta;
    private Button wCachedRowMeta;
    private FormData fdlCachedRowMeta;
    private FormData fdCachedRowMeta;
    private Button wbTable;
    private FormData fdbTable;
    private Listener lsbTable;
    private TableInputMeta input;
    private boolean changedInDialog;
    private Label wlPosition;
    private FormData fdlPosition;

    public TableInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (TableInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableInputDialog.this.changedInDialog = false;
                TableInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.TableInput", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, null);
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.LimitSize", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.fdlLimit.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.fdLimit.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wLimit.setLayoutData(this.fdLimit);
        this.wlEachRow = new Label((Composite)this.shell, 131072);
        this.wlEachRow.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.ExecuteForEachRow", (String[])new String[0]));
        this.props.setLook((Control)this.wlEachRow);
        this.fdlEachRow = new FormData();
        this.fdlEachRow.left = new FormAttachment(0, 0);
        this.fdlEachRow.right = new FormAttachment(middle, -margin);
        this.fdlEachRow.bottom = new FormAttachment((Control)this.wLimit, -margin);
        this.wlEachRow.setLayoutData((Object)this.fdlEachRow);
        this.wEachRow = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wEachRow);
        this.fdEachRow = new FormData();
        this.fdEachRow.left = new FormAttachment(middle, 0);
        this.fdEachRow.right = new FormAttachment(100, 0);
        this.fdEachRow.bottom = new FormAttachment((Control)this.wLimit, -margin);
        this.wEachRow.setLayoutData((Object)this.fdEachRow);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableInputDialog.this.input.setChanged();
            }
        };
        this.wEachRow.addSelectionListener((SelectionListener)lsSelMod);
        this.wlDatefrom = new Label((Composite)this.shell, 131072);
        this.wlDatefrom.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.InsertDataFromStep", (String[])new String[0]));
        this.props.setLook((Control)this.wlDatefrom);
        this.fdlDatefrom = new FormData();
        this.fdlDatefrom.left = new FormAttachment(0, 0);
        this.fdlDatefrom.right = new FormAttachment(middle, -margin);
        this.fdlDatefrom.bottom = new FormAttachment((Control)this.wEachRow, -margin);
        this.wlDatefrom.setLayoutData((Object)this.fdlDatefrom);
        this.wDatefrom = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wDatefrom);
        List previousSteps = this.transMeta.findPreviousSteps(this.transMeta.findStep(this.stepname));
        for (StepMeta stepMeta : previousSteps) {
            this.wDatefrom.add(stepMeta.getName());
        }
        this.wDatefrom.addModifyListener(lsMod);
        this.fdDatefrom = new FormData();
        this.fdDatefrom.left = new FormAttachment(middle, 0);
        this.fdDatefrom.right = new FormAttachment(100, 0);
        this.fdDatefrom.bottom = new FormAttachment((Control)this.wEachRow, -margin);
        this.wDatefrom.setLayoutData((Object)this.fdDatefrom);
        this.wlVariables = new Label((Composite)this.shell, 131072);
        this.wlVariables.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.ReplaceVariables", (String[])new String[0]));
        this.props.setLook((Control)this.wlVariables);
        this.fdlVariables = new FormData();
        this.fdlVariables.left = new FormAttachment(0, 0);
        this.fdlVariables.right = new FormAttachment(middle, -margin);
        this.fdlVariables.bottom = new FormAttachment((Control)this.wDatefrom, -margin);
        this.wlVariables.setLayoutData((Object)this.fdlVariables);
        this.wVariables = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wVariables);
        this.fdVariables = new FormData();
        this.fdVariables.left = new FormAttachment(middle, 0);
        this.fdVariables.right = new FormAttachment(100, 0);
        this.fdVariables.bottom = new FormAttachment((Control)this.wDatefrom, -margin);
        this.wVariables.setLayoutData((Object)this.fdVariables);
        this.wVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableInputDialog.this.input.setChanged();
                TableInputDialog.this.setSQLToolTip();
            }
        });
        this.wlLazyConversion = new Label((Composite)this.shell, 131072);
        this.wlLazyConversion.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.LazyConversion", (String[])new String[0]));
        this.props.setLook((Control)this.wlLazyConversion);
        this.fdlLazyConversion = new FormData();
        this.fdlLazyConversion.left = new FormAttachment(0, 0);
        this.fdlLazyConversion.right = new FormAttachment(middle, -margin);
        this.fdlLazyConversion.bottom = new FormAttachment((Control)this.wVariables, -margin);
        this.wlLazyConversion.setLayoutData((Object)this.fdlLazyConversion);
        this.wLazyConversion = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wLazyConversion);
        this.fdLazyConversion = new FormData();
        this.fdLazyConversion.left = new FormAttachment(middle, 0);
        this.fdLazyConversion.right = new FormAttachment(100, 0);
        this.fdLazyConversion.bottom = new FormAttachment((Control)this.wVariables, -margin);
        this.wLazyConversion.setLayoutData((Object)this.fdLazyConversion);
        this.wLazyConversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableInputDialog.this.input.setChanged();
                TableInputDialog.this.setSQLToolTip();
            }
        });
        this.wlCachedRowMeta = new Label((Composite)this.shell, 131072);
        this.wlCachedRowMeta.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.CacheRowMeta", (String[])new String[0]));
        this.props.setLook((Control)this.wlCachedRowMeta);
        this.fdlCachedRowMeta = new FormData();
        this.fdlCachedRowMeta.left = new FormAttachment(0, 0);
        this.fdlCachedRowMeta.right = new FormAttachment(middle, -margin);
        this.fdlCachedRowMeta.bottom = new FormAttachment((Control)this.wLazyConversion, -margin);
        this.wlCachedRowMeta.setLayoutData((Object)this.fdlCachedRowMeta);
        this.wCachedRowMeta = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wCachedRowMeta);
        this.fdCachedRowMeta = new FormData();
        this.fdCachedRowMeta.left = new FormAttachment(middle, 0);
        this.fdCachedRowMeta.right = new FormAttachment(100, 0);
        this.fdCachedRowMeta.bottom = new FormAttachment((Control)this.wLazyConversion, -margin);
        this.wCachedRowMeta.setLayoutData((Object)this.fdCachedRowMeta);
        this.wCachedRowMeta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableInputDialog.this.input.setChanged();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.fdlPosition.bottom = new FormAttachment((Control)this.wCachedRowMeta, -margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wlSQL = new Label((Composite)this.shell, 0);
        this.wlSQL.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.SQL", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQL);
        this.fdlSQL = new FormData();
        this.fdlSQL.left = new FormAttachment(0, 0);
        this.fdlSQL.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSQL.setLayoutData((Object)this.fdlSQL);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.GetSQLAndSelectStatement", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wSQL = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wSQL, 1);
        this.wSQL.addModifyListener(lsMod);
        this.fdSQL = new FormData();
        this.fdSQL.left = new FormAttachment(0, 0);
        this.fdSQL.top = new FormAttachment((Control)this.wbTable, margin);
        this.fdSQL.right = new FormAttachment(100, -2 * margin);
        this.fdSQL.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSQL.setLayoutData(this.fdSQL);
        this.wSQL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TableInputDialog.this.setSQLToolTip();
                TableInputDialog.this.setPosition();
            }
        });
        this.wSQL.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                TableInputDialog.this.setPosition();
            }
        });
        this.wSQL.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                TableInputDialog.this.setPosition();
            }
        });
        this.wSQL.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                TableInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                TableInputDialog.this.setPosition();
            }
        });
        this.wSQL.addLineStyleListener(new SQLValuesHighlight());
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TableInputDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                TableInputDialog.this.preview();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TableInputDialog.this.ok();
            }
        };
        this.lsbTable = new Listener(){

            public void handleEvent(Event e) {
                TableInputDialog.this.getSQL();
            }
        };
        this.lsDatefrom = new Listener(){

            public void handleEvent(Event e) {
                TableInputDialog.this.setFlags();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wOK.addListener(13, this.lsOK);
        this.wbTable.addListener(13, this.lsbTable);
        this.wDatefrom.addListener(13, this.lsDatefrom);
        this.wDatefrom.addListener(16, this.lsDatefrom);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TableInputDialog.this.checkCancel(e);
            }
        });
        this.getData();
        this.changedInDialog = false;
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setPosition() {
        String scr = this.wSQL.getText();
        int linenr = this.wSQL.getLineAtOffset(this.wSQL.getCaretOffset()) + 1;
        int posnr = this.wSQL.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    protected void setSQLToolTip() {
        if (this.wVariables.getSelection()) {
            this.wSQL.setToolTipText(this.transMeta.environmentSubstitute(this.wSQL.getText()));
        }
    }

    public void getData() {
        if (this.input.getSQL() != null) {
            this.wSQL.setText(this.input.getSQL());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        this.wLimit.setText(Const.NVL((String)this.input.getRowLimit(), (String)""));
        StreamInterface infoStream = (StreamInterface)this.input.getStepIOMeta().getInfoStreams().get(0);
        if (infoStream.getStepMeta() != null) {
            this.wDatefrom.setText(infoStream.getStepname());
            this.wEachRow.setSelection(this.input.isExecuteEachInputRow());
        } else {
            this.wEachRow.setEnabled(false);
            this.wlEachRow.setEnabled(false);
        }
        this.wVariables.setSelection(this.input.isVariableReplacementActive());
        this.wLazyConversion.setSelection(this.input.isLazyConversionActive());
        this.wCachedRowMeta.setSelection(this.input.isCachedRowMetaActive());
        this.setSQLToolTip();
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void checkCancel(ShellEvent e) {
        if (this.changedInDialog) {
            int save = JobGraph.showChangedWarning(this.shell, this.wStepname.getText());
            if (save == 256) {
                e.doit = false;
            } else if (save == 64) {
                this.ok();
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(TableInputMeta meta, boolean preview) {
        meta.setSQL(preview && !Utils.isEmpty((CharSequence)this.wSQL.getSelectionText()) ? this.wSQL.getSelectionText() : this.wSQL.getText());
        meta.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        meta.setRowLimit(this.wLimit.getText());
        StreamInterface infoStream = (StreamInterface)this.input.getStepIOMeta().getInfoStreams().get(0);
        infoStream.setStepMeta(this.transMeta.findStep(this.wDatefrom.getText()));
        meta.setExecuteEachInputRow(this.wEachRow.getSelection());
        meta.setVariableReplacementActive(this.wVariables.getSelection());
        meta.setLazyConversionActive(this.wLazyConversion.getSelection());
        meta.setCachedRowMetaActive(this.wCachedRowMeta.getSelection());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input, false);
        this.input.updateCachedRowMeta();
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.SelectValidConnection", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSQL() {
        DatabaseMeta inf = this.transMeta.findDatabase(this.wConnection.getText());
        if (inf != null) {
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            if (!std.open()) return;
            String sql = "SELECT *" + Const.CR + "FROM " + inf.getQuotedSchemaTableCombination(std.getSchemaName(), std.getTableName()) + Const.CR;
            this.wSQL.setText(sql);
            MessageBox yn = new MessageBox(this.shell, 452);
            yn.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.IncludeFieldNamesInSQL", (String[])new String[0]));
            yn.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionQuestion", (String[])new String[0]));
            int id = yn.open();
            switch (id) {
                case 256: {
                    return;
                }
                case 128: {
                    this.wSQL.setText(sql);
                    return;
                }
                case 64: {
                    Database db = new Database(loggingObject, inf);
                    db.shareVariablesWith((VariableSpace)this.transMeta);
                    try {
                        db.connect();
                        RowMetaInterface fields = db.getQueryFields(sql, false);
                        if (fields != null) {
                            sql = "SELECT" + Const.CR;
                            for (int i = 0; i < fields.size(); ++i) {
                                ValueMetaInterface field = fields.getValueMeta(i);
                                sql = i == 0 ? sql + "  " : sql + ", ";
                                sql = sql + inf.quoteField(field.getName()) + Const.CR;
                            }
                            sql = sql + "FROM " + inf.getQuotedSchemaTableCombination(std.getSchemaName(), std.getTableName()) + Const.CR;
                            this.wSQL.setText(sql);
                            return;
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.ERROR_CouldNotRetrieveFields", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"TableInputDialog.PerhapsNoPermissions", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError2", (String[])new String[0]));
                            mb.open();
                        }
                        return;
                    }
                    catch (KettleException e) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError3", (String[])new String[0]));
                        mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.AnErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                        mb.open();
                        return;
                    }
                    finally {
                        db.disconnect();
                    }
                }
            }
            return;
        }
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setMessage(BaseMessages.getString(PKG, (String)"TableInputDialog.ConnectionNoLongerAvailable", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"TableInputDialog.DialogCaptionError4", (String[])new String[0]));
        mb.open();
    }

    private void setFlags() {
        if (!Utils.isEmpty((CharSequence)this.wDatefrom.getText())) {
            this.wEachRow.setEnabled(true);
            this.wlEachRow.setEnabled(true);
            this.wPreview.setEnabled(false);
        } else {
            this.wEachRow.setEnabled(false);
            this.wEachRow.setSelection(false);
            this.wlEachRow.setEnabled(false);
            this.wPreview.setEnabled(true);
        }
    }

    private void preview() {
        TableInputMeta oneMeta = new TableInputMeta();
        this.getInfo(oneMeta, true);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"TableInputDialog.EnterPreviewSize", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableInputDialog.NumberOfRowsToPreview", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled()) {
                if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                } else {
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                    prd.open();
                }
            }
        }
    }
}

