/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.xul;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.xul.KettleImageUtil;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class KettleDialog
extends SwtDialog {
    private final Map<String, Image[]> imagesCache = new HashMap<String, Image[]>();

    public KettleDialog(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(self, parent, container, tagName);
    }

    protected Shell getParentShell(XulComponent parent) {
        if (parent == null && Spoon.getInstance() != null) {
            return Spoon.getInstance().getShell();
        }
        return super.getParentShell(parent);
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean force) {
        if (force || !this.buttonsCreated) {
            this.setButtons();
        }
        this.isDialogHidden = false;
        this.dialog.getShell().setText(this.title);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            BaseStepDialog.setSize(this.getShell(), this.getWidth(), this.getHeight(), true);
        } else {
            BaseStepDialog.setSize(this.getShell());
        }
        this.width = this.getShell().getSize().x;
        this.height = this.getShell().getSize().y;
        this.dialog.getShell().layout(true, true);
        this.notifyListeners(555);
        this.setAppicon(this.appIcon);
        this.returnCode = this.dialog.open();
    }

    public void hide() {
        if (this.closing || this.dialog.getMainArea().isDisposed() || this.getParentShell(this.getParent()).isDisposed() || this.getParent() instanceof SwtDialog && ((SwtDialog)this.getParent()).isDisposing()) {
            return;
        }
        WindowProperty windowProperty = new WindowProperty(this.getShell());
        PropsUI.getInstance().setScreen(windowProperty);
        super.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppicon(String icon) {
        Image[] images;
        this.appIcon = icon;
        if (this.appIcon == null || this.dialog == null) {
            return;
        }
        Map<String, Image[]> map = this.imagesCache;
        synchronized (map) {
            images = this.imagesCache.get(icon);
        }
        if (images == null) {
            images = KettleImageUtil.loadImages(this.domContainer, this.dialog.getShell(), icon);
            map = this.imagesCache;
            synchronized (map) {
                this.imagesCache.put(icon, images);
            }
        }
        if (images == null) {
            super.setAppicon(icon);
        } else if (images != null && this.dialog != null) {
            this.dialog.getShell().setImages(images);
        }
    }
}

