/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.IdentifierVisitor;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;

public final class IdBatchResolver {
    static final Logger LOGGER = Logger.getLogger(IdBatchResolver.class);
    private final Query query;
    private final Formula[] formulas;
    private final QueryAxis[] axes;
    private final Cube cube;
    private final Collection<String> dimensionUniqueNames = new ArrayList<String>();
    private final Collection<String> hierarchyUniqueNames = new ArrayList<String>();
    private final Collection<String> levelNames = new ArrayList<String>();
    private SortedSet<Id> identifiers = new TreeSet<Id>(new IdComparator());

    public IdBatchResolver(Query query) {
        this.query = query;
        this.formulas = query.getFormulas();
        this.axes = query.getAxes();
        this.cube = query.getCube();
        this.initOlapElementNames();
        this.initIdentifiers();
    }

    private void initOlapElementNames() {
        this.dimensionUniqueNames.addAll(this.getOlapElementNames(this.cube.getDimensions(), true));
        for (Dimension dim : this.cube.getDimensions()) {
            this.hierarchyUniqueNames.addAll(this.getOlapElementNames(dim.getHierarchies(), true));
            for (Hierarchy hier : dim.getHierarchies()) {
                this.levelNames.addAll(this.getOlapElementNames(hier.getLevels(), false));
            }
        }
    }

    private void initIdentifiers() {
        IdentifierVisitor identifierVisitor = new IdentifierVisitor(this.identifiers);
        for (QueryAxis queryAxis : this.axes) {
            queryAxis.accept(identifierVisitor);
        }
        if (this.query.getSlicerAxis() != null) {
            this.query.getSlicerAxis().accept(identifierVisitor);
        }
        for (QueryPart queryPart : this.formulas) {
            ((Formula)queryPart).accept(identifierVisitor);
        }
        this.expandIdentifiers(this.identifiers);
    }

    public Map<QueryPart, QueryPart> resolve() {
        return this.resolveInParentGroupings(this.identifiers);
    }

    private Map<QueryPart, QueryPart> resolveInParentGroupings(SortedSet<Id> identifiers) {
        HashMap<QueryPart, QueryPart> resolvedIdentifiers = new HashMap<QueryPart, QueryPart>();
        while (identifiers.size() > 0) {
            Member parentMember;
            Id parent = identifiers.first();
            identifiers.remove(parent);
            if (!this.supportedIdentifier(parent)) continue;
            Exp exp = (Exp)resolvedIdentifiers.get(parent);
            if (exp == null) {
                exp = this.lookupExp(parent);
            }
            if (!this.supportedMember(parentMember = this.getMemberFromExp(exp))) continue;
            resolvedIdentifiers.put(parent, (QueryPart)((Object)exp));
            this.batchResolveChildren(parent, parentMember, identifiers, resolvedIdentifiers);
        }
        return resolvedIdentifiers;
    }

    private void batchResolveChildren(Id parent, Member parentMember, SortedSet<Id> identifiers, Map<QueryPart, QueryPart> resolvedIdentifiers) {
        List<Id> children = this.findChildIds(parent, identifiers);
        List<Id.NameSegment> childNameSegments = this.collectChildrenNameSegments(parentMember, children);
        if (childNameSegments.size() > 0) {
            List<Member> childMembers = this.lookupChildrenByNames(parentMember, childNameSegments);
            this.addChildrenToResolvedMap(resolvedIdentifiers, children, childMembers);
        }
    }

    private Exp lookupExp(Id parent) {
        try {
            Exp exp = Util.lookup(this.query, parent.getSegments(), false);
            return exp;
        }
        catch (Exception exception) {
            LOGGER.info((Object)String.format("Failed to resolve '%s' during batch ID resolution.", parent));
            return null;
        }
    }

    private void addChildrenToResolvedMap(Map<QueryPart, QueryPart> resolvedIdentifiers, List<Id> children, List<Member> childMembers) {
        for (Member child : childMembers) {
            for (Id childId : children) {
                if (resolvedIdentifiers.containsKey(childId) || !this.getLastSegment(childId).matches(child.getName())) continue;
                resolvedIdentifiers.put(childId, (QueryPart)((Object)Util.createExpr(child)));
            }
        }
    }

    private List<Member> lookupChildrenByNames(Member parentMember, List<Id.NameSegment> childNameSegments) {
        try {
            return this.query.getSchemaReader(true).lookupMemberChildrenByNames(parentMember, childNameSegments, MatchType.EXACT);
        }
        catch (Exception e) {
            LOGGER.info((Object)String.format("Failure while looking up children of '%s' during  batch member resolution.  Child member refs:  %s", parentMember, Arrays.toString(childNameSegments.toArray())), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Id.NameSegment> collectChildrenNameSegments(final Member parentMember, List<Id> children) {
        CollectionUtils.filter(children, (Predicate)new Predicate(){

            public boolean evaluate(Object theId) {
                Id id = (Id)theId;
                return !Util.matches(parentMember, id.getSegments()) && IdBatchResolver.this.supportedIdentifier(id);
            }
        });
        return new ArrayList<Id.NameSegment>(CollectionUtils.collect(children, (Transformer)new Transformer(){

            public Object transform(Object theId) {
                Id id = (Id)theId;
                return IdBatchResolver.this.getLastSegment(id);
            }
        }));
    }

    private Id.Segment getLastSegment(Id id) {
        int segSize = id.getSegments().size();
        return id.getSegments().get(segSize - 1);
    }

    private boolean supportedIdentifier(Id id) {
        Id.Segment seg = this.getLastSegment(id);
        if (!(seg instanceof Id.NameSegment)) {
            return false;
        }
        return this.isPossibleMemberRef(id) && !this.segmentIsCalcMember(id.getSegments()) && !id.getSegments().get(0).matches("Measures");
    }

    private boolean supportedMember(Member member) {
        return member != null && !member.equals(member.getHierarchy().getNullMember()) && !member.isMeasure();
    }

    private Member getMemberFromExp(Exp exp) {
        if (exp instanceof DimensionExpr) {
            Hierarchy hier = ((DimensionExpr)exp).getDimension().getHierarchy();
            if (hier.hasAll()) {
                return hier.getAllMember();
            }
        } else if (exp instanceof HierarchyExpr) {
            Hierarchy hier = ((HierarchyExpr)exp).getHierarchy();
            if (hier.hasAll()) {
                return hier.getAllMember();
            }
        } else if (exp instanceof MemberExpr) {
            return ((MemberExpr)exp).getMember();
        }
        return null;
    }

    private Collection<String> getOlapElementNames(OlapElement[] olapElements, final boolean uniqueName) {
        return CollectionUtils.collect(Arrays.asList(olapElements), (Transformer)new Transformer(){

            public Object transform(Object o) {
                return uniqueName ? ((OlapElement)o).getUniqueName() : ((OlapElement)o).getName();
            }
        });
    }

    private boolean isPossibleMemberRef(Id id) {
        int size = id.getSegments().size();
        if (size == 1) {
            return this.segListMatchInUniqueNames(id.getSegments(), this.dimensionUniqueNames) || this.segListMatchInUniqueNames(id.getSegments(), this.hierarchyUniqueNames);
        }
        if (MondrianProperties.instance().SsasCompatibleNaming.get() && size == 2) {
            return this.segListMatchInUniqueNames(id.getSegments(), this.hierarchyUniqueNames);
        }
        if (this.segMatchInNames(this.getLastSegment(id), this.levelNames)) {
            return false;
        }
        return size > 1;
    }

    private boolean segListMatchInUniqueNames(List<Id.Segment> segments, Collection<String> names) {
        String segUniqueName = Util.implode(segments);
        for (String name : names) {
            if (!Util.equalName(segUniqueName, name)) continue;
            return true;
        }
        return false;
    }

    private boolean segMatchInNames(Id.Segment seg, Collection<String> names) {
        for (String name : names) {
            if (!seg.matches(name)) continue;
            return true;
        }
        return false;
    }

    private boolean segmentIsCalcMember(List<Id.Segment> checkSegments) {
        return this.query.getSchemaReader(true).getCalculatedMember(checkSegments) != null;
    }

    private List<Id> findChildIds(Id parent, SortedSet<Id> identifiers) {
        ArrayList<Id> childIds = new ArrayList<Id>();
        for (Id id : identifiers) {
            List<Id.Segment> idSeg = id.getSegments();
            List<Id.Segment> parentSegments = parent.getSegments();
            int parentSegSize = parentSegments.size();
            if (idSeg.size() != parentSegSize + 1 || !parent.getSegments().equals(idSeg.subList(0, parentSegSize))) continue;
            childIds.add(id);
        }
        return childIds;
    }

    private void expandIdentifiers(Set<Id> identifiers) {
        HashSet<Id> expandedIdentifiers = new HashSet<Id>();
        for (Id id : identifiers) {
            for (int i = 1; i < id.getSegments().size(); ++i) {
                expandedIdentifiers.add(new Id(id.getSegments().subList(0, i)));
            }
        }
        identifiers.addAll(expandedIdentifiers);
    }

    private static class IdComparator
    implements Comparator<Id> {
        private IdComparator() {
        }

        @Override
        public int compare(Id o1, Id o2) {
            List<Id.Segment> o1Seg = o1.getSegments();
            List<Id.Segment> o2Seg = o2.getSegments();
            if (o1Seg.size() > o2Seg.size()) {
                return 1;
            }
            if (o1Seg.size() < o2Seg.size()) {
                return -1;
            }
            return o1Seg.toString().compareTo(o2Seg.toString());
        }
    }
}

