/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.rolap.ChildByNameConstraint;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SmartIncrementalCache;
import mondrian.rolap.SmartMemberListCache;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.DataSourceChangeListener;
import mondrian.util.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class MemberCacheHelper
implements MemberCache {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    final SmartMemberListCache<RolapMember, List<RolapMember>> mapMemberToChildren;
    final SmartIncrementalCache<RolapMember, Collection<RolapMember>> mapParentToNamedChildren;
    SmartCache<Object, RolapMember> mapKeyToMember;
    RolapHierarchy rolapHierarchy;
    DataSourceChangeListener changeListener;
    final SmartMemberListCache<RolapLevel, List<RolapMember>> mapLevelToMembers;

    public MemberCacheHelper(RolapHierarchy rolapHierarchy) {
        this.rolapHierarchy = rolapHierarchy;
        this.mapLevelToMembers = new SmartMemberListCache();
        this.mapKeyToMember = new SoftSmartCache<Object, RolapMember>();
        this.mapMemberToChildren = new SmartMemberListCache();
        this.mapParentToNamedChildren = new SmartIncrementalCache();
        this.changeListener = rolapHierarchy != null ? rolapHierarchy.getRolapSchema().getDataSourceChangeListener() : null;
    }

    @Override
    public RolapMember getMember(Object key, boolean mustCheckCacheStatus) {
        if (mustCheckCacheStatus) {
            this.checkCacheStatus();
        }
        return this.mapKeyToMember.get(key);
    }

    @Override
    public Object putMember(Object key, RolapMember value) {
        return this.mapKeyToMember.put(key, value);
    }

    @Override
    public Object makeKey(RolapMember parent, Object key) {
        return new MemberKey(parent, key);
    }

    @Override
    public RolapMember getMember(Object key) {
        return this.getMember(key, true);
    }

    public synchronized void checkCacheStatus() {
        if (this.changeListener != null && this.changeListener.isHierarchyChanged(this.rolapHierarchy)) {
            this.flushCache();
        }
    }

    @Deprecated
    public void putLevelMembersInCache(RolapLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.putChildren(level, constraint, members);
    }

    @Override
    public void putChildren(RolapLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.mapLevelToMembers.put(level, constraint, members);
    }

    @Override
    public List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        if (constraint instanceof ChildByNameConstraint) {
            return this.findNamedChildrenInCache(member, ((ChildByNameConstraint)constraint).getChildNames());
        }
        return this.mapMemberToChildren.get(member, constraint);
    }

    private List<RolapMember> findNamedChildrenInCache(RolapMember parent, final List<String> childNames) {
        List<RolapMember> children = this.checkDefaultAndNamedChildrenCache(parent);
        if (children == null || childNames == null || childNames.size() > children.size()) {
            return null;
        }
        CollectionUtils.filter(children, (Predicate)new Predicate(){

            public boolean evaluate(Object member) {
                return childNames.contains(((RolapMember)member).getName());
            }
        });
        boolean foundAll = children.size() == childNames.size();
        return !foundAll ? null : children;
    }

    private List<RolapMember> checkDefaultAndNamedChildrenCache(RolapMember parent) {
        Collection<RolapMember> children = (Collection<RolapMember>)this.mapMemberToChildren.get(parent, DefaultMemberChildrenConstraint.instance());
        if (children == null) {
            children = this.mapParentToNamedChildren.get(parent);
        }
        return children == null ? Collections.emptyList() : new ArrayList<RolapMember>(children);
    }

    @Override
    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        if (constraint instanceof ChildByNameConstraint) {
            this.putChildrenInChildNameCache(member, children);
        } else {
            this.mapMemberToChildren.put(member, constraint, children);
        }
    }

    private void putChildrenInChildNameCache(RolapMember parent, List<RolapMember> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        Collection<RolapMember> cachedChildren = this.mapParentToNamedChildren.get(parent);
        if (cachedChildren == null) {
            this.mapParentToNamedChildren.put(parent, new TreeSet<RolapMember>(children));
        } else {
            this.mapParentToNamedChildren.addToEntry(parent, children);
        }
    }

    @Override
    public List<RolapMember> getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        }
        return this.mapLevelToMembers.get(level, constraint);
    }

    public synchronized void flushCache() {
        this.mapMemberToChildren.clear();
        this.mapKeyToMember.clear();
        this.mapLevelToMembers.clear();
        this.mapParentToNamedChildren.clear();
        for (Level level : this.rolapHierarchy.getLevels()) {
            ((RolapLevel)level).setApproxRowCount(Integer.MIN_VALUE);
        }
    }

    public DataSourceChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(DataSourceChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public synchronized RolapMember removeMember(Object key) {
        RolapLevel level = ((MemberKey)key).getLevel();
        if (level == null) {
            level = (RolapLevel)this.rolapHierarchy.getLevels()[0];
        }
        final RolapLevel levelRef = level;
        this.mapLevelToMembers.getCache().execute(new SmartCache.SmartCacheTask<Pair<RolapLevel, Object>, List<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<Pair<RolapLevel, Object>, List<RolapMember>>> iterator) {
                while (iterator.hasNext()) {
                    Map.Entry<Pair<RolapLevel, Object>, List<RolapMember>> entry = iterator.next();
                    RolapLevel cacheLevel = (RolapLevel)entry.getKey().left;
                    if (!cacheLevel.equals(levelRef) && (!cacheLevel.getHierarchy().equals(levelRef.getHierarchy()) || cacheLevel.getDepth() < levelRef.getDepth())) continue;
                    iterator.remove();
                }
            }
        });
        final RolapMember member = this.getMember(key);
        if (member == null) {
            return null;
        }
        final RolapMember parent = member.getParentMember();
        this.mapMemberToChildren.cache.execute(new SmartCache.SmartCacheTask<Pair<RolapMember, Object>, List<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<Pair<RolapMember, Object>, List<RolapMember>>> iter) {
                while (iter.hasNext()) {
                    Map.Entry<Pair<RolapMember, Object>, List<RolapMember>> entry = iter.next();
                    RolapMember member1 = (RolapMember)entry.getKey().left;
                    Object constraint = entry.getKey().right;
                    if (Util.equals(member1, parent)) {
                        if (constraint == DefaultMemberChildrenConstraint.instance()) {
                            List<RolapMember> siblings = entry.getValue();
                            boolean removedIt = siblings.remove(member);
                            Util.discard((boolean)removedIt);
                        } else {
                            iter.remove();
                        }
                    }
                    if (!Util.equals(member1, member)) continue;
                    iter.remove();
                }
            }
        });
        this.mapParentToNamedChildren.getCache().execute(new SmartCache.SmartCacheTask<RolapMember, Collection<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<RolapMember, Collection<RolapMember>>> iterator) {
                while (iterator.hasNext()) {
                    Map.Entry<RolapMember, Collection<RolapMember>> entry = iterator.next();
                    RolapMember currentMember = entry.getKey();
                    if (member.equals(currentMember)) {
                        iterator.remove();
                        continue;
                    }
                    if (!parent.equals(currentMember)) continue;
                    entry.getValue().remove(member);
                }
            }
        });
        return this.mapKeyToMember.put(key, null);
    }

    @Override
    public RolapMember removeMemberAndDescendants(Object key) {
        return null;
    }
}

