/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.ConnectionKey;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.SchemaContentKey;
import mondrian.rolap.SchemaKey;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.spi.DynamicSchemaProcessor;
import mondrian.util.ByteString;
import mondrian.util.ClassResolver;
import mondrian.util.ExpiringReference;
import org.apache.log4j.Logger;

class RolapSchemaPool {
    static final Logger LOGGER = Logger.getLogger(RolapSchemaPool.class);
    private static final RolapSchemaPool INSTANCE = new RolapSchemaPool();
    private final Map<SchemaKey, ExpiringReference<RolapSchema>> mapKeyToSchema = new HashMap<SchemaKey, ExpiringReference<RolapSchema>>();
    private final Map<ByteString, ExpiringReference<RolapSchema>> mapMd5ToSchema = new HashMap<ByteString, ExpiringReference<RolapSchema>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private RolapSchemaPool() {
    }

    static RolapSchemaPool instance() {
        return INSTANCE;
    }

    RolapSchema get(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr, Util.PropertyList connectInfo) {
        return this.get(catalogUrl, connectionKey, jdbcUser, dataSourceStr, null, connectInfo);
    }

    RolapSchema get(String catalogUrl, DataSource dataSource, Util.PropertyList connectInfo) {
        return this.get(catalogUrl, null, null, null, dataSource, connectInfo);
    }

    private RolapSchema get(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr, DataSource dataSource, Util.PropertyList connectInfo) {
        String connectionUuidStr = connectInfo.get(RolapConnectionProperties.JdbcConnectionUuid.name());
        boolean useSchemaPool = Boolean.parseBoolean(connectInfo.get(RolapConnectionProperties.UseSchemaPool.name(), "true"));
        String pinSchemaTimeout = connectInfo.get(RolapConnectionProperties.PinSchemaTimeout.name(), "-1s");
        boolean useContentChecksum = Boolean.parseBoolean(connectInfo.get(RolapConnectionProperties.UseContentChecksum.name()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("get: catalog=" + catalogUrl + ", connectionKey=" + connectionKey + ", jdbcUser=" + jdbcUser + ", dataSourceStr=" + dataSourceStr + ", dataSource=" + dataSource + ", jdbcConnectionUuid=" + connectionUuidStr + ", useSchemaPool=" + useSchemaPool + ", useContentChecksum=" + useContentChecksum + ", map-size=" + this.mapKeyToSchema.size() + ", md5-map-size=" + this.mapMd5ToSchema.size()));
        }
        ConnectionKey connectionKey1 = ConnectionKey.create(connectionUuidStr, dataSource, catalogUrl, connectionKey, jdbcUser, dataSourceStr);
        String catalogStr = RolapSchemaPool.getSchemaContent(connectInfo, catalogUrl);
        SchemaContentKey schemaContentKey = SchemaContentKey.create(connectInfo, catalogUrl, catalogStr);
        SchemaKey key = new SchemaKey(schemaContentKey, connectionKey1);
        if (!useSchemaPool) {
            RolapSchema schema = this.createRolapSchema(catalogUrl, dataSource, connectInfo, catalogStr, key, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("create (no pool): schema-name=" + schema.getName() + ", schema-id=" + Integer.toHexString(System.identityHashCode(schema))));
            }
            return schema;
        }
        if (useContentChecksum) {
            return this.getByChecksum(catalogUrl, dataSource, connectInfo, pinSchemaTimeout, catalogStr, key);
        }
        return this.getByKey(catalogUrl, dataSource, connectInfo, pinSchemaTimeout, catalogStr, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> RolapSchema lookUp(Map<T, ExpiringReference<RolapSchema>> map, T key, String pinSchemaTimeout) {
        this.lock.readLock().lock();
        try {
            RolapSchema schema;
            ExpiringReference<RolapSchema> ref = map.get(key);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("get(key=" + key + ") returned " + RolapSchemaPool.toString(ref)));
            }
            if (ref != null && (schema = ref.get(pinSchemaTimeout)) != null) {
                RolapSchema rolapSchema = schema;
                return rolapSchema;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RolapSchema getByKey(String catalogUrl, DataSource dataSource, Util.PropertyList connectInfo, String pinSchemaTimeout, String catalogStr, SchemaKey key) {
        RolapSchema schema = this.lookUp(this.mapKeyToSchema, key, pinSchemaTimeout);
        if (schema != null) {
            return schema;
        }
        this.lock.writeLock().lock();
        try {
            ExpiringReference<RolapSchema> ref = this.mapKeyToSchema.get(key);
            if (ref != null) {
                schema = ref.get(pinSchemaTimeout);
                if (schema == null) {
                    this.mapKeyToSchema.remove(key);
                } else {
                    RolapSchema rolapSchema = schema;
                    return rolapSchema;
                }
            }
            schema = this.createRolapSchema(catalogUrl, dataSource, connectInfo, catalogStr, key, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("create: " + schema));
            }
            this.putSchema(schema, null, pinSchemaTimeout);
            RolapSchema rolapSchema = schema;
            return rolapSchema;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RolapSchema getByChecksum(String catalogUrl, DataSource dataSource, Util.PropertyList connectInfo, String pinSchemaTimeout, String catalogStr, SchemaKey key) {
        ByteString md5Bytes = new ByteString(Util.digestMd5(catalogStr));
        RolapSchema schema = this.lookUp(this.mapMd5ToSchema, md5Bytes, pinSchemaTimeout);
        if (schema != null) {
            return schema;
        }
        this.lock.writeLock().lock();
        try {
            ExpiringReference<RolapSchema> ref = this.mapMd5ToSchema.get(md5Bytes);
            if (ref != null) {
                schema = ref.get(pinSchemaTimeout);
                if (schema == null) {
                    this.mapKeyToSchema.remove(key);
                    this.mapMd5ToSchema.remove(md5Bytes);
                } else {
                    RolapSchema rolapSchema = schema;
                    return rolapSchema;
                }
            }
            schema = this.createRolapSchema(catalogUrl, dataSource, connectInfo, catalogStr, key, md5Bytes);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("create: schema-name=" + schema.getName() + ", schema-id=" + System.identityHashCode(schema)));
            }
            this.putSchema(schema, md5Bytes, pinSchemaTimeout);
            RolapSchema rolapSchema = schema;
            return rolapSchema;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    RolapSchema createRolapSchema(String catalogUrl, DataSource dataSource, Util.PropertyList connectInfo, String catalogStr, SchemaKey key, ByteString md5Bytes) {
        return new RolapSchema(key, md5Bytes, catalogUrl, catalogStr, connectInfo, dataSource);
    }

    private void putSchema(RolapSchema schema, ByteString md5Bytes, String pinTimeout) {
        ExpiringReference<RolapSchema> reference = new ExpiringReference<RolapSchema>(schema, pinTimeout);
        if (md5Bytes != null) {
            this.mapMd5ToSchema.put(md5Bytes, reference);
        }
        this.mapKeyToSchema.put(schema.key, reference);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("put: schema=" + schema + ", key=" + schema.key + ", checksum=" + md5Bytes + ", map-size=" + this.mapKeyToSchema.size() + ", md5-map-size=" + this.mapMd5ToSchema.size()));
        }
    }

    private static String getSchemaContent(Util.PropertyList connectInfo, String catalogUrl) {
        String dynProcName = connectInfo.get(RolapConnectionProperties.DynamicSchemaProcessor.name());
        String catalogStr = connectInfo.get(RolapConnectionProperties.CatalogContent.name());
        if (Util.isEmpty(catalogStr)) {
            if (Util.isEmpty(catalogUrl)) {
                throw MondrianResource.instance().ConnectStringMandatoryProperties.ex(RolapConnectionProperties.Catalog.name(), RolapConnectionProperties.CatalogContent.name());
            }
            if (!Util.isEmpty(dynProcName)) {
                catalogStr = RolapSchemaPool.processDynamicSchema(dynProcName, catalogUrl, null, connectInfo);
            }
            if (Util.isEmpty(catalogStr)) {
                try {
                    catalogStr = Util.readVirtualFileAsString(catalogUrl);
                }
                catch (IOException e) {
                    throw Util.newError(e, "loading schema from url " + catalogUrl);
                }
            }
        } else if (!Util.isEmpty(dynProcName)) {
            catalogStr = RolapSchemaPool.processDynamicSchema(dynProcName, null, catalogStr, connectInfo);
        }
        return catalogStr;
    }

    private static String processDynamicSchema(String dynProcName, String catalogUrl, String catalogStr, Util.PropertyList connectInfo) {
        if (RolapSchema.LOGGER.isDebugEnabled()) {
            RolapSchema.LOGGER.debug((Object)("Pool.get: create schema \"" + catalogUrl + "\" using dynamic processor"));
        }
        try {
            DynamicSchemaProcessor dynProc = (DynamicSchemaProcessor)ClassResolver.INSTANCE.instantiateSafe(dynProcName, new Object[0]);
            if (catalogUrl != null) {
                return dynProc.processSchema(catalogUrl, connectInfo);
            }
            if (catalogStr != null) {
                return dynProc.processCatalog(catalogStr, connectInfo);
            }
            throw new IllegalArgumentException("At least one of catalogUrl and catalogStr should not be null");
        }
        catch (Exception e) {
            throw Util.newError(e, "loading DynamicSchemaProcessor " + dynProcName);
        }
    }

    void remove(String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
        SchemaContentKey schemaContentKey = SchemaContentKey.create(new Util.PropertyList(), catalogUrl, null);
        ConnectionKey connectionUuid = ConnectionKey.create(null, null, catalogUrl, connectionKey, jdbcUser, dataSourceStr);
        SchemaKey key = new SchemaKey(schemaContentKey, connectionUuid);
        if (RolapSchema.LOGGER.isDebugEnabled()) {
            RolapSchema.LOGGER.debug((Object)("Pool.remove: schema \"" + catalogUrl + "\" and datasource string \"" + dataSourceStr + "\""));
        }
        this.remove(key);
    }

    void remove(String catalogUrl, DataSource dataSource) {
        SchemaContentKey schemaContentKey = SchemaContentKey.create(new Util.PropertyList(), catalogUrl, null);
        ConnectionKey connectionKey = ConnectionKey.create(null, dataSource, catalogUrl, null, null, null);
        SchemaKey key = new SchemaKey(schemaContentKey, connectionKey);
        if (RolapSchema.LOGGER.isDebugEnabled()) {
            RolapSchema.LOGGER.debug((Object)("Pool.remove: schema \"" + catalogUrl + "\" and datasource object"));
        }
        this.remove(key);
    }

    void remove(RolapSchema schema) {
        if (schema != null) {
            if (RolapSchema.LOGGER.isDebugEnabled()) {
                RolapSchema.LOGGER.debug((Object)("Pool.remove: schema \"" + schema.getName() + "\" and datasource object"));
            }
            this.remove(schema.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(SchemaKey key) {
        this.lock.writeLock().lock();
        RolapSchema schema = null;
        try {
            Reference ref = this.mapKeyToSchema.get(key);
            if (ref != null && (schema = (RolapSchema)ref.get()) != null) {
                this.mapMd5ToSchema.remove(schema.getChecksum());
            }
            this.mapKeyToSchema.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (schema != null) {
            schema.finalCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.lock.writeLock().lock();
        ArrayList<RolapSchema> schemas = new ArrayList<RolapSchema>();
        try {
            if (RolapSchema.LOGGER.isDebugEnabled()) {
                RolapSchema.LOGGER.debug((Object)"Pool.clear: clearing all RolapSchemas");
            }
            for (Reference reference : this.mapKeyToSchema.values()) {
                RolapSchema schema;
                if (reference == null || (schema = (RolapSchema)reference.get()) == null) continue;
                schemas.add(schema);
            }
            this.mapKeyToSchema.clear();
            this.mapMd5ToSchema.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (RolapSchema rolapSchema : schemas) {
            rolapSchema.finalCleanUp();
        }
        JdbcSchema.clearAllDBs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RolapSchema> getRolapSchemas() {
        this.lock.readLock().lock();
        try {
            ArrayList<RolapSchema> list = new ArrayList<RolapSchema>();
            for (RolapSchema schema : Util.GcIterator.over(this.mapKeyToSchema.values())) {
                list.add(schema);
            }
            ArrayList<RolapSchema> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean contains(RolapSchema rolapSchema) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mapKeyToSchema.containsKey(rolapSchema.key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static <T> String toString(Reference<T> ref) {
        if (ref == null) {
            return "null";
        }
        T t = ref.get();
        if (t == null) {
            return "ref(null)";
        }
        return "ref(" + t + ", id=" + Integer.toHexString(System.identityHashCode(t)) + ")";
    }
}

