/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Reporter;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.hadoop.mapreduce.MRUtil;
import org.pentaho.hadoop.mapreduce.OutputCollectorRowListener;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

public class PentahoMapReduceBase<K, V>
extends MapReduceBase {
    public static final String STRING_COMBINE_SINGLE_THREADED = "transformation-combine-single-threaded";
    public static final String STRING_REDUCE_SINGLE_THREADED = "transformation-reduce-single-threaded";
    private final String ENVIRONMENT_VARIABLE_PREFIX = "java.system.";
    private final String KETTLE_VARIABLE_PREFIX = "KETTLE_";
    protected String transMapXml;
    protected String transCombinerXml;
    protected String transReduceXml;
    protected String mapInputStepName;
    protected String combinerInputStepName;
    protected String reduceInputStepName;
    protected String mapOutputStepName;
    protected String combinerOutputStepName;
    protected String reduceOutputStepName;
    protected VariableSpace variableSpace = null;
    protected Class<K> outClassK;
    protected Class<V> outClassV;
    protected String id = UUID.randomUUID().toString();
    protected boolean debug = false;
    protected LogLevel logLevel;
    protected Trans trans;
    protected MROperations mrOperation;
    protected OutputCollectorRowListener<K, V> rowCollector;
    protected boolean combineSingleThreaded;
    protected boolean reduceSingleThreaded;

    public void configure(JobConf job) {
        String stringLogLevel;
        super.configure(job);
        this.debug = "true".equalsIgnoreCase(job.get("debug"));
        this.transMapXml = job.get("transformation-map-xml");
        this.transCombinerXml = job.get("transformation-combiner-xml");
        this.transReduceXml = job.get("transformation-reduce-xml");
        this.mapInputStepName = job.get("transformation-map-input-stepname");
        this.mapOutputStepName = job.get("transformation-map-output-stepname");
        this.combinerInputStepName = job.get("transformation-combiner-input-stepname");
        this.combinerOutputStepName = job.get("transformation-combiner-output-stepname");
        this.combineSingleThreaded = this.isCombinerSingleThreaded((Configuration)job);
        this.reduceInputStepName = job.get("transformation-reduce-input-stepname");
        this.reduceOutputStepName = job.get("transformation-reduce-output-stepname");
        this.reduceSingleThreaded = this.isReducerSingleThreaded((Configuration)job);
        String xmlVariableSpace = job.get("variableSpace");
        if (!Const.isEmpty((String)xmlVariableSpace)) {
            this.setDebugStatus("PentahoMapReduceBase. variableSpace was retrieved from the job.  The contents: ");
            XStream xStream = new XStream();
            if (xStream != null) {
                this.setDebugStatus("PentahoMapReduceBase: Setting classes variableSpace property.: ");
                this.variableSpace = (VariableSpace)xStream.fromXML(xmlVariableSpace);
                for (String variableName : this.variableSpace.listVariables()) {
                    if (!variableName.startsWith("KETTLE_")) continue;
                    System.setProperty(variableName, this.variableSpace.getVariable(variableName));
                }
            }
        } else {
            this.setDebugStatus("PentahoMapReduceBase: The PDI Job's variable space was not found in the job configuration.");
            this.variableSpace = new Variables();
        }
        for (Map.Entry entry : job) {
            if (((String)entry.getKey()).startsWith("java.system.")) {
                System.setProperty(((String)entry.getKey()).substring("java.system.".length()), (String)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).startsWith("KETTLE_")) continue;
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        MRUtil.passInformationToTransformation(this.variableSpace, job);
        switch (this.mrOperation) {
            case Combine: {
                this.outClassK = job.getMapOutputKeyClass();
                this.outClassV = job.getMapOutputValueClass();
                break;
            }
            case Reduce: {
                this.outClassK = job.getOutputKeyClass();
                this.outClassV = job.getOutputValueClass();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported MapReduce operation: " + (Object)((Object)this.mrOperation));
            }
        }
        if (this.debug) {
            System.out.println("Job configuration>");
            System.out.println("Output key class: " + this.outClassK.getName());
            System.out.println("Output value class: " + this.outClassV.getName());
        }
        if (!Const.isEmpty((String)(stringLogLevel = job.get("logLevel")))) {
            this.logLevel = LogLevel.valueOf((String)stringLogLevel);
            this.setDebugStatus("Log level set to " + stringLogLevel);
        } else {
            System.out.println("Could not retrieve the log level from the job configuration.  logLevel will not be set.");
        }
        this.createTrans((Configuration)job);
    }

    public void close() throws IOException {
        super.close();
    }

    @Deprecated
    public void injectValue(Object key, ITypeConverter inConverterK, ITypeConverter inConverterV, RowMeta injectorRowMeta, RowProducer rowProducer, Object value, Reporter reporter) throws Exception {
        this.injectValue(key, inConverterK, value, inConverterV, (RowMetaInterface)injectorRowMeta, rowProducer, reporter);
    }

    public void injectValue(Object key, ITypeConverter inConverterK, Object value, ITypeConverter inConverterV, RowMetaInterface injectorRowMeta, RowProducer rowProducer, Reporter reporter) throws Exception {
        this.injectValue(key, 0, inConverterK, value, 1, inConverterV, injectorRowMeta, rowProducer, reporter);
    }

    public void injectValue(Object key, int keyOrdinal, ITypeConverter inConverterK, Object value, int valueOrdinal, ITypeConverter inConverterV, RowMetaInterface injectorRowMeta, RowProducer rowProducer, Reporter reporter) throws Exception {
        Object[] row = new Object[injectorRowMeta.size()];
        row[keyOrdinal] = inConverterK != null ? inConverterK.convert(injectorRowMeta.getValueMeta(keyOrdinal), key) : key;
        Object object = row[valueOrdinal] = inConverterV != null ? inConverterV.convert(injectorRowMeta.getValueMeta(valueOrdinal), value) : value;
        if (this.debug) {
            this.setDebugStatus(reporter, "Injecting input record [" + row[keyOrdinal] + "] - [" + row[valueOrdinal] + "]");
        }
        rowProducer.putRow(injectorRowMeta, row);
    }

    protected void createTrans(Configuration conf) {
        if (this.mrOperation == null) {
            throw new RuntimeException("Map or reduce operation has not been specified.  Call setMRType from implementing classes constructor.");
        }
        try {
            if (this.mrOperation.equals((Object)MROperations.Map)) {
                this.setDebugStatus("Creating a transformation for a map.");
                this.trans = MRUtil.getTrans(conf, this.transMapXml, false);
            } else if (this.mrOperation.equals((Object)MROperations.Combine)) {
                this.setDebugStatus("Creating a transformation for a combiner.");
                this.trans = MRUtil.getTrans(conf, this.transCombinerXml, this.isCombinerSingleThreaded(conf));
            } else if (this.mrOperation.equals((Object)MROperations.Reduce)) {
                this.setDebugStatus("Creating a transformation for a reduce.");
                this.trans = MRUtil.getTrans(conf, this.transReduceXml, this.isReducerSingleThreaded(conf));
            }
        }
        catch (KettleException ke) {
            throw new RuntimeException("Error loading transformation for " + (Object)((Object)this.mrOperation), ke);
        }
    }

    private boolean isCombinerSingleThreaded(Configuration conf) {
        return "true".equalsIgnoreCase(conf.get(STRING_COMBINE_SINGLE_THREADED));
    }

    private boolean isReducerSingleThreaded(Configuration conf) {
        return "true".equalsIgnoreCase(conf.get(STRING_REDUCE_SINGLE_THREADED));
    }

    public void setMRType(MROperations mrOperation) {
        this.mrOperation = mrOperation;
    }

    public String getTransMapXml() {
        return this.transMapXml;
    }

    public void setTransMapXml(String transMapXml) {
        this.transMapXml = transMapXml;
    }

    public String getTransCombinerXml() {
        return this.transCombinerXml;
    }

    public void setCombinerMapXml(String transCombinerXml) {
        this.transCombinerXml = transCombinerXml;
    }

    public String getTransReduceXml() {
        return this.transReduceXml;
    }

    public void setTransReduceXml(String transReduceXml) {
        this.transReduceXml = transReduceXml;
    }

    public String getMapInputStepName() {
        return this.mapInputStepName;
    }

    public void setMapInputStepName(String mapInputStepName) {
        this.mapInputStepName = mapInputStepName;
    }

    public String getMapOutputStepName() {
        return this.mapOutputStepName;
    }

    public void setMapOutputStepName(String mapOutputStepName) {
        this.mapOutputStepName = mapOutputStepName;
    }

    public String getCombinerInputStepName() {
        return this.combinerInputStepName;
    }

    public void setCombinerInputStepName(String combinerInputStepName) {
        this.combinerInputStepName = combinerInputStepName;
    }

    public String getCombinerOutputStepName() {
        return this.combinerOutputStepName;
    }

    public void setCombinerOutputStepName(String combinerOutputStepName) {
        this.combinerOutputStepName = combinerOutputStepName;
    }

    public String getReduceInputStepName() {
        return this.reduceInputStepName;
    }

    public void setReduceInputStepName(String reduceInputStepName) {
        this.reduceInputStepName = reduceInputStepName;
    }

    public String getReduceOutputStepName() {
        return this.reduceOutputStepName;
    }

    public void setReduceOutputStepName(String reduceOutputStepName) {
        this.reduceOutputStepName = reduceOutputStepName;
    }

    public Class<?> getOutClassK() {
        return this.outClassK;
    }

    public void setOutClassK(Class<K> outClassK) {
        this.outClassK = outClassK;
    }

    public Class<?> getOutClassV() {
        return this.outClassV;
    }

    public void setOutClassV(Class<V> outClassV) {
        this.outClassV = outClassV;
    }

    public Trans getTrans() {
        return this.trans;
    }

    public void setTrans(Trans trans) {
        this.trans = trans;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Exception getException() {
        return this.rowCollector != null ? this.rowCollector.getException() : null;
    }

    public void setDebugStatus(Reporter reporter, String message) {
        if (this.debug) {
            System.out.println(message);
            reporter.setStatus(message);
        }
    }

    private void setDebugStatus(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    public static enum MROperations {
        Map,
        Combine,
        Reduce;

    }

    protected static enum Counter {
        INPUT_RECORDS,
        OUTPUT_RECORDS,
        OUT_RECORD_WITH_NULL_KEY,
        OUT_RECORD_WITH_NULL_VALUE;

    }
}

