/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.googleanalytics;

import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.services.analytics.Analytics;
import com.google.api.services.analytics.model.Account;
import com.google.api.services.analytics.model.Accounts;
import com.google.api.services.analytics.model.GaData;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepData;
import org.pentaho.di.trans.steps.googleanalytics.GaInputStepMeta;
import org.pentaho.di.trans.steps.googleanalytics.GoogleAnalyticsApiFacade;

public class GaInputStep
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GaInputStepMeta.class;
    private GaInputStepData data;
    private GaInputStepMeta meta;
    private Analytics analytics;
    private String accountName;

    public GaInputStep(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.conversionMeta = new ValueMetaInterface[this.meta.getFieldsCount()];
            for (int i = 0; i < this.meta.getFieldsCount(); ++i) {
                ValueMetaInterface returnMeta = this.data.outputRowMeta.getValueMeta(i);
                ValueMetaInterface conversionMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)returnMeta, (int)2);
                conversionMeta.setConversionMask(this.meta.getConversionMask()[i]);
                conversionMeta.setDecimalSymbol(".");
                conversionMeta.setGroupingSymbol(null);
                this.data.conversionMeta[i] = conversionMeta;
            }
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        List<String> entry = this.getNextDataEntry();
        if (entry != null && (this.meta.getRowLimit() <= 0 || this.getLinesWritten() < (long)this.meta.getRowLimit())) {
            int j = 0;
            for (int i = 0; i < this.meta.getFieldsCount(); ++i) {
                Object dataObject;
                String fieldName = this.environmentSubstitute(this.meta.getFeedField()[i]);
                String type = this.environmentSubstitute(this.meta.getFeedFieldType()[i]);
                if ("Data Source Property".equals(type)) {
                    dataObject = "ga:accountName".equals(fieldName) ? this.accountName : this.data.feed.getProfileInfo().get((Object)this.removeClassifier(fieldName));
                } else if ("Data Source Field".equals(type)) {
                    dataObject = "dxp:tableId".equals(fieldName) ? this.data.feed.getProfileInfo().get((Object)this.removeClassifier(fieldName)) : this.data.feed.getProfileInfo().getProfileName();
                } else if ("Confidence Interval for Metric".equals(type)) {
                    dataObject = null;
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Warn.FieldTypeNotSupported", (String[])new String[]{"Confidence Interval for Metric"}));
                    }
                } else {
                    dataObject = entry.get(j++);
                }
                outputRow[i] = this.data.outputRowMeta.getValueMeta(i).convertData(this.data.conversionMeta[i], dataObject);
            }
            this.putRow(this.data.outputRowMeta, outputRow);
            if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
                this.logBasic("Linenr " + this.getLinesWritten());
            }
            return true;
        }
        this.setOutputDone();
        return false;
    }

    protected Analytics.Data.Ga.Get getQuery(Analytics analytics) {
        Analytics.Data dataApi = analytics.data();
        try {
            String metrics = this.environmentSubstitute(this.meta.getMetrics());
            if (Utils.isEmpty((CharSequence)metrics)) {
                this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.NoMetricsSpecified.Message", (String[])new String[0]));
                return null;
            }
            Analytics.Data.Ga.Get query = dataApi.ga().get(this.meta.isUseCustomTableId() ? this.environmentSubstitute(this.meta.getGaCustomTableId()) : this.meta.getGaProfileTableId(), this.environmentSubstitute(this.meta.getStartDate()), this.environmentSubstitute(this.meta.getEndDate()), metrics);
            String dimensions = this.environmentSubstitute(this.meta.getDimensions());
            if (!Utils.isEmpty((CharSequence)dimensions)) {
                query.setDimensions(dimensions);
            }
            if (this.meta.isUseSegment()) {
                if (this.meta.isUseCustomSegment()) {
                    query.setSegment(this.environmentSubstitute(this.meta.getCustomSegment()));
                } else {
                    query.setSegment(this.meta.getSegmentId());
                }
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getSamplingLevel())) {
                query.setSamplingLevel(this.environmentSubstitute(this.meta.getSamplingLevel()));
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getFilters()) && !Utils.isEmpty((CharSequence)this.environmentSubstitute(this.meta.getFilters()))) {
                query.setFilters(this.environmentSubstitute(this.meta.getFilters()));
            }
            if (!Utils.isEmpty((CharSequence)this.meta.getSort())) {
                query.setSort(this.environmentSubstitute(this.meta.getSort()));
            }
            return query;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        String[] types = this.environmentSubstitute(this.meta.getFeedFieldType());
        if (types != null) {
            for (String type : types) {
                if (!"Confidence Interval for Metric".equals(type)) continue;
                this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Warn.FieldTypeNotSupported", (String[])new String[]{"Confidence Interval for Metric"}));
            }
        }
        String appName = this.environmentSubstitute(this.meta.getGaAppName());
        String serviceAccount = this.environmentSubstitute(this.meta.getOAuthServiceAccount());
        String OAuthKeyFile = this.environmentSubstitute(this.meta.getOAuthKeyFile());
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.AppName.Label", (String[])new String[0]) + ": " + appName);
            this.logDetailed(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.OauthAccount.Label", (String[])new String[0]) + ": " + serviceAccount);
            this.logDetailed(BaseMessages.getString(PKG, (String)"GoogleAnalyticsDialog.KeyFile.Label", (String[])new String[0]) + ": " + OAuthKeyFile);
        }
        try {
            this.analytics = GoogleAnalyticsApiFacade.createFor(appName, serviceAccount, OAuthKeyFile).getAnalytics();
            this.accountName = ((Account)((Accounts)this.analytics.management().accounts().list().execute()).getItems().iterator().next()).getName();
        }
        catch (TokenResponseException tre) {
            Throwable exceptionToLog = tre;
            if (tre.getDetails() != null && tre.getDetails().getError() != null) {
                exceptionToLog = new IOException(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.OAuth2.Auth", (String[])new String[]{tre.getDetails().getError()}), tre);
            }
            this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.AccessingGaApi", (String[])new String[0]), exceptionToLog);
            return false;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GoogleAnalytics.Error.AccessingGaApi", (String[])new String[0]), e);
            return false;
        }
        return true;
    }

    List<String> getNextDataEntry() throws KettleException {
        if (this.data.query == null) {
            this.data.query = this.getQuery(this.analytics);
            if (this.log.isDetailed()) {
                this.logDetailed("querying google analytics: " + this.data.query.buildHttpRequestUrl().toURI().toString());
            }
            try {
                this.data.feed = (GaData)this.data.query.execute();
                this.data.entryIndex = 0;
            }
            catch (IOException e2) {
                throw new KettleException((Throwable)e2);
            }
        }
        if (this.data.feed != null && this.data.entryIndex + 1 >= this.data.feed.getItemsPerPage()) {
            try {
                int startIndex = this.data.query.getStartIndex() == null ? 1 : this.data.query.getStartIndex();
                int totalResults = this.data.feed.getTotalResults() == null ? 0 : this.data.feed.getTotalResults();
                int newStartIndex = startIndex + this.data.entryIndex;
                if (newStartIndex <= totalResults) {
                    this.data.query.setStartIndex(Integer.valueOf(newStartIndex));
                    this.data.feed = (GaData)this.data.query.execute();
                    this.data.entryIndex = 0;
                }
            }
            catch (IOException e2) {
                throw new KettleException((Throwable)e2);
            }
        }
        if (this.data.feed != null) {
            List entries = this.data.feed.getRows();
            if (entries != null && this.data.entryIndex < entries.size()) {
                return (List)entries.get(this.data.entryIndex++);
            }
            return null;
        }
        return null;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GaInputStepMeta)smi;
        this.data = (GaInputStepData)sdi;
        super.dispose(smi, sdi);
    }

    private String removeClassifier(String original) {
        int colonIndex = original.indexOf(":");
        return original.substring(colonIndex + 1);
    }
}

