/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.palo.JobEntryCubeCreate;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="PALO_CUBE_CREATE", i18nPackageName="org.pentaho.di.job.entries.palo.JobEntryCubeCreate", image="ui/images/deprecated.svg", name="PaloCubeCreate.JobName", description="PaloCubeCreate.JobDescription", documentationUrl="http://wiki.pentaho.com/display/EAI/Palo+Cube+Create", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Deprecated")
public class PaloCubeCreate
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private DatabaseMeta databaseMeta;
    private String cubeName = "";
    private List<String> dimensionNames = new ArrayList<String>();

    public PaloCubeCreate(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public PaloCubeCreate() {
        this("");
    }

    public Object clone() {
        PaloCubeCreate je = (PaloCubeCreate)super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.getDatabaseMeta() == null ? "" : this.getDatabaseMeta().getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cubeName", (String)this.getCubeName()));
        retval.append("      <dimensions>").append(Const.CR);
        for (String dimensionName : this.dimensionNames) {
            retval.append("        ").append(XMLHandler.addTagValue((String)"dimensionname", (String)dimensionName));
        }
        retval.append("      </dimensions>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.setDatabaseMeta(DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)entrynode, (String)"connection")));
            this.setCubeName(XMLHandler.getTagValue((Node)entrynode, (String)"cubeName"));
            Node dimensionNode = XMLHandler.getSubNode((Node)entrynode, (String)"dimensions");
            int nrDimensions = XMLHandler.countNodes((Node)dimensionNode, (String)"dimensionname");
            for (int i = 0; i < nrDimensions; ++i) {
                String dimensionName = XMLHandler.getNodeValue((Node)XMLHandler.getSubNodeByNr((Node)dimensionNode, (String)"dimensionname", (int)i));
                this.dimensionNames.add(dimensionName);
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load file exists job entry from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
            this.setCubeName(rep.getStepAttributeString(id_jobentry, "cubeName"));
            int nrFields = rep.countNrStepAttributes(id_jobentry, "dimensionname");
            for (int i = 0; i < nrFields; ++i) {
                String dimensionName = rep.getStepAttributeString(id_jobentry, i, "dimensionname");
                this.dimensionNames.add(dimensionName);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry for type file exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.databaseMeta);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "cubeName", this.getCubeName());
            for (int i = 0; i < this.dimensionNames.size(); ++i) {
                rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "dimensionname", this.dimensionNames.get(i));
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("unable to save jobentry of type 'file exists' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result prevResult, int nr) throws KettleException {
        Result result = new Result(nr);
        result.setResult(false);
        this.logDetailed(this.toString(), new Object[]{"Start of processing"});
        String realCubeName = this.environmentSubstitute(this.getCubeName());
        PaloHelper database = new PaloHelper(this.getDatabaseMeta(), this.getLogLevel());
        try {
            database.connect();
            database.createCube(realCubeName, this.dimensionNames.toArray(new String[this.dimensionNames.size()]));
            result.setResult(true);
            result.setNrLinesOutput(1L);
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            e.printStackTrace();
            this.logError(this.toString(), new Object[]{"Error processing Palo Cube Create : " + e.getMessage()});
        }
        finally {
            database.disconnect();
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public void setDimensionNames(List<String> dimensionNames) {
        this.dimensionNames = dimensionNames;
    }

    public List<String> getDimensionNames() {
        return this.dimensionNames;
    }
}

