/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.dimoutput;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.palo.core.ConsolidationCollection;
import org.pentaho.di.palo.core.ConsolidationElement;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputData;
import org.pentaho.di.trans.steps.palo.dimoutput.PaloDimOutputMeta;

public class PaloDimOutput
extends BaseStep
implements StepInterface {
    private PaloDimOutputMeta meta;
    private PaloDimOutputData data;
    private int rowCount = 0;
    private ConsolidationCollection consolidations;

    public PaloDimOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public final boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (PaloDimOutputMeta)smi;
        this.data = (PaloDimOutputData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            this.logBasic("First Row Analysis:");
            if (this.meta.getLevels().size() == 0) {
                throw new KettleException("Number of levels must be greater that 0 to process the rows");
            }
            this.logBasic("Number of defined levels: " + this.meta.getLevels().size());
            this.data.indexes = new int[this.meta.getLevels().size() * 2];
            for (int i = 0; i < this.meta.getLevels().size(); ++i) {
                String dataFieldName = this.meta.getLevels().get(i).getFieldName();
                int numRow = this.getInputRowMeta().indexOfValue(dataFieldName);
                if (numRow < 0) {
                    throw new KettleException("DimOutput: failed to find input row meta for ".concat(this.meta.getLevels().get(i).getLevelName()));
                }
                this.data.indexes[i * 2] = numRow;
                this.logDebug(this.meta.getLevels().get(i).getLevelName() + " has index: " + numRow);
                String consolidationFieldName = this.meta.getLevels().get(i).getConsolidationFieldName();
                if (consolidationFieldName == null) {
                    numRow = -1;
                    this.logDebug("Consolidation factor was left to the default");
                } else {
                    numRow = this.getInputRowMeta().indexOfValue(consolidationFieldName);
                    if (numRow < 0) {
                        throw new KettleException("DimOutput: failed to find input row meta for ".concat(this.meta.getLevels().get(i).getConsolidationFieldName()));
                    }
                    this.logDebug(this.meta.getLevels().get(i).getConsolidationFieldName() + " has index: " + numRow);
                }
                this.data.indexes[i * 2 + 1] = numRow;
            }
            this.data.helper.manageDimension(this.meta.getDimension(), this.meta.getCreateNewDimension(), this.meta.getClearDimension(), this.meta.getClearConsolidations(), this.meta.getRecreateDimension());
            try {
                this.data.helper.loadDimensionCache(this.meta.getDimension(), this.meta.getEnableElementCache(), this.meta.getPreloadElementCache());
            }
            catch (Exception e) {
                throw new KettleException("Failed to load cache", (Throwable)e);
            }
        }
        if (r != null) {
            ++this.rowCount;
            try {
                ConsolidationElement parent = null;
                for (int i = 0; i < this.data.indexes.length; ++i) {
                    if (i % 2 == 0) {
                        if (r[this.data.indexes[i]] == null) continue;
                        this.data.elementNamesBatch.add(r[this.data.indexes[i]].toString());
                        continue;
                    }
                    double consolidation_factor = 1.0;
                    if (this.data.indexes[i] >= 0) {
                        consolidation_factor = Double.parseDouble((r[this.data.indexes[i]] == null ? Integer.valueOf(0) : r[this.data.indexes[i]]).toString());
                    }
                    ConsolidationElement child = null;
                    if (r[this.data.indexes[i - 1]] != null) {
                        String elementName = r[this.data.indexes[i - 1]].toString();
                        if (!this.consolidations.hasConsolidationElement(elementName)) {
                            child = new ConsolidationElement(elementName);
                            this.consolidations.add(child);
                        } else {
                            child = this.consolidations.getConsolidationElement(elementName);
                        }
                        if (parent != null) {
                            parent.addChild(child, consolidation_factor);
                        }
                    }
                    parent = child;
                }
                if (this.data.elementNamesBatch.size() % 100 == 0) {
                    this.commitBatch();
                }
            }
            catch (Exception e) {
                throw new KettleException("Failed to add row to the row buffer", (Throwable)e);
            }
        }
        if (r == null) {
            try {
                if (this.data.elementNamesBatch.size() > 0) {
                    this.commitBatch();
                }
                this.data.helper.clearDimensionCache();
                this.data.helper.loadDimensionCache(this.meta.getDimension(), this.meta.getEnableElementCache(), this.meta.getPreloadElementCache());
                this.logBasic("All rows have been added. Looking for consolidations");
                this.logBasic("Updating consolidations for Dimension" + this.meta.getDimension());
                this.data.helper.addDimensionConsolidations(this.meta.getDimension(), this.consolidations);
                this.logBasic("Consolidations updated.");
                this.setOutputDone();
                return false;
            }
            catch (Exception e) {
                throw new KettleException("Failed to add dimension rows", (Throwable)e);
            }
        }
        return true;
    }

    private void commitBatch() throws Exception {
        this.data.helper.addDimensionElements(this.data.elementNamesBatch, this.meta.getElementType());
        while (this.rowCount > 0) {
            this.incrementLinesOutput();
            --this.rowCount;
        }
        this.data.elementNamesBatch.clear();
    }

    public final boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PaloDimOutputMeta)smi;
        this.data = (PaloDimOutputData)sdi;
        this.consolidations = new ConsolidationCollection();
        if (super.init(smi, sdi)) {
            try {
                this.logBasic("Meta Levels:" + this.meta.getLevels().size());
                this.data.helper = new PaloHelper(this.meta.getDatabaseMeta(), this.getLogLevel());
                this.data.helper.connect();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.helper.disconnect();
        super.dispose(smi, sdi);
    }
}

