/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.vfs.hdfs;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileSystem;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileStatus;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystem;

public class HDFSFileObject
extends AbstractFileObject {
    private HadoopFileSystem hdfs;

    public HDFSFileObject(AbstractFileName name, HDFSFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
        this.hdfs = fileSystem.getHDFSFileSystem();
    }

    protected long doGetContentSize() throws Exception {
        return this.hdfs.getFileStatus(this.hdfs.getPath(this.getName().getPath())).getLen();
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        OutputStream out = append ? this.hdfs.append(this.hdfs.getPath(this.getName().getPath())) : this.hdfs.create(this.hdfs.getPath(this.getName().getPath()));
        return out;
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.hdfs.open(this.hdfs.getPath(this.getName().getPath()));
    }

    protected FileType doGetType() throws Exception {
        HadoopFileStatus status = null;
        try {
            status = this.hdfs.getFileStatus(this.hdfs.getPath(this.getName().getPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (status == null) {
            return FileType.IMAGINARY;
        }
        if (status.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    public void doCreateFolder() throws Exception {
        this.hdfs.mkdirs(this.hdfs.getPath(this.getName().getPath()));
    }

    public void doDelete() throws Exception {
        this.hdfs.delete(this.hdfs.getPath(this.getName().getPath()), true);
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.hdfs.rename(this.hdfs.getPath(this.getName().getPath()), this.hdfs.getPath(newfile.getName().getPath()));
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.hdfs.getFileStatus(this.hdfs.getPath(this.getName().getPath())).getModificationTime();
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.hdfs.setTimes(this.hdfs.getPath(this.getName().getPath()), modtime, System.currentTimeMillis());
        return true;
    }

    protected String[] doListChildren() throws Exception {
        HadoopFileStatus[] statusList = this.hdfs.listStatus(this.hdfs.getPath(this.getName().getPath()));
        String[] children = new String[statusList.length];
        for (int i = 0; i < statusList.length; ++i) {
            children[i] = statusList[i].getPath().getName();
        }
        return children;
    }
}

