/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.vfs.hdfs.nc;

import java.util.List;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.big.data.impl.vfs.hdfs.HDFSFileSystem;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.di.core.vfs.configuration.KettleGenericFileSystemConfigBuilder;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class NamedClusterConfigBuilder
extends KettleGenericFileSystemConfigBuilder {
    private static final NamedClusterConfigBuilder BUILDER = new NamedClusterConfigBuilder();
    private static final String EMBEDDED_METASTORE_KEY_PROPERTY = "embeddedMetaStoreKey";
    private final MetastoreLocatorOsgi metastoreLocator;
    private final NamedClusterService namedClusterService;

    public NamedClusterConfigBuilder() {
        this(null, null);
    }

    public NamedClusterConfigBuilder(MetastoreLocatorOsgi metastoreLocator, NamedClusterService namedClusterService) {
        this.metastoreLocator = metastoreLocator;
        this.namedClusterService = namedClusterService;
    }

    public static NamedClusterConfigBuilder getInstance() {
        return BUILDER;
    }

    public static FileSystemConfigBuilder getInstance(MetastoreLocatorOsgi metastoreLocator, NamedClusterService namedClusterService) {
        return new NamedClusterConfigBuilder(metastoreLocator, namedClusterService);
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return HDFSFileSystem.class;
    }

    public void snapshotNamedClusterToMetaStore(IMetaStore snapshotMetaStore) throws MetaStoreException {
        IMetaStore metaStore = this.metastoreLocator.getMetastore();
        List ncList = this.namedClusterService.list(metaStore);
        if (ncList != null) {
            for (NamedCluster nc : ncList) {
                this.namedClusterService.create(nc, snapshotMetaStore);
            }
        }
    }

    public void setEmbeddedMetastoreKey(FileSystemOptions opts, String embeddedMetaStoreKey) {
        this.setParam(opts, EMBEDDED_METASTORE_KEY_PROPERTY, embeddedMetaStoreKey);
    }

    public String getEmbeddedMetastoreKey(FileSystemOptions opts) {
        return (String)this.getParam(opts, EMBEDDED_METASTORE_KEY_PROPERTY);
    }
}

