/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterRSATokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class RefreshableKeycloakSecurityContext
extends KeycloakSecurityContext {
    protected static Logger log = Logger.getLogger(RefreshableKeycloakSecurityContext.class);
    protected transient KeycloakDeployment deployment;
    protected transient AdapterTokenStore tokenStore;
    protected String refreshToken;

    public RefreshableKeycloakSecurityContext() {
    }

    public RefreshableKeycloakSecurityContext(KeycloakDeployment deployment, AdapterTokenStore tokenStore, String tokenString, AccessToken token, String idTokenString, IDToken idToken, String refreshToken) {
        super(tokenString, token, idTokenString, idToken);
        this.deployment = deployment;
        this.tokenStore = tokenStore;
        this.refreshToken = refreshToken;
    }

    @Override
    public AccessToken getToken() {
        this.refreshExpiredToken(true);
        return super.getToken();
    }

    @Override
    public String getTokenString() {
        this.refreshExpiredToken(true);
        return super.getTokenString();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void logout(KeycloakDeployment deployment) {
        try {
            ServerRequest.invokeLogout(deployment, this.refreshToken);
        }
        catch (Exception e) {
            log.error((Object)"failed to invoke remote logout", (Throwable)e);
        }
    }

    public boolean isActive() {
        return this.token != null && this.token.isActive() && this.deployment != null && this.token.getIssuedAt() > this.deployment.getNotBefore();
    }

    public boolean isTokenTimeToLiveSufficient(AccessToken token) {
        return token != null && token.getExpiration() - this.deployment.getTokenMinimumTimeToLive() > Time.currentTime();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    public void setCurrentRequestInfo(KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        this.deployment = deployment;
        this.tokenStore = tokenStore;
    }

    public boolean refreshExpiredToken(boolean checkActive) {
        if (checkActive) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"checking whether to refresh.");
            }
            if (this.isActive() && this.isTokenTimeToLiveSufficient(this.token)) {
                return true;
            }
        }
        if (this.deployment == null || this.refreshToken == null) {
            return false;
        }
        if (!this.getRealm().equals(this.deployment.getRealm())) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Doing refresh");
        }
        AccessTokenResponse response = null;
        try {
            response = ServerRequest.invokeRefresh(this.deployment, this.refreshToken);
        }
        catch (IOException e) {
            log.error((Object)"Refresh token failure", (Throwable)e);
            return false;
        }
        catch (ServerRequest.HttpFailure httpFailure) {
            log.error((Object)("Refresh token failure status: " + httpFailure.getStatus() + " " + httpFailure.getError()));
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"received refresh response");
        }
        String tokenString = response.getToken();
        AccessToken token = null;
        try {
            token = AdapterRSATokenVerifier.verifyToken(tokenString, this.deployment);
            log.debug((Object)"Token Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error((Object)"failed verification of token");
            return false;
        }
        if (!this.isTokenTimeToLiveSufficient(token)) {
            log.error((Object)"failed to refresh the token with a longer time-to-live than the minimum");
            return false;
        }
        if (response.getNotBeforePolicy() > this.deployment.getNotBefore()) {
            this.deployment.updateNotBefore(response.getNotBeforePolicy());
        }
        this.token = token;
        if (response.getRefreshToken() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Setup new refresh token to the security context");
            }
            this.refreshToken = response.getRefreshToken();
        }
        this.tokenString = tokenString;
        if (this.tokenStore != null) {
            this.tokenStore.refreshCallback(this);
        }
        return true;
    }

    public void setAuthorizationContext(AuthorizationContext authorizationContext) {
        this.authorizationContext = authorizationContext;
    }
}

