/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.output;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroTypeConverter;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class AvroOutputMetaBase
extends BaseStepMeta
implements StepMetaInterface,
ResolvableResource {
    private static final String FILE_NAME = "filename";
    private static final String PRECISION = "precision";
    private static final String SCALE = "scale";
    private static final String NULLABLE = "nullable";
    private static final String DEFAULT = "default";
    private static final String SPACES_8 = "        ";
    private static final Class<?> PKG = AvroOutputMetaBase.class;
    @Injection(name="FILENAME")
    private String filename;
    @InjectionDeep
    private List<AvroOutputField> outputFields = new ArrayList<AvroOutputField>();
    @Injection(name="OPTIONS_DATE_IN_FILE_NAME")
    protected boolean dateInFileName = false;
    @Injection(name="OPTIONS_TIME_IN_FILE_NAME")
    protected boolean timeInFileName = false;
    @Injection(name="OPTIONS_DATE_FORMAT")
    protected String dateTimeFormat = "";
    @Injection(name="OPTIONS_COMPRESSION")
    protected String compressionType;
    @Injection(name="SCHEMA_FILENAME")
    protected String schemaFilename;
    @Injection(name="SCHEMA_NAMESPACE")
    protected String namespace;
    @Injection(name="SCHEMA_RECORD_NAME")
    protected String recordName;
    @Injection(name="SCHEMA_DOC_VALUE")
    protected String docValue;
    @Injection(name="OVERRIDE_OUTPUT")
    protected boolean overrideOutput;

    public void setDefault() {
    }

    public boolean isOverrideOutput() {
        return this.overrideOutput;
    }

    public void setOverrideOutput(boolean overrideOutput) {
        this.overrideOutput = overrideOutput;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<AvroOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<AvroOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public boolean isDateInFileName() {
        return this.dateInFileName;
    }

    public void setDateInFileName(boolean dateInFileName) {
        this.dateInFileName = dateInFileName;
    }

    public boolean isTimeInFileName() {
        return this.timeInFileName;
    }

    public void setTimeInFileName(boolean timeInFileName) {
        this.timeInFileName = timeInFileName;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)FILE_NAME);
            String override = XMLHandler.getTagValue((Node)stepnode, (String)"overrideOutput");
            this.overrideOutput = override != null && override.length() > 0 ? "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"overrideOutput")) : true;
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<AvroOutputField> avroOutputFields = new ArrayList<AvroOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                AvroOutputField outputField = new AvroOutputField();
                outputField.setFormatFieldName(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                outputField.setPentahoFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                outputField.setFormatType(AvroTypeConverter.convertToAvroType(XMLHandler.getTagValue((Node)fnode, (String)"type")));
                outputField.setPrecision(XMLHandler.getTagValue((Node)fnode, (String)PRECISION));
                outputField.setScale(XMLHandler.getTagValue((Node)fnode, (String)SCALE));
                outputField.setAllowNull(XMLHandler.getTagValue((Node)fnode, (String)NULLABLE));
                outputField.setDefaultValue(XMLHandler.getTagValue((Node)fnode, (String)DEFAULT));
                avroOutputFields.add(outputField);
            }
            this.outputFields = avroOutputFields;
            this.compressionType = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            this.dateTimeFormat = XMLHandler.getTagValue((Node)stepnode, (String)"dateTimeFormat");
            this.dateInFileName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dateInFileName"));
            this.timeInFileName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"timeInFileName"));
            this.schemaFilename = XMLHandler.getTagValue((Node)stepnode, (String)"schemaFilename");
            this.namespace = XMLHandler.getTagValue((Node)stepnode, (String)"namespace");
            this.docValue = XMLHandler.getTagValue((Node)stepnode, (String)"docValue");
            this.recordName = XMLHandler.getTagValue((Node)stepnode, (String)"recordName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(800);
        String INDENT = "    ";
        retval.append("    ").append(XMLHandler.addTagValue((String)FILE_NAME, (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"overrideOutput", (boolean)this.overrideOutput));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.size(); ++i) {
            AvroOutputField field = this.outputFields.get(i);
            if (field.getPentahoFieldName() == null || field.getPentahoFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)"path", (String)field.getFormatFieldName()));
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)"name", (String)field.getPentahoFieldName()));
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)"type", (int)field.getAvroType().getId()));
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)PRECISION, (int)field.getPrecision()));
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)SCALE, (int)field.getScale()));
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)NULLABLE, (boolean)field.getAllowNull()));
            retval.append(SPACES_8).append(XMLHandler.addTagValue((String)DEFAULT, (String)field.getDefaultValue()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"compression", (String)this.compressionType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateTimeFormat", (String)this.dateTimeFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateInFileName", (boolean)this.dateInFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timeInFileName", (boolean)this.timeInFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaFilename", (String)this.schemaFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"namespace", (String)this.namespace));
        retval.append("    ").append(XMLHandler.addTagValue((String)"docValue", (String)this.docValue));
        retval.append("    ").append(XMLHandler.addTagValue((String)"recordName", (String)this.recordName));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId stepId, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(stepId, FILE_NAME);
            String override = rep.getStepAttributeString(stepId, "overrideOutput");
            this.overrideOutput = override != null && override.length() > 0 ? rep.getStepAttributeBoolean(stepId, "overrideOutput") : true;
            int nrfields = rep.countNrStepAttributes(stepId, "type");
            ArrayList<AvroOutputField> avroOutputFields = new ArrayList<AvroOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                AvroOutputField outputField = new AvroOutputField();
                outputField.setFormatFieldName(rep.getStepAttributeString(stepId, i, "path"));
                outputField.setPentahoFieldName(rep.getStepAttributeString(stepId, i, "name"));
                outputField.setFormatType(AvroTypeConverter.convertToAvroType(rep.getStepAttributeString(stepId, i, "type")));
                outputField.setPrecision(rep.getStepAttributeString(stepId, i, PRECISION));
                outputField.setScale(rep.getStepAttributeString(stepId, i, SCALE));
                outputField.setAllowNull(rep.getStepAttributeString(stepId, i, NULLABLE));
                outputField.setDefaultValue(rep.getStepAttributeString(stepId, i, DEFAULT));
                avroOutputFields.add(outputField);
            }
            this.outputFields = avroOutputFields;
            this.compressionType = rep.getStepAttributeString(stepId, "compression");
            this.dateTimeFormat = rep.getStepAttributeString(stepId, "dateTimeFormat");
            this.dateInFileName = rep.getStepAttributeBoolean(stepId, "dateInFileName");
            this.timeInFileName = rep.getStepAttributeBoolean(stepId, "timeInFileName");
            this.schemaFilename = rep.getStepAttributeString(stepId, "schemaFilename");
            this.namespace = rep.getStepAttributeString(stepId, "namespace");
            this.docValue = rep.getStepAttributeString(stepId, "docValue");
            this.recordName = rep.getStepAttributeString(stepId, "recordName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId transformationId, ObjectId stepId) throws KettleException {
        try {
            rep.saveStepAttribute(transformationId, stepId, FILE_NAME, this.filename);
            rep.saveStepAttribute(transformationId, stepId, "overrideOutput", this.overrideOutput);
            for (int i = 0; i < this.outputFields.size(); ++i) {
                AvroOutputField field = this.outputFields.get(i);
                rep.saveStepAttribute(transformationId, stepId, i, "path", field.getFormatFieldName());
                rep.saveStepAttribute(transformationId, stepId, i, "name", field.getPentahoFieldName());
                rep.saveStepAttribute(transformationId, stepId, i, "type", (long)field.getAvroType().getId());
                rep.saveStepAttribute(transformationId, stepId, i, PRECISION, (long)field.getPrecision());
                rep.saveStepAttribute(transformationId, stepId, i, SCALE, (long)field.getScale());
                rep.saveStepAttribute(transformationId, stepId, i, NULLABLE, Boolean.toString(field.getAllowNull()));
                rep.saveStepAttribute(transformationId, stepId, i, DEFAULT, field.getDefaultValue());
            }
            super.saveRep(rep, metaStore, transformationId, stepId);
            rep.saveStepAttribute(transformationId, stepId, "compression", this.compressionType);
            rep.saveStepAttribute(transformationId, stepId, "dateTimeFormat", this.dateTimeFormat);
            rep.saveStepAttribute(transformationId, stepId, "dateInFileName", this.dateInFileName);
            rep.saveStepAttribute(transformationId, stepId, "timeInFileName", this.timeInFileName);
            rep.saveStepAttribute(transformationId, stepId, "schemaFilename", this.schemaFilename);
            rep.saveStepAttribute(transformationId, stepId, "namespace", this.namespace);
            rep.saveStepAttribute(transformationId, stepId, "docValue", this.docValue);
            rep.saveStepAttribute(transformationId, stepId, "recordName", this.recordName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for stepId=" + stepId, (Throwable)e);
        }
    }

    public void resolve() {
        FileObject fileObject;
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.schemaFilename != null && !this.schemaFilename.isEmpty()) {
            try {
                String realSchemaFilename = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.schemaFilename);
                fileObject = KettleVFS.getFileObject((String)realSchemaFilename);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.schemaFilename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getSchemaFilename() {
        return this.schemaFilename;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getDocValue() {
        return this.docValue;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public String getCompressionType() {
        return StringUtil.isVariable((String)this.compressionType) ? this.compressionType : this.getCompressionType(null).toString();
    }

    public void setCompressionType(String value) {
        this.compressionType = StringUtil.isVariable((String)value) ? value : AvroOutputMetaBase.parseFromToString(value, CompressionType.values(), CompressionType.NONE).name();
    }

    public CompressionType getCompressionType(VariableSpace vspace) {
        return this.parseReplace(this.compressionType, vspace, this::findCompressionType, CompressionType.NONE);
    }

    private CompressionType findCompressionType(String str) {
        try {
            return CompressionType.valueOf(str);
        }
        catch (Exception ex) {
            return AvroOutputMetaBase.parseFromToString(str, CompressionType.values(), CompressionType.NONE);
        }
    }

    public String[] getCompressionTypes() {
        return AvroOutputMetaBase.getStrings(CompressionType.values());
    }

    protected static <T> String[] getStrings(T[] objects) {
        String[] names = new String[objects.length];
        int i = 0;
        for (T obj : objects) {
            names[i++] = obj.toString();
        }
        return names;
    }

    protected static <T> T parseFromToString(String str, T[] values, T defaultValue) {
        if (!Utils.isEmpty((CharSequence)str)) {
            for (T type : values) {
                if (!str.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
        }
        return defaultValue;
    }

    private <T> T parseReplace(String value, VariableSpace vspace, Function<String, T> parser, T defaultValue) {
        String replaced;
        String string = replaced = vspace != null ? vspace.environmentSubstitute(value) : value;
        if (!Utils.isEmpty((CharSequence)replaced)) {
            try {
                return parser.apply(replaced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String constructOutputFilename(String file) {
        return file.endsWith(".avro") ? this.constructSingleOutputFilename(file) : this.constructDirectoryOutputFilename(file);
    }

    private String appendTimestampsToFile(String name) {
        if (this.dateTimeFormat != null && !this.dateTimeFormat.isEmpty()) {
            String dateTimeFormatPattern = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.dateTimeFormat);
            name = name + new SimpleDateFormat(dateTimeFormatPattern).format(new Date());
        } else {
            if (this.dateInFileName) {
                name = name + '_' + new SimpleDateFormat("yyyyMMdd").format(new Date());
            }
            if (this.timeInFileName) {
                name = name + '_' + new SimpleDateFormat("HHmmss").format(new Date());
            }
        }
        return name;
    }

    private String constructDirectoryOutputFilename(String file) {
        if (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
        }
        return this.appendTimestampsToFile(file) + "/";
    }

    private String constructSingleOutputFilename(String file) {
        int endIndex = file.lastIndexOf(46);
        String name = endIndex > 0 ? file.substring(0, endIndex) : file;
        String extension = endIndex <= 0 ? "" : file.substring(endIndex, file.length());
        return this.appendTimestampsToFile(name) + extension;
    }

    private static String getMsg(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    static /* synthetic */ String access$000(String x0) {
        return AvroOutputMetaBase.getMsg(x0);
    }

    protected static class FieldNames {
        public static final String COMPRESSION = "compression";
        public static final String SCHEMA_FILENAME = "schemaFilename";
        public static final String OVERRIDE_OUTPUT = "overrideOutput";
        public static final String RECORD_NAME = "recordName";
        public static final String DOC_VALUE = "docValue";
        public static final String NAMESPACE = "namespace";
        public static final String DATE_IN_FILE_NAME = "dateInFileName";
        public static final String TIME_IN_FILE_NAME = "timeInFileName";
        public static final String DATE_FORMAT = "dateTimeFormat";

        private FieldNames() {
            throw new IllegalStateException("Utility class");
        }
    }

    public static enum CompressionType {
        NONE(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.NONE")),
        DEFLATE(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.DEFLATE")),
        SNAPPY(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.SNAPPY"));

        private final String name;

        private CompressionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

