/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.sqoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.pentaho.big.data.kettle.plugins.job.BlockableJobConfig;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.Password;
import org.pentaho.big.data.kettle.plugins.job.PropertyEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.ArgumentWrapper;
import org.pentaho.big.data.kettle.plugins.sqoop.CommandLineArgument;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.util.AbstractModelList;
import org.w3c.dom.Node;

public abstract class SqoopConfig
extends BlockableJobConfig
implements XulEventSource,
Cloneable {
    public static final String NAMENODE_HOST = "namenodeHost";
    public static final String NAMENODE_PORT = "namenodePort";
    public static final String SHIM_IDENTIFIER = "shimIdentifier";
    public static final String JOBTRACKER_HOST = "jobtrackerHost";
    public static final String JOBTRACKER_PORT = "jobtrackerPort";
    public static final String DATABASE = "database";
    public static final String SCHEMA = "schema";
    public static final String CONNECT = "connect";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String VERBOSE = "verbose";
    public static final String CONNECTION_MANAGER = "connectionManager";
    public static final String DRIVER = "driver";
    public static final String CONNECTION_PARAM_FILE = "connectionParamFile";
    public static final String HADOOP_HOME = "hadoopHome";
    public static final String ENCLOSED_BY = "enclosedBy";
    public static final String ESCAPED_BY = "escapedBy";
    public static final String FIELDS_TERMINATED_BY = "fieldsTerminatedBy";
    public static final String LINES_TERMINATED_BY = "linesTerminatedBy";
    public static final String OPTIONALLY_ENCLOSED_BY = "optionallyEnclosedBy";
    public static final String MYSQL_DELIMITERS = "mysqlDelimiters";
    public static final String INPUT_ENCLOSED_BY = "inputEnclosedBy";
    public static final String INPUT_ESCAPED_BY = "inputEscapedBy";
    public static final String INPUT_FIELDS_TERMINATED_BY = "inputFieldsTerminatedBy";
    public static final String INPUT_LINES_TERMINATED_BY = "inputLinesTerminatedBy";
    public static final String INPUT_OPTIONALLY_ENCLOSED_BY = "inputOptionallyEnclosedBy";
    public static final String BIN_DIR = "binDir";
    public static final String CLASS_NAME = "className";
    public static final String JAR_FILE = "jarFile";
    public static final String OUTDIR = "outdir";
    public static final String PACKAGE_NAME = "packageName";
    public static final String MAP_COLUMN_JAVA = "mapColumnJava";
    public static final String TABLE = "table";
    public static final String NUM_MAPPERS = "numMappers";
    public static final String COMMAND_LINE = "commandLine";
    public static final String MODE = "mode";
    public static final String HADOOP_MAPRED_HOME = "hadoopMapredHome";
    public static final String PASSWORD_ALIAS = "passwordAlias";
    public static final String PASSWORD_FILE = "passwordFile";
    public static final String RELAXED_ISOLATION = "relaxedIsolation";
    public static final String SKIP_DIST_CACHE = "skipDistCache";
    public static final String MAPREDUCE_JOB_NAME = "mapreduceJobName";
    public static final String VALIDATE = "validate";
    public static final String VALIDATION_FAILURE_HANDLER = "validationFailureHandler";
    public static final String VALIDATION_THRESHOLD = "validationThreshold";
    public static final String VALIDATOR = "validator";
    public static final String HCATALOG_DATABASE = "hcatalogDatabase";
    public static final String HCATALOG_HOME = "hcatalogHome";
    public static final String HCATALOG_PARTITION_KEYS = "hcatalogPartitionKeys";
    public static final String HCATALOG_PARTITION_VALUES = "hcatalogPartitionValues";
    public static final String HCATALOG_TABLE = "hcatalogTable";
    public static final String HIVE_HOME = "hiveHome";
    public static final String HIVE_PARTITION_KEY = "hivePartitionKey";
    public static final String HIVE_PARTITION_VALUE = "hivePartitionValue";
    public static final String MAP_COLUMN_HIVE = "mapColumnHive";
    public static final String INPUT_NULL_STRING = "inputNullString";
    public static final String INPUT_NULL_NON_STRING = "inputNullNonString";
    public static final String NULL_STRING = "nullString";
    public static final String NULL_NON_STRING = "nullNonString";
    public static final String FILES = "files";
    public static final String LIBJARS = "libjars";
    public static final String ARCHIVES = "archives";
    private String database;
    private String schema;
    private transient String connectFromAdvanced;
    private transient String usernameFromAdvanced;
    private transient String passwordFromAdvanced;
    @CommandLineArgument(name="hadoop-mapred-home")
    private String hadoopMapredHome;
    @CommandLineArgument(name="password-alias")
    private String passwordAlias;
    @CommandLineArgument(name="password-file")
    private String passwordFile;
    @CommandLineArgument(name="relaxed-isolation", flag=true)
    private String relaxedIsolation;
    @CommandLineArgument(name="skip-dist-cache", flag=true)
    private String skipDistCache;
    @CommandLineArgument(name="mapreduce-job-name")
    private String mapreduceJobName;
    @CommandLineArgument(name="validate", flag=true)
    private String validate;
    @CommandLineArgument(name="validation-failurehandler")
    private String validationFailureHandler;
    @CommandLineArgument(name="validation-threshold")
    private String validationThreshold;
    @CommandLineArgument(name="validator")
    private String validator;
    @CommandLineArgument(name="hcatalog-database")
    private String hcatalogDatabase;
    @CommandLineArgument(name="hcatalog-home")
    private String hcatalogHome;
    @CommandLineArgument(name="hcatalog-partition-keys")
    private String hcatalogPartitionKeys;
    @CommandLineArgument(name="hcatalog-partition-values")
    private String hcatalogPartitionValues;
    @CommandLineArgument(name="hcatalog-table")
    private String hcatalogTable;
    @CommandLineArgument(name="hive-home")
    private String hiveHome;
    @CommandLineArgument(name="hive-partition-key")
    private String hivePartitionKey;
    @CommandLineArgument(name="hive-partition-value")
    private String hivePartitionValue;
    @CommandLineArgument(name="map-column-hive")
    private String mapColumnHive;
    @CommandLineArgument(name="input-null-string")
    private String inputNullString;
    @CommandLineArgument(name="input-null-non-string")
    private String inputNullNonString;
    @CommandLineArgument(name="null-string")
    private String nullString;
    @CommandLineArgument(name="null-non-string")
    private String nullNonString;
    @CommandLineArgument(name="files", order=50, prefix="-")
    private String files;
    @CommandLineArgument(name="libjars", order=50, prefix="-")
    private String libjars;
    @CommandLineArgument(name="archives", order=50, prefix="-")
    private String archives;
    private String mode;
    @CommandLineArgument(name="connect")
    private String connect;
    @CommandLineArgument(name="connection-manager")
    private String connectionManager;
    @CommandLineArgument(name="driver")
    private String driver;
    @CommandLineArgument(name="username")
    private String username;
    @CommandLineArgument(name="password")
    @Password
    private String password;
    @CommandLineArgument(name="verbose", flag=true)
    private String verbose;
    @CommandLineArgument(name="connection-param-file")
    private String connectionParamFile;
    @CommandLineArgument(name="hadoop-home")
    private String hadoopHome;
    @CommandLineArgument(name="enclosed-by")
    private String enclosedBy;
    @CommandLineArgument(name="escaped-by")
    private String escapedBy;
    @CommandLineArgument(name="fields-terminated-by")
    private String fieldsTerminatedBy;
    @CommandLineArgument(name="lines-terminated-by")
    private String linesTerminatedBy;
    @CommandLineArgument(name="optionally-enclosed-by")
    private String optionallyEnclosedBy;
    @CommandLineArgument(name="mysql-delimiters", flag=true)
    private String mysqlDelimiters;
    @CommandLineArgument(name="input-enclosed-by")
    private String inputEnclosedBy;
    @CommandLineArgument(name="input-escaped-by")
    private String inputEscapedBy;
    @CommandLineArgument(name="input-fields-terminated-by")
    private String inputFieldsTerminatedBy;
    @CommandLineArgument(name="input-lines-terminated-by")
    private String inputLinesTerminatedBy;
    @CommandLineArgument(name="input-optionally-enclosed-by")
    private String inputOptionallyEnclosedBy;
    @CommandLineArgument(name="bindir")
    private String binDir;
    @CommandLineArgument(name="class-name")
    private String className;
    @CommandLineArgument(name="jar-file")
    private String jarFile;
    @CommandLineArgument(name="outdir")
    private String outdir;
    @CommandLineArgument(name="package-name")
    private String packageName;
    @CommandLineArgument(name="map-column-java")
    private String mapColumnJava;
    @CommandLineArgument(name="table")
    private String table;
    @CommandLineArgument(name="num-mappers")
    private String numMappers;
    private String commandLine;
    private String clusterName;
    private transient NamedCluster namedCluster;
    private AbstractModelList<PropertyEntry> customArguments;

    public AbstractModelList<ArgumentWrapper> getAdvancedArgumentsList() {
        AbstractModelList items = new AbstractModelList();
        items.addAll(SqoopUtils.findAllArguments(this));
        try {
            items.add((Object)new ArgumentWrapper(NAMENODE_HOST, BaseMessages.getString(this.getClass(), (String)"NamenodeHost.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getNamenodeHost", new Class[0]), this.getClass().getMethod("setNamenodeHost", String.class)));
            items.add((Object)new ArgumentWrapper(NAMENODE_PORT, BaseMessages.getString(this.getClass(), (String)"NamenodePort.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getNamenodePort", new Class[0]), this.getClass().getMethod("setNamenodePort", String.class)));
            items.add((Object)new ArgumentWrapper(SHIM_IDENTIFIER, BaseMessages.getString(this.getClass(), (String)"ShimIdentifier.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getShimIdentifier", new Class[0]), this.getClass().getMethod("setShimIdentifier", String.class)));
            items.add((Object)new ArgumentWrapper(JOBTRACKER_HOST, BaseMessages.getString(this.getClass(), (String)"JobtrackerHost.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getJobtrackerHost", new Class[0]), this.getClass().getMethod("setJobtrackerHost", String.class)));
            items.add((Object)new ArgumentWrapper(JOBTRACKER_PORT, BaseMessages.getString(this.getClass(), (String)"JobtrackerPort.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getJobtrackerPort", new Class[0]), this.getClass().getMethod("setJobtrackerPort", String.class)));
            items.add((Object)new ArgumentWrapper("blockingExecution", BaseMessages.getString(this.getClass(), (String)"BlockingExecution.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getBlockingExecution", new Class[0]), this.getClass().getMethod("setBlockingExecution", String.class)));
            items.add((Object)new ArgumentWrapper("blockingPollingInterval", BaseMessages.getString(this.getClass(), (String)"BlockingPollingInterval.Label", (String[])new String[0]), false, "", 0, this, this.getClass().getMethod("getBlockingPollingInterval", new Class[0]), this.getClass().getMethod("setBlockingPollingInterval", String.class)));
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        return items;
    }

    public NamedCluster getNamedCluster() {
        if (this.namedCluster == null) {
            this.namedCluster = this.createClusterTemplate();
        }
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = this.createClusterTemplate();
        if (namedCluster != null) {
            this.setClusterName(namedCluster.getName());
            this.namedCluster.replaceMeta(namedCluster);
        }
    }

    protected abstract NamedCluster createClusterTemplate();

    public SqoopConfig clone() {
        return (SqoopConfig)super.clone();
    }

    public void setConnectionInfo(String database, String connect, String username, String password) {
        this.database = database;
        this.connect = connect;
        this.username = username;
        this.password = password;
    }

    public void copyConnectionInfoFromAdvanced() {
        this.database = null;
        this.connect = this.getConnectFromAdvanced();
        this.username = this.getUsernameFromAdvanced();
        this.password = this.getPasswordFromAdvanced();
    }

    public void copyConnectionInfoToAdvanced() {
        this.setConnectFromAdvanced(this.getConnect());
        this.setUsernameFromAdvanced(this.getUsername());
        this.setPasswordFromAdvanced(this.getPassword());
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = this.propertyChange(DATABASE, this.database, database);
    }

    protected String propertyChange(String propertyName, String oldValue, String newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        return newValue;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = this.propertyChange(SCHEMA, this.schema, schema);
    }

    public String getConnect() {
        return this.connect;
    }

    public void setConnect(String connect) {
        this.connect = this.propertyChange(CONNECT, this.connect, connect);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = this.propertyChange(USERNAME, this.username, username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = this.propertyChange(PASSWORD, this.password, password);
    }

    public String getConnectFromAdvanced() {
        return this.connectFromAdvanced;
    }

    public void setConnectFromAdvanced(String connectFromAdvanced) {
        this.connectFromAdvanced = connectFromAdvanced;
    }

    public String getUsernameFromAdvanced() {
        return this.usernameFromAdvanced;
    }

    public void setUsernameFromAdvanced(String usernameFromAdvanced) {
        this.usernameFromAdvanced = usernameFromAdvanced;
    }

    public String getPasswordFromAdvanced() {
        return this.passwordFromAdvanced;
    }

    public void setPasswordFromAdvanced(String passwordFromAdvanced) {
        this.passwordFromAdvanced = passwordFromAdvanced;
    }

    public String getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(String connectionManager) {
        this.connectionManager = this.propertyChange(CONNECTION_MANAGER, this.connectionManager, connectionManager);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = this.propertyChange(DRIVER, this.driver, driver);
    }

    public String getVerbose() {
        return this.verbose;
    }

    public void setVerbose(String verbose) {
        this.verbose = this.propertyChange(VERBOSE, this.verbose, verbose);
    }

    public String getConnectionParamFile() {
        return this.connectionParamFile;
    }

    public void setConnectionParamFile(String connectionParamFile) {
        this.connectionParamFile = this.propertyChange(CONNECTION_PARAM_FILE, this.connectionParamFile, connectionParamFile);
    }

    public String getHadoopHome() {
        return this.hadoopHome;
    }

    public void setHadoopHome(String hadoopHome) {
        this.hadoopHome = this.propertyChange(HADOOP_HOME, this.hadoopHome, hadoopHome);
    }

    public String getEnclosedBy() {
        return this.enclosedBy;
    }

    public void setEnclosedBy(String enclosedBy) {
        this.enclosedBy = this.propertyChange(ENCLOSED_BY, this.enclosedBy, enclosedBy);
    }

    public String getEscapedBy() {
        return this.escapedBy;
    }

    public void setEscapedBy(String escapedBy) {
        this.escapedBy = this.propertyChange(ESCAPED_BY, this.escapedBy, escapedBy);
    }

    public String getFieldsTerminatedBy() {
        return this.fieldsTerminatedBy;
    }

    public void setFieldsTerminatedBy(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = this.propertyChange(FIELDS_TERMINATED_BY, this.fieldsTerminatedBy, fieldsTerminatedBy);
    }

    public String getLinesTerminatedBy() {
        return this.linesTerminatedBy;
    }

    public void setLinesTerminatedBy(String linesTerminatedBy) {
        this.linesTerminatedBy = this.propertyChange(LINES_TERMINATED_BY, this.linesTerminatedBy, linesTerminatedBy);
    }

    public String getOptionallyEnclosedBy() {
        return this.optionallyEnclosedBy;
    }

    public void setOptionallyEnclosedBy(String optionallyEnclosedBy) {
        this.optionallyEnclosedBy = this.propertyChange(OPTIONALLY_ENCLOSED_BY, this.optionallyEnclosedBy, optionallyEnclosedBy);
    }

    public String getMysqlDelimiters() {
        return this.mysqlDelimiters;
    }

    public void setMysqlDelimiters(String mysqlDelimiters) {
        this.mysqlDelimiters = this.propertyChange(MYSQL_DELIMITERS, this.mysqlDelimiters, mysqlDelimiters);
    }

    public String getInputEnclosedBy() {
        return this.inputEnclosedBy;
    }

    public void setInputEnclosedBy(String inputEnclosedBy) {
        this.inputEnclosedBy = this.propertyChange(INPUT_ENCLOSED_BY, this.inputEnclosedBy, inputEnclosedBy);
    }

    public String getInputEscapedBy() {
        return this.inputEscapedBy;
    }

    public void setInputEscapedBy(String inputEscapedBy) {
        this.inputEscapedBy = this.propertyChange(INPUT_ESCAPED_BY, this.inputEscapedBy, inputEscapedBy);
    }

    public String getInputFieldsTerminatedBy() {
        return this.inputFieldsTerminatedBy;
    }

    public void setInputFieldsTerminatedBy(String inputFieldsTerminatedBy) {
        this.inputFieldsTerminatedBy = this.propertyChange(INPUT_FIELDS_TERMINATED_BY, this.inputFieldsTerminatedBy, inputFieldsTerminatedBy);
    }

    public String getInputLinesTerminatedBy() {
        return this.inputLinesTerminatedBy;
    }

    public void setInputLinesTerminatedBy(String inputLinesTerminatedBy) {
        this.inputLinesTerminatedBy = this.propertyChange(INPUT_LINES_TERMINATED_BY, this.inputLinesTerminatedBy, inputLinesTerminatedBy);
    }

    public String getInputOptionallyEnclosedBy() {
        return this.inputOptionallyEnclosedBy;
    }

    public void setInputOptionallyEnclosedBy(String inputOptionallyEnclosedBy) {
        this.inputOptionallyEnclosedBy = this.propertyChange(INPUT_OPTIONALLY_ENCLOSED_BY, this.inputOptionallyEnclosedBy, inputOptionallyEnclosedBy);
    }

    public String getBinDir() {
        return this.binDir;
    }

    public void setBinDir(String binDir) {
        this.binDir = this.propertyChange(BIN_DIR, this.binDir, binDir);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = this.propertyChange(CLASS_NAME, this.className, className);
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = this.propertyChange(JAR_FILE, this.jarFile, jarFile);
    }

    public String getOutdir() {
        return this.outdir;
    }

    public void setOutdir(String outdir) {
        this.outdir = this.propertyChange(OUTDIR, this.outdir, outdir);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = this.propertyChange(PACKAGE_NAME, this.packageName, packageName);
    }

    public String getMapColumnJava() {
        return this.mapColumnJava;
    }

    public void setMapColumnJava(String mapColumnJava) {
        this.mapColumnJava = this.propertyChange(MAP_COLUMN_JAVA, this.mapColumnJava, mapColumnJava);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = this.propertyChange(TABLE, this.table, table);
    }

    public String getNumMappers() {
        return this.numMappers;
    }

    public void setNumMappers(String numMappers) {
        this.numMappers = this.propertyChange(NUM_MAPPERS, this.numMappers, numMappers);
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = this.propertyChange(COMMAND_LINE, this.commandLine, commandLine);
    }

    public String getMode() {
        return this.mode;
    }

    public JobEntryMode getModeAsEnum() {
        try {
            return JobEntryMode.valueOf((String)this.getMode());
        }
        catch (Exception ex) {
            return JobEntryMode.QUICK_SETUP;
        }
    }

    public void setMode(JobEntryMode mode) {
        this.setMode(mode.name());
    }

    public void setMode(String mode) {
        this.mode = this.propertyChange(MODE, this.mode, mode);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = this.propertyChange("clusterName", this.clusterName, clusterName);
    }

    public String getNamenodeHost() {
        return this.getNamedCluster().getHdfsHost();
    }

    public void setNamenodeHost(String namenodeHost) {
        this.getNamedCluster().setHdfsHost(this.propertyChange(NAMENODE_HOST, this.getNamenodeHost(), namenodeHost));
    }

    public String getShimIdentifier() {
        return this.getNamedCluster().getShimIdentifier();
    }

    public void setShimIdentifier(String shimIdentifier) {
        this.getNamedCluster().setShimIdentifier(this.propertyChange(SHIM_IDENTIFIER, this.getShimIdentifier(), shimIdentifier));
    }

    public String getNamenodePort() {
        return this.getNamedCluster().getHdfsPort();
    }

    public void setNamenodePort(String namenodePort) {
        this.getNamedCluster().setHdfsPort(this.propertyChange(NAMENODE_PORT, this.getNamenodePort(), namenodePort));
    }

    public String getJobtrackerHost() {
        return this.getNamedCluster().getJobTrackerHost();
    }

    public void setJobtrackerHost(String jobtrackerHost) {
        this.getNamedCluster().setJobTrackerHost(this.propertyChange(JOBTRACKER_HOST, this.getJobtrackerHost(), jobtrackerHost));
    }

    public String getJobtrackerPort() {
        return this.getNamedCluster().getJobTrackerPort();
    }

    public void setJobtrackerPort(String jobtrackerPort) {
        this.getNamedCluster().setJobTrackerPort(this.propertyChange(JOBTRACKER_PORT, this.getJobtrackerPort(), jobtrackerPort));
    }

    public String getHadoopMapredHome() {
        return this.hadoopMapredHome;
    }

    public void setHadoopMapredHome(String hadoopMapredHome) {
        this.hadoopMapredHome = this.propertyChange(HADOOP_MAPRED_HOME, this.hadoopMapredHome, hadoopMapredHome);
    }

    public String getPasswordAlias() {
        return this.passwordAlias;
    }

    public void setPasswordAlias(String passwordAlias) {
        this.passwordAlias = this.propertyChange(PASSWORD_ALIAS, this.passwordAlias, passwordAlias);
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = this.propertyChange(PASSWORD_FILE, this.passwordFile, passwordFile);
    }

    public String getRelaxedIsolation() {
        return this.relaxedIsolation;
    }

    public void setRelaxedIsolation(String relaxedIsolation) {
        this.relaxedIsolation = this.propertyChange(RELAXED_ISOLATION, this.relaxedIsolation, relaxedIsolation);
    }

    public String getSkipDistCache() {
        return this.skipDistCache;
    }

    public void setSkipDistCache(String skipDistCache) {
        this.skipDistCache = this.propertyChange(SKIP_DIST_CACHE, this.skipDistCache, skipDistCache);
    }

    public String getMapreduceJobName() {
        return this.mapreduceJobName;
    }

    public void setMapreduceJobName(String mapreduceJobName) {
        this.mapreduceJobName = this.propertyChange(MAPREDUCE_JOB_NAME, this.mapreduceJobName, mapreduceJobName);
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = this.propertyChange(VALIDATE, this.validate, validate);
    }

    public String getValidationFailureHandler() {
        return this.validationFailureHandler;
    }

    public void setValidationFailureHandler(String validationFailureHandler) {
        this.validationFailureHandler = this.propertyChange(VALIDATION_FAILURE_HANDLER, this.validationFailureHandler, validationFailureHandler);
    }

    public String getValidationThreshold() {
        return this.validationThreshold;
    }

    public void setValidationThreshold(String validationThreshold) {
        this.validationThreshold = this.propertyChange(VALIDATION_THRESHOLD, this.validationThreshold, validationThreshold);
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = this.propertyChange(VALIDATOR, this.validator, validator);
    }

    public String getHcatalogDatabase() {
        return this.hcatalogDatabase;
    }

    public void setHcatalogDatabase(String hcatalogDatabase) {
        this.hcatalogDatabase = this.propertyChange(HCATALOG_DATABASE, this.hcatalogDatabase, hcatalogDatabase);
    }

    public String getHcatalogHome() {
        return this.hcatalogHome;
    }

    public void setHcatalogHome(String hcatalogHome) {
        this.hcatalogHome = this.propertyChange(HCATALOG_HOME, this.hcatalogHome, hcatalogHome);
    }

    public String getHcatalogPartitionKeys() {
        return this.hcatalogPartitionKeys;
    }

    public void setHcatalogPartitionKeys(String hcatalogPartitionKeys) {
        this.hcatalogPartitionKeys = this.propertyChange(HCATALOG_PARTITION_KEYS, this.hcatalogPartitionKeys, hcatalogPartitionKeys);
    }

    public String getHcatalogPartitionValues() {
        return this.hcatalogPartitionValues;
    }

    public void setHcatalogPartitionValues(String hcatalogPartitionValues) {
        this.hcatalogPartitionValues = this.propertyChange(HCATALOG_PARTITION_VALUES, this.hcatalogPartitionValues, hcatalogPartitionValues);
    }

    public String getHcatalogTable() {
        return this.hcatalogTable;
    }

    public void setHcatalogTable(String hcatalogTable) {
        this.hcatalogTable = this.propertyChange(HCATALOG_TABLE, this.hcatalogTable, hcatalogTable);
    }

    public String getHiveHome() {
        return this.hiveHome;
    }

    public void setHiveHome(String hiveHome) {
        this.hiveHome = this.propertyChange(HIVE_HOME, this.hiveHome, hiveHome);
    }

    public String getHivePartitionKey() {
        return this.hivePartitionKey;
    }

    public void setHivePartitionKey(String hivePartitionKey) {
        this.hivePartitionKey = this.propertyChange(HIVE_PARTITION_KEY, this.hivePartitionKey, hivePartitionKey);
    }

    public String getHivePartitionValue() {
        return this.hivePartitionValue;
    }

    public void setHivePartitionValue(String hivePartitionValue) {
        this.hivePartitionValue = this.propertyChange(HIVE_PARTITION_VALUE, this.hivePartitionValue, hivePartitionValue);
    }

    public String getMapColumnHive() {
        return this.mapColumnHive;
    }

    public void setMapColumnHive(String mapColumnHive) {
        this.mapColumnHive = this.propertyChange(MAP_COLUMN_HIVE, this.mapColumnHive, mapColumnHive);
    }

    public String getInputNullString() {
        return this.inputNullString;
    }

    public void setInputNullString(String inputNullString) {
        this.inputNullString = this.propertyChange(INPUT_NULL_STRING, this.inputNullString, inputNullString);
    }

    public String getInputNullNonString() {
        return this.inputNullNonString;
    }

    public void setInputNullNonString(String inputNullNonString) {
        this.inputNullNonString = this.propertyChange(INPUT_NULL_NON_STRING, this.inputNullNonString, inputNullNonString);
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = this.propertyChange(NULL_STRING, this.nullString, nullString);
    }

    public String getNullNonString() {
        return this.nullNonString;
    }

    public void setNullNonString(String nullNonString) {
        this.nullNonString = this.propertyChange(NULL_NON_STRING, this.nullNonString, nullNonString);
    }

    public String getFiles() {
        return this.files;
    }

    public void setFiles(String files) {
        this.files = this.propertyChange(FILES, this.files, files);
    }

    public String getLibjars() {
        return this.libjars;
    }

    public void setLibjars(String libjars) {
        this.libjars = this.propertyChange(LIBJARS, this.libjars, libjars);
    }

    public String getArchives() {
        return this.archives;
    }

    public void setArchives(String archives) {
        this.archives = this.propertyChange(ARCHIVES, this.archives, archives);
    }

    public AbstractModelList<PropertyEntry> getCustomArguments() {
        if (this.customArguments == null) {
            this.customArguments = new AbstractModelList();
        }
        return this.customArguments;
    }

    public void setCustomArguments(AbstractModelList<PropertyEntry> customArguments) {
        this.customArguments = customArguments;
    }

    public void loadClusterConfig(Repository rep, ObjectId id) throws KettleException {
        this.setNamedCluster(null);
        this.setNamenodeHost(rep.getJobEntryAttributeString(id, NAMENODE_HOST));
        this.setNamenodePort(rep.getJobEntryAttributeString(id, NAMENODE_PORT));
        this.setShimIdentifier(rep.getJobEntryAttributeString(id, SHIM_IDENTIFIER));
        this.setJobtrackerHost(rep.getJobEntryAttributeString(id, JOBTRACKER_HOST));
        this.setJobtrackerPort(rep.getJobEntryAttributeString(id, JOBTRACKER_PORT));
    }

    public void loadClusterConfig(Node entrynode) {
        this.setNamedCluster(null);
        this.setNamenodeHost(XMLHandler.getTagValue((Node)entrynode, (String)NAMENODE_HOST));
        this.setNamenodePort(XMLHandler.getTagValue((Node)entrynode, (String)NAMENODE_PORT));
        this.setShimIdentifier(XMLHandler.getTagValue((Node)entrynode, (String)SHIM_IDENTIFIER));
        this.setJobtrackerHost(XMLHandler.getTagValue((Node)entrynode, (String)JOBTRACKER_HOST));
        this.setJobtrackerPort(XMLHandler.getTagValue((Node)entrynode, (String)JOBTRACKER_PORT));
    }

    public String getClusterXML() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : SqoopConfig.namedClusterProperties(this.getNamedCluster()).entrySet()) {
            builder.append(XMLHandler.addTagValue((String)entry.getKey(), (String)entry.getValue()));
        }
        return builder.toString();
    }

    public void saveClusterConfig(Repository rep, ObjectId id_job, JobEntryInterface jobEntry) throws KettleException {
        ObjectId objectId = jobEntry.getObjectId();
        for (Map.Entry<String, String> entry : SqoopConfig.namedClusterProperties(this.getNamedCluster()).entrySet()) {
            rep.saveJobEntryAttribute(id_job, objectId, entry.getKey(), entry.getValue());
        }
    }

    public boolean isAdvancedClusterConfigSet() {
        return Strings.isNullOrEmpty((String)this.getClusterName()) && this.ncPropertiesNotNullOrEmpty(this.getNamedCluster());
    }

    private static Map<String, String> namedClusterProperties(NamedCluster namedCluster) {
        return ImmutableMap.of((Object)NAMENODE_HOST, (Object)Strings.nullToEmpty((String)namedCluster.getHdfsHost()), (Object)NAMENODE_PORT, (Object)Strings.nullToEmpty((String)namedCluster.getHdfsPort()), (Object)SHIM_IDENTIFIER, (Object)Strings.nullToEmpty((String)namedCluster.getShimIdentifier()), (Object)JOBTRACKER_HOST, (Object)Strings.nullToEmpty((String)namedCluster.getJobTrackerHost()), (Object)JOBTRACKER_PORT, (Object)Strings.nullToEmpty((String)namedCluster.getJobTrackerPort()));
    }

    @VisibleForTesting
    boolean ncPropertiesNotNullOrEmpty(NamedCluster nc) {
        return !Strings.isNullOrEmpty((String)nc.getHdfsHost()) || !Strings.isNullOrEmpty((String)nc.getHdfsPort()) || !Strings.isNullOrEmpty((String)nc.getJobTrackerHost()) || !Strings.isNullOrEmpty((String)nc.getJobTrackerPort());
    }
}

