/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class QuotaSettings {
    private final String userName;
    private final String namespace;
    private final TableName tableName;

    protected QuotaSettings(String userName, TableName tableName, String namespace) {
        this.userName = userName;
        this.namespace = namespace;
        this.tableName = tableName;
    }

    public abstract QuotaType getQuotaType();

    public String getUserName() {
        return this.userName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @InterfaceAudience.Private
    public static QuotaSettings buildFromProto(MasterProtos.SetQuotaRequest request) {
        String username = null;
        if (request.hasUserName()) {
            username = request.getUserName();
        }
        TableName tableName = null;
        if (request.hasTableName()) {
            tableName = ProtobufUtil.toTableName(request.getTableName());
        }
        String namespace = null;
        if (request.hasNamespace()) {
            namespace = request.getNamespace();
        }
        if (request.hasBypassGlobals()) {
            if (request.hasSpaceLimit() || request.hasThrottle()) {
                throw new IllegalStateException("SetQuotaRequest has multiple limits: " + TextFormat.shortDebugString((MessageOrBuilder)request));
            }
            return new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(username, tableName, namespace, request.getBypassGlobals());
        }
        if (request.hasSpaceLimit()) {
            if (request.hasThrottle()) {
                throw new IllegalStateException("SetQuotaRequests has multiple limits: " + TextFormat.shortDebugString((MessageOrBuilder)request));
            }
            if (!request.getSpaceLimit().hasQuota()) {
                throw new IllegalArgumentException("SpaceLimitRequest is missing the expected SpaceQuota.");
            }
            return QuotaSettingsFactory.fromSpace(tableName, namespace, request.getSpaceLimit().getQuota());
        }
        if (request.hasThrottle()) {
            return new ThrottleSettings(username, tableName, namespace, request.getThrottle());
        }
        throw new IllegalStateException("Unhandled SetRequestRequest state");
    }

    @InterfaceAudience.Private
    public static MasterProtos.SetQuotaRequest buildSetQuotaRequestProto(QuotaSettings settings) {
        MasterProtos.SetQuotaRequest.Builder builder = MasterProtos.SetQuotaRequest.newBuilder();
        if (settings.getUserName() != null) {
            builder.setUserName(settings.getUserName());
        }
        if (settings.getTableName() != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(settings.getTableName()));
        }
        if (settings.getNamespace() != null) {
            builder.setNamespace(settings.getNamespace());
        }
        settings.setupSetQuotaRequest(builder);
        return builder.build();
    }

    @InterfaceAudience.Private
    protected abstract void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder var1);

    protected String ownerToString() {
        StringBuilder builder = new StringBuilder();
        if (this.userName != null) {
            builder.append("USER => '");
            builder.append(this.userName);
            builder.append("', ");
        }
        if (this.tableName != null) {
            builder.append("TABLE => '");
            builder.append(this.tableName.toString());
            builder.append("', ");
        }
        if (this.namespace != null) {
            builder.append("NAMESPACE => '");
            builder.append(this.namespace);
            builder.append("', ");
        }
        return builder.toString();
    }

    protected static String sizeToString(long size) {
        if (size >= 0x4000000000000L) {
            return String.format("%dP", size / 0x4000000000000L);
        }
        if (size >= 0x10000000000L) {
            return String.format("%dT", size / 0x10000000000L);
        }
        if (size >= 0x40000000L) {
            return String.format("%dG", size / 0x40000000L);
        }
        if (size >= 0x100000L) {
            return String.format("%dM", size / 0x100000L);
        }
        if (size >= 1024L) {
            return String.format("%dK", size / 1024L);
        }
        return String.format("%dB", size);
    }

    protected static String timeToString(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "nsec";
            }
            case MICROSECONDS: {
                return "usec";
            }
            case MILLISECONDS: {
                return "msec";
            }
            case SECONDS: {
                return "sec";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hour";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + (Object)((Object)timeUnit));
    }

    abstract QuotaSettings merge(QuotaSettings var1) throws IOException;

    void validateQuotaTarget(QuotaSettings mergee) {
        if (!Objects.equals(this.getUserName(), mergee.getUserName())) {
            throw new IllegalArgumentException("Mismatched user names on settings to merge");
        }
        if (!Objects.equals(this.getTableName(), mergee.getTableName())) {
            throw new IllegalArgumentException("Mismatched table names on settings to merge");
        }
        if (!Objects.equals(this.getNamespace(), mergee.getNamespace())) {
            throw new IllegalArgumentException("Mismatched namespace on settings to merge");
        }
    }
}

