/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterService;

public class NamedClusterResolver {
    private static final LogChannelInterface LOG = LogChannel.GENERAL;

    private NamedClusterResolver() {
    }

    public static NamedCluster resolveNamedCluster(NamedClusterService namedClusterService, MetastoreLocatorOsgi metaStoreService, String fileName) {
        NamedCluster namedCluster = null;
        Optional<URI> uri = NamedClusterResolver.fileUri(fileName);
        if (uri.isPresent()) {
            String scheme = uri.get().getScheme();
            String hostName = uri.get().getHost();
            namedCluster = scheme != null && scheme.equals("hc") ? namedClusterService.getNamedClusterByName(hostName, metaStoreService.getMetastore()) : namedClusterService.getNamedClusterByHost(hostName, metaStoreService.getMetastore());
        }
        return namedCluster;
    }

    private static Optional<URI> fileUri(String fileName) {
        try {
            return Optional.of(new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.logDebug(String.format("Couldn't parse %s as a URI.", fileName));
            return Optional.empty();
        }
    }
}

