/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.orc.input;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.impl.orc.input.OrcInputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.orc.input.OrcInputMeta;
import org.pentaho.big.data.kettle.plugins.formats.orc.input.OrcInputMetaBase;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoOrcInputFormat;

public class OrcInput
extends BaseFileInputStep<OrcInputMeta, OrcInputData> {
    public static final long SPLIT_SIZE = 0x8000000L;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public OrcInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (OrcInputMeta)smi;
        this.data = (OrcInputData)sdi;
        try {
            if (((OrcInputData)this.data).input == null || ((OrcInputData)this.data).reader == null || ((OrcInputData)this.data).rowIterator == null) {
                FormatService formatService = this.getFormatService();
                if (((OrcInputMeta)this.meta).inputFiles == null || ((OrcInputMeta)this.meta).getFilename() == null || ((OrcInputMeta)this.meta).getFilename().length() == 0) {
                    throw new KettleException("No input files defined");
                }
                ((OrcInputData)this.data).input = (IPentahoOrcInputFormat)formatService.createInputFormat(IPentahoOrcInputFormat.class, this.getNamedCluster());
                String inputFileName = OrcInput.getKettleVFSFileName(((OrcInputMeta)this.meta).getParentStepMeta().getParentTransMeta().environmentSubstitute(((OrcInputMeta)this.meta).getFilename()));
                ((OrcInputData)this.data).input.setInputFile(inputFileName);
                ((OrcInputData)this.data).input.setSchema(OrcInput.createSchemaFromMeta((OrcInputMetaBase)this.meta));
                ((OrcInputData)this.data).reader = ((OrcInputData)this.data).input.createRecordReader(null);
                ((OrcInputData)this.data).rowIterator = ((OrcInputData)this.data).reader.iterator();
            }
            if (((OrcInputData)this.data).rowIterator.hasNext()) {
                RowMetaAndData row = ((OrcInputData)this.data).rowIterator.next();
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            ((OrcInputData)this.data).reader.close();
            ((OrcInputData)this.data).reader = null;
            ((OrcInputData)this.data).input = null;
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    private NamedCluster getNamedCluster() {
        return ((OrcInputMeta)this.meta).getNamedCluster(this.environmentSubstitute(((OrcInputMeta)this.meta).getFilename()));
    }

    private FormatService getFormatService() throws KettleException {
        FormatService formatService;
        try {
            formatService = (FormatService)this.namedClusterServiceLocator.getService(this.getNamedCluster(), FormatService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        return formatService;
    }

    protected boolean init() {
        return true;
    }

    protected IBaseFileInputReader createReader(OrcInputMeta meta, OrcInputData data, FileObject file) throws Exception {
        return null;
    }

    public static List<IOrcInputField> retrieveSchema(NamedClusterServiceLocator namedClusterServiceLocator, NamedCluster namedCluster, String dataPath) throws Exception {
        FormatService formatService = (FormatService)namedClusterServiceLocator.getService(namedCluster, FormatService.class);
        IPentahoOrcInputFormat in = (IPentahoOrcInputFormat)formatService.createInputFormat(IPentahoOrcInputFormat.class, namedCluster);
        in.setInputFile(OrcInput.getKettleVFSFileName(dataPath));
        return in.readSchema();
    }

    public static List<IOrcInputField> createSchemaFromMeta(OrcInputMetaBase meta) {
        return Arrays.asList(meta.getInputFields());
    }

    public static String getKettleVFSFileName(String path) throws KettleFileException {
        String inputFileName = path;
        FileObject inputFileObject = KettleVFS.getFileObject((String)path);
        if (AliasedFileObject.isAliasedFile((FileObject)inputFileObject)) {
            inputFileName = ((AliasedFileObject)inputFileObject).getOriginalURIString();
        }
        return inputFileName;
    }
}

