/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.orc.output;

import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.impl.orc.output.OrcOutputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.orc.output.OrcOutputMeta;
import org.pentaho.big.data.kettle.plugins.formats.orc.output.OrcOutputField;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.cluster.ClusterInitializationException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IPentahoOrcOutputFormat;

public class OrcOutput
extends BaseStep
implements StepInterface {
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private OrcOutputMeta meta;
    private OrcOutputData data;

    public OrcOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] currentRow;
            this.meta = (OrcOutputMeta)smi;
            this.data = (OrcOutputData)sdi;
            if (this.data.output == null) {
                this.init();
            }
            if ((currentRow = this.getRow()) != null) {
                RowMeta outputRMI = new RowMeta();
                Object[] outputData = new Object[this.meta.getOutputFields().size()];
                for (int i = 0; i < this.meta.getOutputFields().size(); ++i) {
                    int inputRowIndex = this.getInputRowMeta().indexOfValue(((OrcOutputField)this.meta.getOutputFields().get(i)).getPentahoFieldName());
                    if (inputRowIndex == -1) {
                        throw new KettleException("Field name [" + ((OrcOutputField)this.meta.getOutputFields().get(i)).getPentahoFieldName() + " ] couldn't be found in the input stream!");
                    }
                    ValueMetaInterface vmi = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)this.getInputRowMeta().getValueMeta(inputRowIndex));
                    outputRMI.addValueMeta(i, vmi);
                    outputData[i] = currentRow[inputRowIndex];
                }
                RowMetaAndData row = new RowMetaAndData((RowMetaInterface)outputRMI, outputData);
                this.data.writer.write(row);
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            this.closeWriter();
            this.setOutputDone();
            return false;
        }
        catch (IllegalStateException e) {
            this.getLogChannel().logError(e.getMessage());
            this.setErrors(1L);
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    public void init() throws Exception {
        IPentahoOrcOutputFormat.COMPRESSION compression;
        FormatService formatService;
        try {
            formatService = (FormatService)this.namedClusterServiceLocator.getService(this.getNamedCluster(), FormatService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        if (this.meta.getFilename() == null) {
            throw new KettleException("No output files defined");
        }
        this.data.output = (IPentahoOrcOutputFormat)formatService.createOutputFormat(IPentahoOrcOutputFormat.class, this.getNamedCluster());
        String outputFileName = this.environmentSubstitute(this.meta.constructOutputFilename());
        FileObject outputFileObject = KettleVFS.getFileObject((String)outputFileName);
        if (AliasedFileObject.isAliasedFile((FileObject)outputFileObject)) {
            outputFileName = ((AliasedFileObject)outputFileObject).getOriginalURIString();
        }
        this.data.output.setOutputFile(outputFileName, this.meta.isOverrideOutput());
        this.data.output.setFields(this.meta.getOutputFields());
        try {
            compression = IPentahoOrcOutputFormat.COMPRESSION.valueOf((String)this.meta.getCompressionType().toUpperCase());
        }
        catch (Exception ex) {
            compression = IPentahoOrcOutputFormat.COMPRESSION.NONE;
        }
        this.data.output.setCompression(compression);
        if (compression != IPentahoOrcOutputFormat.COMPRESSION.NONE) {
            this.data.output.setCompressSize(this.meta.getCompressSize());
        }
        this.data.output.setRowIndexStride(this.meta.getRowsBetweenEntries());
        this.data.output.setStripeSize(this.meta.getStripeSize());
        this.data.writer = this.data.output.createRecordWriter();
    }

    private NamedCluster getNamedCluster() {
        return this.meta.getNamedCluster(this.environmentSubstitute(this.meta.getFilename()));
    }

    public void closeWriter() throws KettleException {
        try {
            this.data.writer.close();
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
        this.data.output = null;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OrcOutputMeta)smi;
        this.data = (OrcOutputData)sdi;
        return super.init(smi, sdi);
    }
}

