/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public abstract class BaseParquetStepDialog<T extends BaseStepMeta>
extends BaseStepDialog
implements StepDialogInterface {
    protected final Class<?> PKG = ((Object)((Object)this)).getClass();
    protected static final Class<?> BPKG = BaseParquetStepDialog.class;
    protected T meta;
    protected ModifyListener lsMod;
    public static final int MARGIN = 15;
    public static final int FIELDS_SEP = 10;
    public static final int FIELD_LABEL_SEP = 5;
    public static final int FIELD_TINY = 100;
    public static final int FIELD_SMALL = 150;
    public static final int FIELD_MEDIUM = 250;
    public static final int FIELD_LARGE = 350;
    private static final String ELLIPSIS = "...";
    private static final int TABLE_ITEM_MARGIN = 2;
    private static final int TOOLTIP_SHOW_DELAY = 350;
    private static final int TOOLTIP_HIDE_DELAY = 2000;
    protected static final int VAR_EXTRA_WIDTH = GUIResource.getInstance().getImageVariable().getBounds().width;
    protected TextVar wPath;
    protected Button wbBrowse;

    public BaseParquetStepDialog(Shell parent, T in, TransMeta transMeta, String sname) {
        super(parent, in, transMeta, sname);
        this.meta = in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.lsMod = e -> this.meta.setChanged();
        this.changed = this.meta.hasChanged();
        this.createUI();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseParquetStepDialog.this.cancel();
            }
        });
        int height = Math.max(this.getMinHeight((Composite)this.shell, this.getWidth()), this.getHeight());
        this.shell.setMinimumSize(this.getWidth(), height);
        this.shell.setSize(this.getWidth(), height);
        this.getData(this.meta);
        this.shell.open();
        this.wStepname.setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected abstract void createUI();

    protected Control createFooter(Composite shell) {
        this.wCancel = new Button(shell, 8);
        this.wCancel.setText(this.getMsg("System.Button.Cancel"));
        this.wCancel.addListener(13, this.lsCancel);
        new FD((Control)this.wCancel).right(100, 0).bottom(100, 0).apply();
        this.wOK = new Button(shell, 8);
        this.wOK.setText(this.getMsg("System.Button.OK"));
        this.wOK.addListener(13, this.lsOK);
        new FD((Control)this.wOK).right((Control)this.wCancel, -5).bottom(100, 0).apply();
        this.lsPreview = this.getPreview();
        if (this.lsPreview != null) {
            this.wPreview = new Button(shell, 8);
            this.wPreview.setText(this.getBaseMsg("BaseStepDialog.Preview"));
            this.wPreview.pack();
            this.wPreview.addListener(13, this.lsPreview);
            int offset = this.wPreview.getBounds().width / 2;
            new FD((Control)this.wPreview).left(50, -offset).bottom(100, 0).apply();
        }
        return this.wCancel;
    }

    protected void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.meta, false);
        this.dispose();
    }

    protected abstract String getStepTitle();

    protected abstract void getData(T var1);

    protected abstract void getInfo(T var1, boolean var2);

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract Listener getPreview();

    protected Label createHeader() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getStepTitle());
        this.lsOK = e -> this.ok();
        this.lsCancel = e -> this.cancel();
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(this.getBaseMsg("BaseStepDialog.StepName"));
        this.props.setLook((Control)this.wlStepname);
        new FD((Control)this.wlStepname).left(0, 0).top(0, 0).apply();
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        new FD((Control)this.wStepname).left(0, 0).top((Control)this.wlStepname, 5).width(250).rright().apply();
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSpacer);
        this.addIcon();
        return separator;
    }

    protected void addIcon() {
        Label wicon = new Label((Composite)this.shell, 131072);
        String stepId = this.meta.getParentStepMeta().getStepID();
        wicon.setImage(((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(stepId)).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48));
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
    }

    protected Control addFileWidgets(Control prev) {
        Label wlPath = new Label((Composite)this.shell, 131072);
        wlPath.setText(this.getBaseMsg("ParquetDialog.Filename.Label"));
        this.props.setLook((Control)wlPath);
        new FD((Control)wlPath).left(0, 0).top(prev, 15).apply();
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wPath.addModifyListener(event -> {
            if (this.wPreview != null) {
                this.wPreview.setEnabled(!Utils.isEmpty((CharSequence)this.wPath.getText()));
            }
        });
        this.props.setLook((Control)this.wPath);
        this.wPath.addModifyListener(this.lsMod);
        new FD((Control)this.wPath).left(0, 0).top((Control)wlPath, 5).width(350 + VAR_EXTRA_WIDTH).rright().apply();
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(this.getMsg("System.Button.Browse"));
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapterFileDialogTextVar((LogChannelInterface)this.log, this.wPath, (AbstractMeta)this.transMeta, new SelectionAdapterOptions(this.selectionOperation())));
        int bOffset = (this.wbBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        new FD((Control)this.wbBrowse).left((Control)this.wPath, 5).top((Control)wlPath, 5 - bOffset).apply();
        return this.wPath;
    }

    protected abstract SelectionOperation selectionOperation();

    protected String getBaseMsg(String key) {
        return BaseMessages.getString(BPKG, (String)key, (String[])new String[0]);
    }

    protected String getMsg(String key) {
        return BaseMessages.getString(this.PKG, (String)key, (String[])new String[0]);
    }

    protected int getMinHeight(Composite comp, int minWidth) {
        comp.pack();
        return comp.computeSize((int)minWidth, (int)-1).y;
    }

    protected void setTruncatedColumn(Table table, int targetColumn) {
        table.addListener(40, event -> {
            if (event.index == targetColumn) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        table.addListener(42, event -> {
            TableItem item = (TableItem)event.item;
            int colIdx = event.index;
            if (colIdx == targetColumn) {
                String contents = item.getText(colIdx);
                if (Utils.isEmpty((CharSequence)contents)) {
                    return;
                }
                Point size = event.gc.textExtent(contents);
                int targetWidth = item.getBounds((int)colIdx).width;
                int yOffset = Math.max(0, (event.height - size.y) / 2);
                if (size.x > targetWidth) {
                    contents = this.shortenText(event.gc, contents, targetWidth);
                }
                event.gc.drawText(contents, event.x + 2, event.y + yOffset, true);
            }
        });
    }

    protected void addColumnTooltip(final Table table, final int columnIndex) {
        final DefaultToolTip toolTip = new DefaultToolTip((Control)table, 1, true);
        toolTip.setRespectMonitorBounds(true);
        toolTip.setRespectDisplayBounds(true);
        toolTip.setPopupDelay(350);
        toolTip.setHideDelay(2000);
        toolTip.setShift(new Point(5, 5));
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                String contents;
                Point coord = new Point(e.x, e.y);
                TableItem item = table.getItem(coord);
                if (item != null && item.getBounds(columnIndex).contains(coord) && !Utils.isEmpty((CharSequence)(contents = item.getText(columnIndex)))) {
                    toolTip.setText(contents);
                    toolTip.show(coord);
                    return;
                }
                toolTip.hide();
            }

            public void mouseExit(MouseEvent e) {
                toolTip.hide();
            }
        });
    }

    protected String shortenText(GC gc, String text, int targetWidth) {
        if (Utils.isEmpty((CharSequence)text)) {
            return "";
        }
        int textWidth = gc.textExtent((String)text).x;
        int extra = gc.textExtent((String)ELLIPSIS).x + 4;
        if (targetWidth <= extra || textWidth <= targetWidth) {
            return text;
        }
        int len = text.length();
        for (int chomp = 1; chomp < len && textWidth + extra >= targetWidth; ++chomp) {
            text = text.substring(0, text.length() - 1);
            textWidth = gc.textExtent((String)text).x;
        }
        return text + ELLIPSIS;
    }

    private int getControlOffset(Control control, int controlWidth) {
        return this.getWidth() - this.getMarginWidths(control) - controlWidth;
    }

    private int getMarginWidths(Control control) {
        int extraWidth = 0;
        Composite parent = control.getParent();
        while (!parent.equals(this.getParent())) {
            extraWidth += parent.computeTrim((int)0, (int)0, (int)0, (int)0).width;
            if (parent.getLayout() instanceof FormLayout) {
                extraWidth += 2 * ((FormLayout)parent.getLayout()).marginWidth;
            }
            parent = parent.getParent();
        }
        return extraWidth;
    }

    protected void setIntegerOnly(TextVar textVar) {
        textVar.getTextWidget().addVerifyListener(e -> {
            if (!(StringUtil.isEmpty((String)e.text) || StringUtil.isVariable((String)e.text) || StringUtil.IsInteger((String)e.text))) {
                e.doit = false;
            }
        });
    }

    protected class FD {
        private final Control control;
        private final FormData fd;

        public FD(Control control) {
            this.control = control;
            BaseParquetStepDialog.this.props.setLook(control);
            this.fd = new FormData();
        }

        public FD width(int width) {
            this.fd.width = width;
            return this;
        }

        public FD height(int height) {
            this.fd.height = height;
            return this;
        }

        public FD top(int numerator, int offset) {
            this.fd.top = new FormAttachment(numerator, offset);
            return this;
        }

        public FD top(Control control, int offset) {
            this.fd.top = new FormAttachment(control, offset);
            return this;
        }

        public FD bottom(int numerator, int offset) {
            this.fd.bottom = new FormAttachment(numerator, offset);
            return this;
        }

        public FD bottom(Control control, int offset) {
            this.fd.bottom = new FormAttachment(control, offset);
            return this;
        }

        public FD left(int numerator, int offset) {
            this.fd.left = new FormAttachment(numerator, offset);
            return this;
        }

        public FD left(int numerator) {
            return this.left(numerator, 0);
        }

        public FD left(Control control, int offset) {
            this.fd.left = new FormAttachment(control, offset);
            return this;
        }

        public FD right(int numerator, int offset) {
            this.fd.right = new FormAttachment(numerator, offset);
            return this;
        }

        public FD rright() {
            this.fd.right = new FormAttachment(100, -BaseParquetStepDialog.this.getControlOffset(this.control, this.fd.width));
            return this;
        }

        public FD right(Control control, int offset) {
            this.fd.right = new FormAttachment(control, offset);
            return this;
        }

        public void apply() {
            this.control.setLayoutData((Object)this.fd);
        }
    }
}

