/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input;

import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInputMeta;
import org.pentaho.big.data.kettle.plugins.formats.parquet.input.ParquetInputField;
import org.pentaho.big.data.kettle.plugins.formats.parquet.input.ParquetInputMetaBase;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.cluster.NamedClusterServiceLocator;
import org.pentaho.hadoop.shim.api.format.FormatService;
import org.pentaho.hadoop.shim.api.format.IFormatInputField;
import org.pentaho.hadoop.shim.api.format.IParquetInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetInputFormat;

public class ParquetInput
extends BaseFileInputStep<ParquetInputMeta, ParquetInputData> {
    public static final long SPLIT_SIZE = 0x8000000L;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public ParquetInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ParquetInputMeta)smi;
        this.data = (ParquetInputData)sdi;
        try {
            if (((ParquetInputData)this.data).splits == null) {
                this.initSplits();
            }
            if (((ParquetInputData)this.data).currentSplit >= ((ParquetInputData)this.data).splits.size()) {
                this.setOutputDone();
                return false;
            }
            if (((ParquetInputData)this.data).reader == null) {
                this.openReader((ParquetInputData)this.data);
            }
            if (((ParquetInputData)this.data).rowIterator.hasNext()) {
                RowMetaAndData row = ((ParquetInputData)this.data).rowIterator.next();
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            ((ParquetInputData)this.data).reader.close();
            ((ParquetInputData)this.data).reader = null;
            this.logDebug("Close split {0}", new Object[]{((ParquetInputData)this.data).currentSplit});
            ++((ParquetInputData)this.data).currentSplit;
            return true;
        }
        catch (NoSuchFileException ex) {
            throw new KettleException("No input file");
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    void initSplits() throws Exception {
        FormatService formatService = (FormatService)this.namedClusterServiceLocator.getService(this.getNamedCluster(), FormatService.class);
        if (((ParquetInputMeta)this.meta).inputFiles == null || ((FormatInputFile)((ParquetInputMeta)this.meta).inputFiles).fileName == null || ((FormatInputFile)((ParquetInputMeta)this.meta).inputFiles).fileName.length == 0) {
            throw new KettleException("No input files defined");
        }
        String inputFileName = this.environmentSubstitute(((FormatInputFile)((ParquetInputMeta)this.meta).inputFiles).fileName[0]);
        FileObject inputFileObject = KettleVFS.getFileObject((String)inputFileName, (VariableSpace)this.getTransMeta());
        if (AliasedFileObject.isAliasedFile((FileObject)inputFileObject)) {
            inputFileName = ((AliasedFileObject)inputFileObject).getOriginalURIString();
        }
        ((ParquetInputData)this.data).input = (IPentahoParquetInputFormat)formatService.createInputFormat(IPentahoParquetInputFormat.class, this.getNamedCluster());
        List<? extends IParquetInputField> actualFileFields = ParquetInput.retrieveSchema(((ParquetInputMeta)this.meta).namedClusterServiceLocator, this.getNamedCluster(), inputFileName);
        if (((ParquetInputMeta)this.meta).isIgnoreEmptyFolder() && actualFileFields.isEmpty()) {
            ((ParquetInputData)this.data).splits = new ArrayList<IPentahoInputFormat.IPentahoInputSplit>();
            this.logBasic("No Parquet input files found.");
        } else {
            Map fieldNamesToTypes = actualFileFields.stream().collect(Collectors.toMap(IFormatInputField::getFormatFieldName, Function.identity()));
            for (ParquetInputField f : ((ParquetInputMeta)this.meta).getInputFields()) {
                if (!fieldNamesToTypes.containsKey(f.getFormatFieldName())) continue;
                if (f.getFormatType() == 0) {
                    f.setFormatType(((IParquetInputField)fieldNamesToTypes.get(f.getFormatFieldName())).getFormatType());
                }
                f.setPrecision(((IParquetInputField)fieldNamesToTypes.get(f.getFormatFieldName())).getPrecision());
                f.setScale(((IParquetInputField)fieldNamesToTypes.get(f.getFormatFieldName())).getScale());
            }
            ((ParquetInputData)this.data).input.setSchema(ParquetInput.createSchemaFromMeta((ParquetInputMetaBase)this.meta));
            ((ParquetInputData)this.data).input.setInputFile(inputFileName);
            ((ParquetInputData)this.data).input.setSplitSize(0x8000000L);
            ((ParquetInputData)this.data).splits = ((ParquetInputData)this.data).input.getSplits();
            this.logDebug("Input split count: {0}", new Object[]{((ParquetInputData)this.data).splits.size()});
        }
        ((ParquetInputData)this.data).currentSplit = 0;
    }

    private NamedCluster getNamedCluster() {
        return ((ParquetInputMeta)this.meta).getNamedCluster(this.environmentSubstitute(((ParquetInputMeta)this.meta).getFilename()));
    }

    void openReader(ParquetInputData data) throws Exception {
        this.logDebug("Open split {0}", new Object[]{data.currentSplit});
        IPentahoInputFormat.IPentahoInputSplit sp = data.splits.get(data.currentSplit);
        data.reader = data.input.createRecordReader(sp);
        data.rowIterator = data.reader.iterator();
    }

    protected boolean init() {
        return true;
    }

    protected IBaseFileInputReader createReader(ParquetInputMeta meta, ParquetInputData data, FileObject file) throws Exception {
        return null;
    }

    public static List<? extends IParquetInputField> retrieveSchema(NamedClusterServiceLocator namedClusterServiceLocator, NamedCluster namedCluster, String path) throws Exception {
        FormatService formatService = (FormatService)namedClusterServiceLocator.getService(namedCluster, FormatService.class);
        IPentahoParquetInputFormat in = (IPentahoParquetInputFormat)formatService.createInputFormat(IPentahoParquetInputFormat.class, namedCluster);
        FileObject inputFileObject = KettleVFS.getFileObject((String)path);
        if (AliasedFileObject.isAliasedFile((FileObject)inputFileObject)) {
            path = ((AliasedFileObject)inputFileObject).getOriginalURIString();
        }
        return in.readSchema(path);
    }

    public static List<IParquetInputField> createSchemaFromMeta(ParquetInputMetaBase meta) {
        ArrayList<IParquetInputField> fields = new ArrayList<IParquetInputField>();
        for (ParquetInputField f : meta.getInputFields()) {
            fields.add((IParquetInputField)f);
        }
        return fields;
    }
}

