/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.impl.NullableValuesEnum;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.BaseParquetStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output.ParquetOutputMeta;
import org.pentaho.big.data.kettle.plugins.formats.parquet.ParquetTypeConverter;
import org.pentaho.big.data.kettle.plugins.formats.parquet.output.ParquetOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;

public class ParquetOutputDialog
extends BaseParquetStepDialog<ParquetOutputMeta>
implements StepDialogInterface {
    private static final Class<?> PKG = ParquetOutputMeta.class;
    private static final int PARQUET_OUTPUT_FIELD_TINY = Const.isLinux() ? 120 : 100;
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 620;
    private static final int COLUMNS_SEP = 75;
    private static final int OFFSET = 16;
    private TableView wOutputFields;
    private Button wOverwriteExistingFile;
    private ComboVar wCompression;
    private ComboVar wVersion;
    private TextVar wRowSize;
    private TextVar wPageSize;
    private TextVar wExtension;
    private TextVar wDictPageSize;
    private Label lDict;
    private Button wDictionaryEncoding;
    private Button wIncludeDateInFilename;
    private Button wIncludeTimeInFilename;
    private Button wSpecifyDateTimeFormat;
    private ComboVar wDateTimeFormat;
    private static final ParquetSpec.DataType[] SUPPORTED_PARQUET_TYPES = new ParquetSpec.DataType[]{ParquetSpec.DataType.BINARY, ParquetSpec.DataType.BOOLEAN, ParquetSpec.DataType.DATE, ParquetSpec.DataType.DECIMAL, ParquetSpec.DataType.DOUBLE, ParquetSpec.DataType.FLOAT, ParquetSpec.DataType.INT_32, ParquetSpec.DataType.INT_64, ParquetSpec.DataType.INT_96, ParquetSpec.DataType.TIMESTAMP_MILLIS, ParquetSpec.DataType.UTF8};

    public ParquetOutputDialog(Shell parent, Object parquetOutputMeta, TransMeta transMeta, String sname) {
        this(parent, (ParquetOutputMeta)((Object)parquetOutputMeta), transMeta, sname);
    }

    public ParquetOutputDialog(Shell parent, ParquetOutputMeta parquetOutputMeta, TransMeta transMeta, String sname) {
        super(parent, parquetOutputMeta, transMeta, sname);
        this.meta = parquetOutputMeta;
    }

    @Override
    protected void createUI() {
        Label prev = this.createHeader();
        prev = this.addFileWidgets((Control)prev);
        this.createFooter((Composite)this.shell);
        Composite afterFile = new Composite((Composite)this.shell, 0);
        afterFile.setLayout((Layout)new FormLayout());
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdSpacer.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSpacer);
        new BaseParquetStepDialog.FD((Control)afterFile).left(0, 0).top((Control)prev, 0).right(100, 0).bottom((Control)separator, -15).apply();
        this.createAfterFile(afterFile);
    }

    protected Control createAfterFile(Composite afterFile) {
        this.wOverwriteExistingFile = new Button(afterFile, 32);
        this.wOverwriteExistingFile.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.OverwriteFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wOverwriteExistingFile);
        new BaseParquetStepDialog.FD((Control)this.wOverwriteExistingFile).left(0, 0).top((Control)afterFile, 10).apply();
        this.wOverwriteExistingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
            }
        });
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addFieldsTab(wTabFolder);
        this.addOptionsTab(wTabFolder);
        new BaseParquetStepDialog.FD((Control)wTabFolder).left(0, 0).top((Control)this.wOverwriteExistingFile, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Shell.Title", (String[])new String[0]);
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = e -> this.getFields();
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseParquetStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        String[] typeNames = new String[SUPPORTED_PARQUET_TYPES.length];
        for (int i = 0; i < typeNames.length; ++i) {
            typeNames[i] = SUPPORTED_PARQUET_TYPES[i].getName();
        }
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Path", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Type", (String[])new String[0]), 2, typeNames, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Precision", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Scale", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Default", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Null", (String[])new String[0]), 2, NullableValuesEnum.getValuesArr(), true)};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        this.wOutputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 7, this.lsMod, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 30, 20, 10, 10, 10, 15, 5});
        this.wOutputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wOutputFields);
        new BaseParquetStepDialog.FD((Control)this.wOutputFields).left(0, 0).right(100, 0).top((Control)wComp, 0).bottom((Control)wGetFields, -10).apply();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        new BaseParquetStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wOutputFields.getTable());
        this.setTruncatedColumn(this.wOutputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wOutputFields.getTable(), 1);
        }
    }

    private void addOptionsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wComp);
        this.props.setLook((Control)wComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        wComp.setLayout((Layout)formLayout);
        Label lCompression = this.createLabel(wComp, "ParquetOutputDialog.Options.Compression");
        new BaseParquetStepDialog.FD((Control)lCompression).left(0, 0).top((Control)wComp, 0).apply();
        this.wCompression = this.createComboVar(wComp, ((ParquetOutputMeta)this.meta).getCompressionTypes());
        new BaseParquetStepDialog.FD((Control)this.wCompression).left(0, 0).top((Control)lCompression, 5).width(PARQUET_OUTPUT_FIELD_TINY + VAR_EXTRA_WIDTH).apply();
        Label lVersion = this.createLabel(wComp, "ParquetOutputDialog.Options.Version");
        new BaseParquetStepDialog.FD((Control)lVersion).left(0, 0).top((Control)this.wCompression, 10).apply();
        this.wVersion = this.createComboVar(wComp, ((ParquetOutputMeta)this.meta).getVersionTypes());
        new BaseParquetStepDialog.FD((Control)this.wVersion).left(0, 0).top((Control)lVersion, 5).width(PARQUET_OUTPUT_FIELD_TINY + VAR_EXTRA_WIDTH).apply();
        Label lRowSize = this.createLabel(wComp, "ParquetOutputDialog.Options.RowSize");
        new BaseParquetStepDialog.FD((Control)lRowSize).left(0, 0).top((Control)this.wVersion, 10).apply();
        this.wRowSize = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wRowSize).left(0, 0).top((Control)lRowSize, 5).width(PARQUET_OUTPUT_FIELD_TINY + VAR_EXTRA_WIDTH).apply();
        this.setIntegerOnly(this.wRowSize);
        this.wRowSize.addModifyListener(this.lsMod);
        Label lDataPageSize = this.createLabel(wComp, "ParquetOutputDialog.Options.PageSize");
        new BaseParquetStepDialog.FD((Control)lDataPageSize).left(0, 0).top((Control)this.wRowSize, 10).apply();
        this.wPageSize = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wPageSize).left(0, 0).top((Control)lDataPageSize, 5).width(PARQUET_OUTPUT_FIELD_TINY + VAR_EXTRA_WIDTH).apply();
        this.setIntegerOnly(this.wPageSize);
        this.wPageSize.addModifyListener(this.lsMod);
        this.wDictionaryEncoding = new Button(wComp, 32);
        this.wDictionaryEncoding.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.DictionaryEncoding", (String[])new String[0]));
        this.props.setLook((Control)this.wDictionaryEncoding);
        new BaseParquetStepDialog.FD((Control)this.wDictionaryEncoding).left(0, 0).top((Control)this.wPageSize, 10).apply();
        this.wDictionaryEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
                ParquetOutputDialog.this.actualizeDictionaryPageSizeControl();
            }
        });
        this.lDict = new Label(wComp, 0);
        this.lDict.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.DictPageSize", (String[])new String[0]));
        new BaseParquetStepDialog.FD((Control)this.lDict).left(0, 16).top((Control)this.wDictionaryEncoding, 5).apply();
        this.wDictPageSize = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wDictPageSize).left(0, 16).top((Control)this.lDict, 5).width(PARQUET_OUTPUT_FIELD_TINY + VAR_EXTRA_WIDTH - 16).apply();
        this.setIntegerOnly(this.wDictPageSize);
        this.wDictPageSize.addModifyListener(this.lsMod);
        ComboVar leftRef = this.wCompression;
        Label lExtension = new Label(wComp, 0);
        lExtension.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.Extension", (String[])new String[0]));
        new BaseParquetStepDialog.FD((Control)lExtension).left((Control)leftRef, 75).top((Control)wComp, 0).apply();
        this.wExtension = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wExtension).left((Control)leftRef, 75).top((Control)lExtension, 5).width(PARQUET_OUTPUT_FIELD_TINY + VAR_EXTRA_WIDTH).apply();
        this.wExtension.addModifyListener(this.lsMod);
        this.wIncludeDateInFilename = new Button(wComp, 32);
        this.wIncludeDateInFilename.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.IncludeDateInFilename", (String[])new String[0]));
        this.props.setLook((Control)this.wIncludeDateInFilename);
        new BaseParquetStepDialog.FD((Control)this.wIncludeDateInFilename).left((Control)leftRef, 75).top((Control)this.wExtension, 15).apply();
        this.wIncludeDateInFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
            }
        });
        this.wIncludeTimeInFilename = new Button(wComp, 32);
        this.wIncludeTimeInFilename.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.IncludeTimeInFilename", (String[])new String[0]));
        this.props.setLook((Control)this.wIncludeTimeInFilename);
        new BaseParquetStepDialog.FD((Control)this.wIncludeTimeInFilename).left((Control)leftRef, 75).top((Control)this.wIncludeDateInFilename, 10).apply();
        this.wIncludeTimeInFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
            }
        });
        this.wSpecifyDateTimeFormat = new Button(wComp, 32);
        this.wSpecifyDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.SpecifyDateTimeFormat", (String[])new String[0]));
        this.props.setLook((Control)this.wSpecifyDateTimeFormat);
        new BaseParquetStepDialog.FD((Control)this.wSpecifyDateTimeFormat).left((Control)leftRef, 75).top((Control)this.wIncludeTimeInFilename, 10).apply();
        this.wSpecifyDateTimeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
                ParquetOutputDialog.this.wDateTimeFormat.setEnabled(ParquetOutputDialog.this.wSpecifyDateTimeFormat.getSelection());
                ParquetOutputDialog.this.actualizeDateTimeControls();
            }
        });
        String[] dates = Const.getDateFormats();
        dates = (String[])Arrays.stream(dates).filter(d -> d.indexOf(47) < 0 && d.indexOf(92) < 0 && d.indexOf(58) < 0).toArray(String[]::new);
        this.wDateTimeFormat = this.createComboVar(wComp, dates);
        this.props.setLook((Control)this.wDateTimeFormat);
        new BaseParquetStepDialog.FD((Control)this.wDateTimeFormat).left((Control)leftRef, 91).top((Control)this.wSpecifyDateTimeFormat, 5).width(200).apply();
        this.wDateTimeFormat.addModifyListener(this.lsMod);
    }

    void actualizeDictionaryPageSizeControl() {
        boolean dictionaryEncoding = this.wDictionaryEncoding.getSelection();
        this.lDict.setEnabled(dictionaryEncoding);
        this.wDictPageSize.setEnabled(dictionaryEncoding);
    }

    void actualizeDateTimeControls() {
        boolean allowedToIncludeDateTime = !this.wSpecifyDateTimeFormat.getSelection();
        this.wIncludeDateInFilename.setEnabled(allowedToIncludeDateTime);
        this.wIncludeTimeInFilename.setEnabled(allowedToIncludeDateTime);
        if (!allowedToIncludeDateTime) {
            this.wIncludeDateInFilename.setSelection(false);
            this.wIncludeTimeInFilename.setSelection(false);
        }
    }

    protected ComboVar createComboVar(Composite container, String[] options) {
        ComboVar combo = new ComboVar((VariableSpace)this.transMeta, container, 18436);
        combo.setItems(options);
        combo.addModifyListener(this.lsMod);
        return combo;
    }

    protected String getComboVarValue(ComboVar combo) {
        String text = combo.getText();
        String data = (String)combo.getData(text);
        return data != null ? data : text;
    }

    private Label createLabel(Composite container, String labelRef) {
        Label label = new Label(container, 0);
        label.setText(BaseMessages.getString(PKG, (String)labelRef, (String[])new String[0]));
        this.props.setLook((Control)label);
        return label;
    }

    @Override
    protected void getData(ParquetOutputMeta meta) {
        if (meta.getFilename() != null) {
            this.wPath.setText(meta.getFilename());
        }
        this.wOverwriteExistingFile.setSelection(meta.isOverrideOutput());
        this.populateFieldsUI(meta, this.wOutputFields);
        this.wCompression.setText(this.coalesce(meta.getCompressionType()));
        this.wVersion.setText(this.coalesce(meta.getParquetVersion()));
        this.wDictionaryEncoding.setSelection(meta.isEnableDictionary());
        this.wDictPageSize.setText(this.coalesce(meta.getDictPageSize()));
        this.wRowSize.setText(this.coalesce(meta.getRowGroupSize()));
        this.wPageSize.setText(this.coalesce(meta.getDataPageSize()));
        this.wExtension.setText(this.coalesce(meta.getExtension()));
        this.wIncludeDateInFilename.setSelection(meta.isDateInFilename());
        this.wIncludeTimeInFilename.setSelection(meta.isTimeInFilename());
        String dateTimeFormat = this.coalesce(meta.getDateTimeFormat());
        if (!dateTimeFormat.isEmpty()) {
            this.wSpecifyDateTimeFormat.setSelection(true);
            this.wDateTimeFormat.setText(dateTimeFormat);
        } else {
            this.wSpecifyDateTimeFormat.setSelection(false);
            this.wDateTimeFormat.setEnabled(false);
        }
        this.actualizeDictionaryPageSizeControl();
        this.actualizeDateTimeControls();
    }

    private String coalesce(String value) {
        return value == null ? "" : value;
    }

    @Override
    protected void getInfo(ParquetOutputMeta meta, boolean preview) {
        meta.setFilename(this.wPath.getText());
        meta.setOverrideOutput(this.wOverwriteExistingFile.getSelection());
        this.saveOutputFields(this.wOutputFields, meta);
        meta.setCompressionType(this.wCompression.getText());
        meta.setParquetVersion(this.wVersion.getText());
        meta.setEnableDictionary(this.wDictionaryEncoding.getSelection());
        meta.setDictPageSize(this.wDictPageSize.getText());
        meta.setRowGroupSize(this.wRowSize.getText());
        meta.setDataPageSize(this.wPageSize.getText());
        meta.setExtension(this.wExtension.getText());
        if (this.wSpecifyDateTimeFormat.getSelection()) {
            meta.setDateTimeFormat(this.wDateTimeFormat.getText());
            meta.setDateInFilename(false);
            meta.setTimeInFilename(false);
        } else {
            meta.setDateTimeFormat(null);
            meta.setDateInFilename(this.wIncludeDateInFilename.getSelection());
            meta.setTimeInFilename(this.wIncludeTimeInFilename.getSelection());
        }
    }

    private void saveOutputFields(TableView wFields, ParquetOutputMeta meta) {
        int nrFields = wFields.nrNonEmpty();
        ArrayList<ParquetOutputField> outputFields = new ArrayList<ParquetOutputField>();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            ParquetOutputField field = new ParquetOutputField();
            field.setFormatFieldName(item.getText(j++));
            field.setPentahoFieldName(item.getText(j++));
            String typeName = item.getText(j++);
            for (ParquetSpec.DataType parqueType : SUPPORTED_PARQUET_TYPES) {
                if (!parqueType.getName().equals(typeName)) continue;
                field.setFormatType(parqueType.getId());
            }
            if (field.getParquetType().equals((Object)ParquetSpec.DataType.DECIMAL)) {
                field.setPrecision(item.getText(j++));
                field.setScale(item.getText(j++));
            } else if (field.getParquetType().equals((Object)ParquetSpec.DataType.FLOAT) || field.getParquetType().equals((Object)ParquetSpec.DataType.DOUBLE)) {
                int n = ++j;
                field.setScale(item.getText(n));
            } else {
                j += 2;
            }
            int n = ++j;
            field.setDefaultValue(item.getText(n));
            int n2 = ++j;
            ++j;
            field.setAllowNull(NullableValuesEnum.YES.getValue().equals(item.getText(n2)));
            outputFields.add(field);
        }
        meta.setOutputFields(outputFields);
    }

    private void populateFieldsUI(ParquetOutputMeta meta, TableView wOutputFields) {
        this.populateFieldsUI(meta.getOutputFields(), wOutputFields, (field, item) -> {
            int i = 1;
            item.setText(i++, this.coalesce(field.getFormatFieldName()));
            item.setText(i++, this.coalesce(field.getPentahoFieldName()));
            item.setText(i++, this.coalesce(field.getParquetType().getName()));
            if (field.getParquetType().equals((Object)ParquetSpec.DataType.DECIMAL)) {
                item.setText(i++, this.coalesce(String.valueOf(field.getPrecision())));
                item.setText(i++, this.coalesce(String.valueOf(field.getScale())));
            } else if (field.getParquetType().equals((Object)ParquetSpec.DataType.FLOAT) || field.getParquetType().equals((Object)ParquetSpec.DataType.DOUBLE)) {
                item.setText(i++, "");
                item.setText(i++, field.getScale() > 0 ? String.valueOf(field.getScale()) : "");
            } else {
                item.setText(i++, "");
                item.setText(i++, "");
            }
            item.setText(i++, this.coalesce(field.getDefaultValue()));
            item.setText(i++, field.getAllowNull() ? NullableValuesEnum.YES.getValue() : NullableValuesEnum.NO.getValue());
        });
    }

    private void populateFieldsUI(List<ParquetOutputField> fields, TableView wFields, BiConsumer<ParquetOutputField, TableItem> converter) {
        for (int i = 0; i < fields.size(); ++i) {
            TableItem item = null;
            item = i < wFields.table.getItemCount() ? wFields.table.getItem(i) : new TableItem(wFields.table, 0);
            converter.accept(fields.get(i), item);
        }
    }

    private void getFieldsFromPreviousStep(RowMetaInterface row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, boolean optimizeWidth, TableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = tableView.table;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Utils.isEmpty((CharSequence)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (!keys.isEmpty()) {
            MessageDialog getFieldsChoiceDialog = ParquetOutputDialog.getFieldsChoiceDialog(tableView.getShell(), row.size());
            int idx = getFieldsChoiceDialog.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.clearAll(false);
        }
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            TableItem tableItem = new TableItem(table, 0);
            for (int c = 0; c < nameColumn.length; ++c) {
                tableItem.setText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            String parquetTypeName = ParquetTypeConverter.convertToParquetType((int)v.getType());
            if (dataTypeColumn != null) {
                for (int c = 0; c < dataTypeColumn.length; ++c) {
                    tableItem.setText(dataTypeColumn[c], parquetTypeName);
                }
            }
            if (parquetTypeName.equals(ParquetSpec.DataType.DECIMAL.getName())) {
                if (lengthColumn > 0 && v.getLength() > 0) {
                    tableItem.setText(lengthColumn, Integer.toString(v.getLength()));
                } else {
                    tableItem.setText(lengthColumn, Integer.toString(20));
                }
                if (precisionColumn > 0 && v.getPrecision() >= 0) {
                    tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
                } else {
                    tableItem.setText(precisionColumn, Integer.toString(0));
                }
            } else if ((parquetTypeName.equals(ParquetSpec.DataType.FLOAT.getName()) || parquetTypeName.equals(ParquetSpec.DataType.DOUBLE.getName())) && precisionColumn > 0 && v.getPrecision() > 0) {
                tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(tableItem, v)) continue;
            tableItem.dispose();
        }
        tableView.removeEmptyRows();
        tableView.setRowNums();
        if (optimizeWidth) {
            tableView.optWidth(true);
        }
    }

    protected void getFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = (tableItem, v) -> true;
                this.getFieldsFromPreviousStep(r, this.wOutputFields, 1, new int[]{1, 2}, new int[]{3}, 4, 5, true, listener);
                for (int i = 0; i < this.wOutputFields.table.getItemCount(); ++i) {
                    TableItem tableItem2 = this.wOutputFields.table.getItem(i);
                    if (!StringUtils.isEmpty((String)tableItem2.getText(7))) continue;
                    tableItem2.setText(7, "Yes");
                }
                ((ParquetOutputMeta)this.meta).setChanged();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    static MessageDialog getFieldsChoiceDialog(Shell shell, int newFields) {
        MessageDialog messageDialog = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"ParquetOutput.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"ParquetOutput.GetFieldsChoice.Message", (String[])new String[]{"" + newFields}), 4, new String[]{BaseMessages.getString(PKG, (String)"ParquetOutput.GetFieldsChoice.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ParquetOutput.GetFieldsChoice.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ParquetOutput.GetFieldsChoice.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ParquetOutput.GetFieldsChoice.Cancel", (String[])new String[0])}, 0){

            public void create() {
                super.create();
                this.getShell().setBackground(GUIResource.getInstance().getColorWhite());
            }

            protected Control createMessageArea(Composite composite) {
                Control control = super.createMessageArea(composite);
                this.imageLabel.setBackground(GUIResource.getInstance().getColorWhite());
                this.messageLabel.setBackground(GUIResource.getInstance().getColorWhite());
                return control;
            }

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                control.setBackground(GUIResource.getInstance().getColorWhite());
                return control;
            }

            protected Control createButtonBar(Composite parent) {
                Control control = super.createButtonBar(parent);
                control.setBackground(GUIResource.getInstance().getColorWhite());
                return control;
            }
        };
        MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
        return messageDialog;
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 620;
    }

    @Override
    protected Listener getPreview() {
        return null;
    }

    @Override
    protected SelectionOperation selectionOperation() {
        return SelectionOperation.SAVE_TO_FILE_FOLDER;
    }
}

