/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerField;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaDialogHelper;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStreamingDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

@PluginDialog(id="KafkaConsumerInput", pluginType=PluginDialog.PluginType.STEP, image="KafkaConsumerInput.svg")
public class KafkaConsumerInputDialog
extends BaseStreamingDialog
implements StepDialogInterface {
    private static final int INPUT_WIDTH = 350;
    private static final Class<?> PKG = KafkaConsumerInputMeta.class;
    private static final ImmutableMap<String, String> DEFAULT_OPTION_VALUES = ImmutableMap.of((Object)"auto.offset.reset", (Object)"latest");
    private final KafkaFactory kafkaFactory = KafkaFactory.defaultFactory();
    private KafkaConsumerInputMeta consumerMeta;
    private Spoon spoonInstance;
    private Label wlClusterName;
    private ComboVar wClusterName;
    private TextVar wConsumerGroup;
    private TableView topicsTable;
    private TableView optionsTable;
    private Button wbDirect;
    private Button wbCluster;
    private Label wlBootstrapServers;
    private TextVar wBootstrapServers;
    private Button wbAutoCommit;
    private Button wbManualCommit;
    private static final String REPOS_DELIM = "/";

    public KafkaConsumerInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, in, tr, sname);
        this.consumerMeta = (KafkaConsumerInputMeta)((Object)in);
        this.spoonInstance = Spoon.getInstance();
    }

    protected String getDialogTitle() {
        return BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Shell.Title", (String[])new String[0]);
    }

    protected void createAdditionalTabs() {
        this.buildFieldsTab();
        this.buildOptionsTab();
        this.buildOffsetManagement();
    }

    private void buildOffsetManagement() {
        Group wOffsetGroup = new Group(this.wBatchComp, 16);
        wOffsetGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OffsetManagement", (String[])new String[0]));
        FormLayout flOffsetGroup = new FormLayout();
        flOffsetGroup.marginHeight = 15;
        flOffsetGroup.marginWidth = 15;
        wOffsetGroup.setLayout((Layout)flOffsetGroup);
        FormData fdOffsetGroup = new FormData();
        fdOffsetGroup.top = new FormAttachment((Control)this.wParallelism, 15);
        fdOffsetGroup.left = new FormAttachment(0, 0);
        fdOffsetGroup.right = new FormAttachment(100, 0);
        wOffsetGroup.setLayoutData((Object)fdOffsetGroup);
        this.props.setLook((Control)wOffsetGroup);
        this.wbAutoCommit = new Button((Composite)wOffsetGroup, 16);
        this.wbAutoCommit.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.AutoOffset", (String[])new String[0]));
        FormData fdbAutoCommit = new FormData();
        fdbAutoCommit.top = new FormAttachment(0, 0);
        fdbAutoCommit.left = new FormAttachment(0, 0);
        this.wbAutoCommit.setLayoutData((Object)fdbAutoCommit);
        this.props.setLook((Control)this.wbAutoCommit);
        this.wbManualCommit = new Button((Composite)wOffsetGroup, 16);
        this.wbManualCommit.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.ManualOffset", (String[])new String[0]));
        FormData fdbManualCommit = new FormData();
        fdbManualCommit.left = new FormAttachment(0, 0);
        fdbManualCommit.top = new FormAttachment((Control)this.wbAutoCommit, 10, 1024);
        this.wbManualCommit.setLayoutData((Object)fdbManualCommit);
        this.props.setLook((Control)this.wbManualCommit);
    }

    protected void buildSetup(Composite wSetupComp) {
        this.props.setLook((Control)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        Group wConnectionGroup = new Group(wSetupComp, 16);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Connection", (String[])new String[0]));
        FormLayout flConnection = new FormLayout();
        flConnection.marginHeight = 15;
        flConnection.marginWidth = 15;
        wConnectionGroup.setLayout((Layout)flConnection);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, 0);
        fdConnectionGroup.top = new FormAttachment(0, 0);
        fdConnectionGroup.right = new FormAttachment(100, 0);
        fdConnectionGroup.width = 350;
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        this.props.setLook((Control)wConnectionGroup);
        this.wbDirect = new Button((Composite)wConnectionGroup, 16);
        this.wbDirect.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Direct", (String[])new String[0]));
        FormData fdbDirect = new FormData();
        fdbDirect.left = new FormAttachment(0, 0);
        fdbDirect.top = new FormAttachment(0, 0);
        this.wbDirect.setLayoutData((Object)fdbDirect);
        this.wbDirect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.lsMod.modifyText(null);
                KafkaConsumerInputDialog.this.toggleVisibility(true);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.toggleVisibility(true);
            }
        });
        this.props.setLook((Control)this.wbDirect);
        this.wbCluster = new Button((Composite)wConnectionGroup, 16);
        this.wbCluster.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Cluster", (String[])new String[0]));
        FormData fdbCluster = new FormData();
        fdbCluster.left = new FormAttachment(0, 0);
        fdbCluster.top = new FormAttachment((Control)this.wbDirect, 10);
        this.wbCluster.setLayoutData((Object)fdbCluster);
        this.wbCluster.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.lsMod.modifyText(null);
                KafkaConsumerInputDialog.this.toggleVisibility(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.toggleVisibility(false);
            }
        });
        this.props.setLook((Control)this.wbCluster);
        Label environmentSeparator = new Label((Composite)wConnectionGroup, 514);
        FormData fdenvironmentSeparator = new FormData();
        fdenvironmentSeparator.top = new FormAttachment((Control)this.wbDirect, 0, 128);
        fdenvironmentSeparator.left = new FormAttachment((Control)this.wbCluster, 15);
        fdenvironmentSeparator.bottom = new FormAttachment((Control)this.wbCluster, 0, 1024);
        environmentSeparator.setLayoutData((Object)fdenvironmentSeparator);
        this.wlClusterName = new Label((Composite)wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlClusterName);
        this.wlClusterName.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.HadoopCluster", (String[])new String[0]));
        FormData fdlClusterName = new FormData();
        fdlClusterName.left = new FormAttachment((Control)environmentSeparator, 15);
        fdlClusterName.top = new FormAttachment(0, 0);
        fdlClusterName.right = new FormAttachment(78, 0);
        this.wlClusterName.setLayoutData((Object)fdlClusterName);
        this.wClusterName = new ComboVar((VariableSpace)this.transMeta, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wClusterName);
        this.wClusterName.addModifyListener(this.lsMod);
        FormData fdClusterName = new FormData();
        fdClusterName.left = new FormAttachment((Control)this.wlClusterName, 0, 16384);
        fdClusterName.top = new FormAttachment((Control)this.wlClusterName, 5);
        fdClusterName.right = new FormAttachment(78, 0);
        this.wClusterName.setLayoutData((Object)fdClusterName);
        this.wlBootstrapServers = new Label((Composite)wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlBootstrapServers);
        this.wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BootstrapServers", (String[])new String[0]));
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment((Control)environmentSeparator, 15);
        fdlBootstrapServers.top = new FormAttachment(0, 0);
        fdlBootstrapServers.right = new FormAttachment(78, 0);
        this.wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar((VariableSpace)this.transMeta, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wBootstrapServers);
        this.wBootstrapServers.addModifyListener(this.lsMod);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment((Control)this.wlBootstrapServers, 0, 16384);
        fdBootstrapServers.top = new FormAttachment((Control)this.wlBootstrapServers, 5);
        fdBootstrapServers.right = new FormAttachment(78, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        Label wlTopic = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlTopic);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Topics", (String[])new String[0]));
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)wConnectionGroup, 10);
        fdlTopic.right = new FormAttachment(50, 0);
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wConsumerGroup = new TextVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wConsumerGroup);
        this.wConsumerGroup.addModifyListener(this.lsMod);
        FormData fdConsumerGroup = new FormData();
        fdConsumerGroup.left = new FormAttachment(0, 0);
        fdConsumerGroup.bottom = new FormAttachment(100, 0);
        fdConsumerGroup.width = 350;
        this.wConsumerGroup.setLayoutData((Object)fdConsumerGroup);
        Label wlConsumerGroup = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlConsumerGroup);
        wlConsumerGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.ConsumerGroup", (String[])new String[0]));
        FormData fdlConsumerGroup = new FormData();
        fdlConsumerGroup.left = new FormAttachment(0, 0);
        fdlConsumerGroup.bottom = new FormAttachment((Control)this.wConsumerGroup, -5, 128);
        fdlConsumerGroup.right = new FormAttachment(50, 0);
        wlConsumerGroup.setLayoutData((Object)fdlConsumerGroup);
        this.buildTopicsTable(wSetupComp, (Control)wlTopic, (Control)wlConsumerGroup);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        wSetupComp.setLayoutData((Object)fdSetupComp);
        wSetupComp.layout();
        this.wSetupTab.setControl((Control)wSetupComp);
    }

    private void toggleVisibility(boolean isDirect) {
        this.wlBootstrapServers.setVisible(isDirect);
        this.wBootstrapServers.setVisible(isDirect);
        this.wlClusterName.setVisible(!isDirect);
        this.wClusterName.setVisible(!isDirect);
    }

    private void buildFieldsTab() {
        CTabItem wFieldsTab = new CTabItem(this.wTabFolder, 0, 2);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.FieldsTab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        FormData fieldsFormData = new FormData();
        fieldsFormData.left = new FormAttachment(0, 0);
        fieldsFormData.top = new FormAttachment((Control)wFieldsComp, 0);
        fieldsFormData.right = new FormAttachment(100, 0);
        fieldsFormData.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fieldsFormData);
        this.buildFieldTable(wFieldsComp, (Control)wFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void buildOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OptionsTab", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wOptionsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wOptionsComp.setLayout((Layout)fieldsLayout);
        FormData optionsFormData = new FormData();
        optionsFormData.left = new FormAttachment(0, 0);
        optionsFormData.top = new FormAttachment((Control)wOptionsComp, 0);
        optionsFormData.right = new FormAttachment(100, 0);
        optionsFormData.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)optionsFormData);
        this.buildOptionsTable(wOptionsComp);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void buildFieldTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getFieldColumns();
        int fieldCount = KafkaConsumerField.Name.values().length;
        this.fieldsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, fieldCount, true, this.lsMod, this.props, false);
        this.fieldsTable.setSortable(false);
        this.fieldsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(147);
            table.getColumn(2).setWidth(147);
            table.getColumn(3).setWidth(147);
        });
        this.populateFieldData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.right = new FormAttachment(100, 0);
        Arrays.stream(this.fieldsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.fieldsTable.setReadonly(true);
        this.fieldsTable.setLayoutData((Object)fdData);
    }

    private void buildOptionsTable(Composite parentWidget) {
        ColumnInfo[] columns = this.getOptionsColumns();
        if (this.consumerMeta.getConfig().size() == 0) {
            List<String> list = KafkaDialogHelper.getConsumerAdvancedConfigOptionNames();
            LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
            for (String item : list) {
                advancedConfig.put(item, (String)DEFAULT_OPTION_VALUES.getOrDefault((Object)item, (Object)""));
            }
            this.consumerMeta.setConfig(advancedConfig);
        }
        int fieldCount = this.consumerMeta.getConfig().size();
        this.optionsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        this.optionsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(220);
            table.getColumn(2).setWidth(220);
        });
        this.populateOptionsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        Arrays.stream(this.optionsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.optionsTable.setLayoutData((Object)fdData);
    }

    private ColumnInfo[] getFieldColumns() {
        KafkaConsumerField.Type[] values = KafkaConsumerField.Type.values();
        String[] supportedTypes = (String[])Arrays.stream(values).map(KafkaConsumerField.Type::toString).toArray(String[]::new);
        ColumnInfo referenceName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Ref", (String[])new String[0]), 1, false, true);
        ColumnInfo name = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo type = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Type", (String[])new String[0]), 2, supportedTypes, false);
        type.setDisabledListener(rowNumber -> {
            String ref = this.fieldsTable.getTable().getItem(rowNumber).getText(1);
            KafkaConsumerField.Name refName = KafkaConsumerField.Name.valueOf(ref.toUpperCase());
            return refName != KafkaConsumerField.Name.KEY && refName != KafkaConsumerField.Name.MESSAGE;
        });
        return new ColumnInfo[]{referenceName, name, type};
    }

    private ColumnInfo[] getOptionsColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.NameField", (String[])new String[0]), 1, false, false);
        ColumnInfo value = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Value", (String[])new String[0]), 1, false, false);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateFieldData() {
        List<KafkaConsumerField> fieldDefinitions = this.consumerMeta.getFieldDefinitions();
        int rowIndex = 0;
        for (KafkaConsumerField field : fieldDefinitions) {
            TableItem key = this.fieldsTable.getTable().getItem(rowIndex++);
            if (field.getKafkaName() != null) {
                key.setText(1, field.getKafkaName().toString());
            }
            if (field.getOutputName() != null) {
                key.setText(2, field.getOutputName());
            }
            if (field.getOutputType() == null) continue;
            key.setText(3, field.getOutputType().toString());
        }
    }

    private void populateOptionsData() {
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.consumerMeta.getConfig().entrySet()) {
            TableItem key = this.optionsTable.getTable().getItem(rowIndex++);
            key.setText(1, entry.getKey());
            key.setText(2, entry.getValue());
        }
    }

    private void populateTopicsData() {
        List<String> topics = this.consumerMeta.getTopics();
        int rowIndex = 0;
        for (String topic : topics) {
            TableItem key = this.topicsTable.getTable().getItem(rowIndex++);
            if (topic == null) continue;
            key.setText(1, topic);
        }
    }

    private void buildTopicsTable(Composite parentWidget, Control controlAbove, Control controlBelow) {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.NameField", (String[])new String[0]), 2, new String[1], false)};
        columns[0].setUsingVariables(true);
        int topicsCount = this.consumerMeta.getTopics().size();
        Listener lsFocusInTopic = e -> {
            CCombo ccom = (CCombo)e.widget;
            ComboVar cvar = (ComboVar)ccom.getParent();
            KafkaDialogHelper kdh = new KafkaDialogHelper(this.wClusterName, cvar, this.wbCluster, this.wBootstrapServers, this.kafkaFactory, this.consumerMeta.getNamedClusterService(), this.consumerMeta.getNamedClusterServiceLocator(), this.consumerMeta.getMetastoreLocator(), this.optionsTable, this.meta.getParentStepMeta());
            kdh.clusterNameChanged(e);
        };
        this.topicsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, topicsCount, false, this.lsMod, this.props, false, lsFocusInTopic);
        this.topicsTable.setSortable(false);
        this.topicsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(316);
        });
        this.populateTopicsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(controlAbove, 5);
        fdData.right = new FormAttachment(0, 337);
        fdData.bottom = new FormAttachment(controlBelow, -10, 128);
        Arrays.stream(this.topicsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.topicsTable.setLayoutData((Object)fdData);
    }

    protected void getData() {
        if (this.meta.getTransformationPath() != null) {
            this.wFileSection.wFileName.setText(this.meta.getTransformationPath());
        }
        try {
            List names = this.consumerMeta.getNamedClusterService().listNames((IMetaStore)this.spoonInstance.getMetaStore());
            this.wClusterName.setItems(names.toArray(new String[0]));
        }
        catch (MetaStoreException e) {
            this.log.logError("Failed to get defined named clusters", (Throwable)e);
        }
        if (this.consumerMeta.getClusterName() != null) {
            this.wClusterName.setText(this.consumerMeta.getClusterName());
        }
        if (this.consumerMeta.getDirectBootstrapServers() != null) {
            this.wBootstrapServers.setText(this.consumerMeta.getDirectBootstrapServers());
        }
        this.populateTopicsData();
        if (this.consumerMeta.getSubStep() != null) {
            this.wSubStep.setText(this.consumerMeta.getSubStep());
        }
        if (this.consumerMeta.getConsumerGroup() != null) {
            this.wConsumerGroup.setText(this.consumerMeta.getConsumerGroup());
        }
        if (this.meta.getBatchSize() != null) {
            this.wBatchSize.setText(this.meta.getBatchSize());
        }
        if (this.meta.getBatchDuration() != null) {
            this.wBatchDuration.setText(this.meta.getBatchDuration());
        }
        if (this.meta.getParallelism() != null) {
            this.wParallelism.setText(this.meta.getParallelism());
        }
        this.wbCluster.setSelection(!this.isDirect());
        this.wbDirect.setSelection(this.isDirect());
        this.toggleVisibility(this.isDirect());
        this.wbAutoCommit.setSelection(this.consumerMeta.isAutoCommit());
        this.wbManualCommit.setSelection(!this.consumerMeta.isAutoCommit());
        this.specificationMethod = this.meta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wFileSection.wFileName.setText(Const.NVL((String)this.meta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String fullPath = Const.NVL((String)this.meta.getDirectoryPath(), (String)"") + REPOS_DELIM + Const.NVL((String)this.meta.getTransName(), (String)"");
                this.wFileSection.wFileName.setText(fullPath);
                break;
            }
        }
        this.populateFieldData();
    }

    private boolean isDirect() {
        return KafkaConsumerInputMeta.ConnectionType.DIRECT.equals((Object)this.consumerMeta.getConnectionType());
    }

    protected void additionalOks(BaseStreamStepMeta meta) {
        this.setTopicsFromTable();
        this.consumerMeta.setClusterName(this.wClusterName.getText());
        this.consumerMeta.setConsumerGroup(this.wConsumerGroup.getText());
        this.consumerMeta.setConnectionType(this.wbDirect.getSelection() ? KafkaConsumerInputMeta.ConnectionType.DIRECT : KafkaConsumerInputMeta.ConnectionType.CLUSTER);
        this.consumerMeta.setDirectBootstrapServers(this.wBootstrapServers.getText());
        this.consumerMeta.setAutoCommit(this.wbAutoCommit.getSelection());
        this.setFieldsFromTable();
        this.setOptionsFromTable();
    }

    private void setFieldsFromTable() {
        int itemCount = this.fieldsTable.getItemCount();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = this.fieldsTable.getTable().getItem(rowIndex);
            String kafkaName = row.getText(1);
            String outputName = row.getText(2);
            String outputType = row.getText(3);
            try {
                KafkaConsumerField.Name ref = KafkaConsumerField.Name.valueOf(kafkaName.toUpperCase());
                KafkaConsumerField field = new KafkaConsumerField(ref, outputName, KafkaConsumerField.Type.valueOf(outputType));
                this.consumerMeta.setField(field);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (!this.isDebug()) continue;
                this.logDebug(e.getMessage(), new Object[]{e});
            }
        }
    }

    private void setTopicsFromTable() {
        int itemCount = this.topicsTable.getItemCount();
        ArrayList<String> tableTopics = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = this.topicsTable.getTable().getItem(rowIndex);
            String topic = row.getText(1);
            if ("".equals(topic) || tableTopics.indexOf(topic) != -1) continue;
            tableTopics.add(topic);
        }
        this.consumerMeta.setTopics(tableTopics);
    }

    private void setOptionsFromTable() {
        this.consumerMeta.setConfig(KafkaDialogHelper.getConfig(this.optionsTable));
    }
}

