/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import org.apache.kafka.clients.producer.ProducerRecord;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerField;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaFactory;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutputData;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutputMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class KafkaProducerOutput
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = KafkaConsumerInputMeta.class;
    private KafkaProducerOutputMeta meta;
    private KafkaProducerOutputData data;
    private KafkaFactory kafkaFactory;

    public KafkaProducerOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.setKafkaFactory(KafkaFactory.defaultFactory());
    }

    void setKafkaFactory(KafkaFactory factory) {
        this.kafkaFactory = factory;
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        super.init(stepMetaInterface, stepDataInterface);
        this.meta = (KafkaProducerOutputMeta)stepMetaInterface;
        this.data = (KafkaProducerOutputData)stepDataInterface;
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            if (this.data.kafkaProducer != null) {
                this.data.kafkaProducer.close();
            }
            return false;
        }
        if (this.first) {
            this.data.keyFieldIndex = this.getInputRowMeta().indexOfValue(this.environmentSubstitute(this.meta.getKeyField()));
            this.data.messageFieldIndex = this.getInputRowMeta().indexOfValue(this.environmentSubstitute(this.meta.getMessageField()));
            ValueMetaInterface keyValueMeta = this.getInputRowMeta().getValueMeta(this.data.keyFieldIndex);
            ValueMetaInterface msgValueMeta = this.getInputRowMeta().getValueMeta(this.data.messageFieldIndex);
            this.data.kafkaProducer = this.kafkaFactory.producer(this.meta, arg_0 -> ((KafkaProducerOutput)this).environmentSubstitute(arg_0), KafkaConsumerField.Type.fromValueMetaInterface(keyValueMeta), KafkaConsumerField.Type.fromValueMetaInterface(msgValueMeta));
            this.data.isOpen = true;
            this.first = false;
        }
        if (!this.data.isOpen) {
            return false;
        }
        ProducerRecord producerRecord = this.data.keyFieldIndex < 0 || r[this.data.keyFieldIndex] == null || StringUtil.isEmpty((String)r[this.data.keyFieldIndex].toString()) ? new ProducerRecord(this.environmentSubstitute(this.meta.getTopic()), r[this.data.messageFieldIndex]) : new ProducerRecord(this.environmentSubstitute(this.meta.getTopic()), r[this.data.keyFieldIndex], r[this.data.messageFieldIndex]);
        this.data.kafkaProducer.send(producerRecord);
        this.incrementLinesOutput();
        this.putRow(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"KafkaConsumerInput.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (this.data.kafkaProducer != null && this.data.isOpen) {
            this.data.isOpen = false;
            this.data.kafkaProducer.flush();
            this.data.kafkaProducer.close();
        }
    }
}

